/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.TwoInputSelection;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.util.BaseRowUtil;
import org.apache.flink.table.runtime.collector.HeaderCollector;
import org.apache.flink.table.runtime.fault.tolerant.TriggerableOperator;
import org.apache.flink.table.runtime.join.RowtimeComparator;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\teg\u0001B\u0001\u0003\u0001=\u00111\u0003V3na>\u0014\u0018\r\u001c*poRLW.\u001a&pS:T!a\u0001\u0003\u0002\t)|\u0017N\u001c\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u00012&\u000e#\u0011\u000bE1\u0002DH\u0013\u000e\u0003IQ!a\u0005\u000b\u0002\u0011Q|G.\u001a:b]RT!!\u0006\u0003\u0002\u000b\u0019\fW\u000f\u001c;\n\u0005]\u0011\"a\u0005+sS\u001e<WM]1cY\u0016|\u0005/\u001a:bi>\u0014\bCA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"aA!osB\u0011qdI\u0007\u0002A)\u0011\u0011EI\u0001\u0006gR\fG/\u001a\u0006\u0003\u000b!I!\u0001\n\u0011\u0003\u001bY{\u0017\u000e\u001a(b[\u0016\u001c\b/Y2f!\t1\u0013&D\u0001(\u0015\tAc!\u0001\u0006eCR\fgm\u001c:nCRL!AK\u0014\u0003\u000f\t\u000b7/\u001a*poB)AfM\u0013&K5\tQF\u0003\u0002/_\u0005Iq\u000e]3sCR|'o\u001d\u0006\u0003aE\n1!\u00199j\u0015\t\u0011\u0004\"A\u0005tiJ,\u0017-\\5oO&\u0011A'\f\u0002\u0017)^|\u0017J\u001c9viN#(/Z1n\u001fB,'/\u0019;peB\u0019a'O\u001e\u000e\u0003]R!\u0001\u000f\u0004\u0002\u000f\r|G-Z4f]&\u0011!h\u000e\u0002\t\u0007>l\u0007/\u001b7feB)AHQ\u0013&K5\tQH\u0003\u0002?\u007f\u0005Ia-\u001e8di&|gn\u001d\u0006\u0003\u0001\u0006\u000baaY8n[>t'B\u0001\u0019\t\u0013\t\u0019UH\u0001\tGY\u0006$(j\\5o\rVt7\r^5p]B\u0011Q\tS\u0007\u0002\r*\u0011qIB\u0001\u0005kRLG.\u0003\u0002J\r\n9Aj\\4hS:<\u0007\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\u0002\u00111,g\r\u001e+za\u0016\u00042!\u0014)&\u001b\u0005q%BA(@\u0003!!\u0018\u0010]3j]\u001a|\u0017BA)O\u0005=!\u0016\u0010]3J]\u001a|'/\\1uS>t\u0007\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\u0002\u0013ILw\r\u001b;UsB,\u0007\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\u0002\u001f\u001d,gNS8j]\u001a+hn\u0019(b[\u0016\u0004\"a\u0016.\u000f\u0005eA\u0016BA-\u001b\u0003\u0019\u0001&/\u001a3fM&\u00111\f\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005eS\u0002\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\u0002\u001f\u001d,gNS8j]\u001a+hnY\"pI\u0016D\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!Y\u0001\u0012Y\u00164G\u000fV5nK\u0006#HO]5ckR,\u0007CA\rc\u0013\t\u0019'DA\u0002J]RD\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006I!Y\u0001\u0013e&<\u0007\u000e\u001e+j[\u0016\fE\u000f\u001e:jEV$X\rC\u0003h\u0001\u0011\u0005\u0001.\u0001\u0004=S:LGO\u0010\u000b\bS.dWN\\8q!\tQ\u0007!D\u0001\u0003\u0011\u0015Ye\r1\u0001M\u0011\u0015\u0019f\r1\u0001M\u0011\u0015)f\r1\u0001W\u0011\u0015qf\r1\u0001W\u0011\u0015\u0001g\r1\u0001b\u0011\u0015)g\r1\u0001b\u0011\u001d\u0011\bA1A\u0005\nM\f!DT#Y)~cUI\u0012+`\u0013:#U\tW0T)\u0006#Vi\u0018(B\u001b\u0016+\u0012\u0001\u001e\t\u0003kjl\u0011A\u001e\u0006\u0003ob\fA\u0001\\1oO*\t\u00110\u0001\u0003kCZ\f\u0017BA.w\u0011\u0019a\b\u0001)A\u0005i\u0006Yb*\u0012-U?2+e\tV0J\u001d\u0012+\u0005lX*U\u0003R+uLT!N\u000b\u0002BqA \u0001C\u0002\u0013%1/A\bM\u000b\u001a#vl\u0015+B)\u0016{f*Q'F\u0011\u001d\t\t\u0001\u0001Q\u0001\nQ\f\u0001\u0003T#G)~\u001bF+\u0011+F?:\u000bU*\u0012\u0011\t\u0011\u0005\u0015\u0001A1A\u0005\nM\f\u0001CU%H\u0011R{6\u000bV!U\u000b~s\u0015)T#\t\u000f\u0005%\u0001\u0001)A\u0005i\u0006\t\"+S$I)~\u001bF+\u0011+F?:\u000bU*\u0012\u0011\t\u0011\u00055\u0001A1A\u0005\nM\f1DU#H\u0013N#VIU#E?RKU*\u0012*`'R\u000bE+R0O\u00036+\u0005bBA\t\u0001\u0001\u0006I\u0001^\u0001\u001d%\u0016;\u0015j\u0015+F%\u0016#u\fV%N\u000bJ{6\u000bV!U\u000b~s\u0015)T#!\u0011!\t)\u0002\u0001b\u0001\n\u0013\u0019\u0018!\u0005+J\u001b\u0016\u00136kX*U\u0003R+uLT!N\u000b\"9\u0011\u0011\u0004\u0001!\u0002\u0013!\u0018A\u0005+J\u001b\u0016\u00136kX*U\u0003R+uLT!N\u000b\u0002B\u0011\"!\b\u0001\u0005\u0004%I!a\b\u0002-ILw\r\u001b;S_^$\u0018.\\3D_6\u0004\u0018M]1u_J,\"!!\t\u0011\u0007)\f\u0019#C\u0002\u0002&\t\u0011\u0011CU8xi&lWmQ8na\u0006\u0014\u0018\r^8s\u0011!\tI\u0003\u0001Q\u0001\n\u0005\u0005\u0012a\u0006:jO\"$(k\\<uS6,7i\\7qCJ\fGo\u001c:!\u0011-\ti\u0003\u0001a\u0001\u0002\u0004%I!a\f\u0002\u001b9,\u0007\u0010\u001e'fMRLe\u000eZ3y+\t\t\t\u0004\u0005\u0004\u00024\u0005]\u00121H\u0007\u0003\u0003kQ!!I \n\t\u0005e\u0012Q\u0007\u0002\u000b-\u0006dW/Z*uCR,\u0007cA;\u0002>%\u0019\u0011q\b<\u0003\t1{gn\u001a\u0005\f\u0003\u0007\u0002\u0001\u0019!a\u0001\n\u0013\t)%A\toKb$H*\u001a4u\u0013:$W\r_0%KF$B!a\u0012\u0002NA\u0019\u0011$!\u0013\n\u0007\u0005-#D\u0001\u0003V]&$\bBCA(\u0003\u0003\n\t\u00111\u0001\u00022\u0005\u0019\u0001\u0010J\u0019\t\u0011\u0005M\u0003\u0001)Q\u0005\u0003c\taB\\3yi2+g\r^%oI\u0016D\b\u0005C\u0006\u0002X\u0001\u0001\r\u00111A\u0005\n\u0005e\u0013!\u00037fMR\u001cF/\u0019;f+\t\tY\u0006E\u0004\u00024\u0005u\u00131H\u0013\n\t\u0005}\u0013Q\u0007\u0002\t\u001b\u0006\u00048\u000b^1uK\"Y\u00111\r\u0001A\u0002\u0003\u0007I\u0011BA3\u00035aWM\u001a;Ti\u0006$Xm\u0018\u0013fcR!\u0011qIA4\u0011)\ty%!\u0019\u0002\u0002\u0003\u0007\u00111\f\u0005\t\u0003W\u0002\u0001\u0015)\u0003\u0002\\\u0005QA.\u001a4u'R\fG/\u001a\u0011\t\u0017\u0005=\u0004\u00011AA\u0002\u0013%\u0011\u0011L\u0001\u000be&<\u0007\u000e^*uCR,\u0007bCA:\u0001\u0001\u0007\t\u0019!C\u0005\u0003k\naB]5hQR\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0003\u0002H\u0005]\u0004BCA(\u0003c\n\t\u00111\u0001\u0002\\!A\u00111\u0010\u0001!B\u0013\tY&A\u0006sS\u001eDGo\u0015;bi\u0016\u0004\u0003bCA@\u0001\u0001\u0007\t\u0019!C\u0005\u0003_\tqB]3hSN$XM]3e)&lWM\u001d\u0005\f\u0003\u0007\u0003\u0001\u0019!a\u0001\n\u0013\t))A\nsK\u001eL7\u000f^3sK\u0012$\u0016.\\3s?\u0012*\u0017\u000f\u0006\u0003\u0002H\u0005\u001d\u0005BCA(\u0003\u0003\u000b\t\u00111\u0001\u00022!A\u00111\u0012\u0001!B\u0013\t\t$\u0001\tsK\u001eL7\u000f^3sK\u0012$\u0016.\\3sA!Y\u0011q\u0012\u0001A\u0002\u0003\u0007I\u0011CAI\u0003=AW-\u00193fe\u000e{G\u000e\\3di>\u0014XCAAJ!\u0015\t)*a'&\u001b\t\t9JC\u0002\u0002\u001a\u0012\t\u0011bY8mY\u0016\u001cGo\u001c:\n\t\u0005u\u0015q\u0013\u0002\u0010\u0011\u0016\fG-\u001a:D_2dWm\u0019;pe\"Y\u0011\u0011\u0015\u0001A\u0002\u0003\u0007I\u0011CAR\u0003MAW-\u00193fe\u000e{G\u000e\\3di>\u0014x\fJ3r)\u0011\t9%!*\t\u0015\u0005=\u0013qTA\u0001\u0002\u0004\t\u0019\n\u0003\u0005\u0002*\u0002\u0001\u000b\u0015BAJ\u0003AAW-\u00193fe\u000e{G\u000e\\3di>\u0014\b\u0005C\u0006\u0002\u001a\u0002\u0001\r\u00111A\u0005\n\u00055VCAAX!\u0011a\u0013\u0011W\u0013\n\u0007\u0005MVF\u0001\u000bUS6,7\u000f^1na\u0016$7i\u001c7mK\u000e$xN\u001d\u0005\f\u0003o\u0003\u0001\u0019!a\u0001\n\u0013\tI,A\u0007d_2dWm\u0019;pe~#S-\u001d\u000b\u0005\u0003\u000f\nY\f\u0003\u0006\u0002P\u0005U\u0016\u0011!a\u0001\u0003_C\u0001\"a0\u0001A\u0003&\u0011qV\u0001\u000bG>dG.Z2u_J\u0004\u0003bCAb\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000b\fA\u0002^5nKJ\u001cVM\u001d<jG\u0016,\"!a2\u0011\t1\nIMH\u0005\u0004\u0003\u0017l#\u0001F%oi\u0016\u0014h.\u00197US6,'oU3sm&\u001cW\rC\u0006\u0002P\u0002\u0001\r\u00111A\u0005\n\u0005E\u0017\u0001\u0005;j[\u0016\u00148+\u001a:wS\u000e,w\fJ3r)\u0011\t9%a5\t\u0015\u0005=\u0013QZA\u0001\u0002\u0004\t9\r\u0003\u0005\u0002X\u0002\u0001\u000b\u0015BAd\u00035!\u0018.\\3s'\u0016\u0014h/[2fA!Y\u00111\u001c\u0001A\u0002\u0003\u0007I\u0011BAo\u00031Qw.\u001b8Gk:\u001cG/[8o+\u0005Y\u0004bCAq\u0001\u0001\u0007\t\u0019!C\u0005\u0003G\f\u0001C[8j]\u001a+hn\u0019;j_:|F%Z9\u0015\t\u0005\u001d\u0013Q\u001d\u0005\n\u0003\u001f\ny.!AA\u0002mBq!!;\u0001A\u0003&1(A\u0007k_&tg)\u001e8di&|g\u000e\t\u0005\b\u0003[\u0004A\u0011IAx\u0003\u0011y\u0007/\u001a8\u0015\u0005\u0005\u001d\u0003bBAz\u0001\u0011\u0005\u0013Q_\u0001\u0010aJ|7-Z:t\u000b2,W.\u001a8ucQ!\u0011q_A\u007f!\ra\u0013\u0011`\u0005\u0004\u0003wl#!\u0005+x_&s\u0007/\u001e;TK2,7\r^5p]\"A\u0011q`Ay\u0001\u0004\u0011\t!A\u0004fY\u0016lWM\u001c;\u0011\u000b\t\r!1B\u0013\u000e\u0005\t\u0015!\u0002\u0002B\u0004\u0005\u0013\tAb\u001d;sK\u0006l'/Z2pe\u0012T!!B\u0019\n\t\t5!Q\u0001\u0002\r'R\u0014X-Y7SK\u000e|'\u000f\u001a\u0005\b\u0005#\u0001A\u0011\tB\n\u0003=\u0001(o\\2fgN,E.Z7f]R\u0014D\u0003BA|\u0005+A\u0001\"a@\u0003\u0010\u0001\u0007!\u0011\u0001\u0005\b\u00053\u0001A\u0011\u0002B\u000e\u0003U\u0011XmZ5ti\u0016\u00148+\\1mY\u0016\u001cH\u000fV5nKJ$B!a\u0012\u0003\u001e!A!q\u0004B\f\u0001\u0004\u0011\t#A\u0005uS6,7\u000f^1naB\u0019\u0011Da\t\n\u0007\u0005}\"\u0004C\u0004\u0003(\u0001!IA!\u000b\u0002\u001bI,w-[:uKJ$\u0016.\\3s)\u0011\t9Ea\u000b\t\u0011\t}!Q\u0005a\u0001\u0005CAqAa\f\u0001\t\u0003\u0012\t$\u0001\tp]B\u0013xnY3tg&tw\rV5nKR!\u0011q\tB\u001a\u0011!\u0011)D!\fA\u0002\t]\u0012!\u0002;j[\u0016\u0014\b#\u0002\u0017\u0003:aq\u0012b\u0001B\u001e[\ti\u0011J\u001c;fe:\fG\u000eV5nKJDqAa\u0010\u0001\t\u0003\u0012\t%A\u0006p]\u00163XM\u001c;US6,G\u0003BA$\u0005\u0007B\u0001B!\u000e\u0003>\u0001\u0007!q\u0007\u0005\b\u0005\u000f\u0002A\u0011\u0002B%\u0003e)W.\u001b;SKN,H\u000e^!oI\u000ecW-\u00198VaN#\u0018\r^3\u0015\t\t\u0005\"1\n\u0005\t\u0005\u001b\u0012)\u00051\u0001\u0003\"\u0005qA/[7feRKW.Z:uC6\u0004\bb\u0002B)\u0001\u0011%!1K\u0001\rG2,\u0017M\\+q'R\fG/\u001a\u000b\u0007\u0003\u000f\u0012)Fa\u0016\t\u0011\t5#q\na\u0001\u0005CA\u0001B!\u0017\u0003P\u0001\u0007!1L\u0001\u0010e&<\u0007\u000e\u001e*poN\u001cvN\u001d;fIB)!Q\fB1K5\u0011!q\f\u0006\u0003\u000fbLAAa\u0019\u0003`\t!A*[:u\u0011\u001d\u00119\u0007\u0001C\u0005\u0005S\n\u0001CZ5sgRLe\u000eZ3y)>\\U-\u001a9\u0015\u000b\u0005\u0014YG!\u001c\t\u0011\t5#Q\ra\u0001\u0005CA\u0001B!\u0017\u0003f\u0001\u0007!1\f\u0005\b\u0005c\u0002A\u0011\u0002B:\u0003\u0005Jg\u000eZ3y\u001f\u001a4\u0015N]:u\u000b2,W.\u001a8u\u001d\u0016<XM\u001d+iC:$\u0016.\\3s)\u0015\t'Q\u000fB<\u0011!\u0011iEa\u001cA\u0002\t\u0005\u0002\u0002\u0003B=\u0005_\u0002\rAa\u0017\u0002\t1L7\u000f\u001e\u0005\b\u0005{\u0002A\u0011\u0002B@\u0003Qa\u0017\r^3tiJKw\r\u001b;S_^$vNS8j]R1!\u0011\u0011BD\u0005\u0013\u0003RA!\u0018\u0003\u0004\u0016JAA!\"\u0003`\tAq\n\u001d;j_:\fG\u000e\u0003\u0005\u0003Z\tm\u0004\u0019\u0001B.\u0011!\u0011YIa\u001fA\u0002\t\u0005\u0012\u0001\u00037fMR$\u0016.\\3\t\u000f\tu\u0004\u0001\"\u0003\u0003\u0010RQ!\u0011\u0011BI\u0005'\u00139Ja'\t\u0011\te#Q\u0012a\u0001\u00057BqA!&\u0003\u000e\u0002\u0007\u0011-A\u0002m_^DqA!'\u0003\u000e\u0002\u0007\u0011-\u0001\u0003iS\u001eD\u0007\u0002\u0003BF\u0005\u001b\u0003\rA!\t\t\u000f\t}\u0005\u0001\"\u0003\u0003\"\u0006\u0011r-\u001a;SS\u001eDGOU8xgN{'\u000f^3e)\u0011\u0011YFa)\t\u0011\t\u0015&Q\u0014a\u0001\u0003C\t\u0011C]8xi&lWmQ8na\u0006\u0014\u0018\r^8s\u0011\u001d\u0011I\u000b\u0001C\u0005\u0005W\u000b\u0001cZ3u\u001d\u0016DH\u000fT3gi&sG-\u001a=\u0016\u0005\u0005m\u0002b\u0002BX\u0001\u0011%!\u0011W\u0001\fO\u0016$H*\u001a4u)&lW\r\u0006\u0003\u0003\"\tM\u0006b\u0002B[\u0005[\u0003\r!J\u0001\bY\u00164GOU8x\u0011\u001d\u0011I\f\u0001C\u0005\u0005w\u000bAbZ3u%&<\u0007\u000e\u001e+j[\u0016$BA!\t\u0003>\"9!q\u0018B\\\u0001\u0004)\u0013\u0001\u0003:jO\"$(k\\<\t\u000f\t\r\u0007\u0001\"\u0003\u0003F\u0006\u00112\r[3dW:{GOU3ue\u0006\u001cG/[8o)\u0011\t9Ea2\t\u000f\t%'\u0011\u0019a\u0001K\u0005\u0019!o\\<\t\u000f\t5\u0007\u0001\"\u0011\u0003P\u0006\u0019b-\u001b:ti&s\u0007/\u001e;TK2,7\r^5p]R\u0011\u0011q\u001f\u0005\b\u0005'\u0004A\u0011IAx\u0003%)g\u000eZ%oaV$\u0018\u0007C\u0004\u0003X\u0002!\t%a<\u0002\u0013\u0015tG-\u00138qkR\u0014\u0004")
public class TemporalRowtimeJoin
extends TriggerableOperator<Object, VoidNamespace, BaseRow>
implements TwoInputStreamOperator<BaseRow, BaseRow, BaseRow>,
Compiler<FlatJoinFunction<BaseRow, BaseRow, BaseRow>>,
Logging {
    private final TypeInformation<BaseRow> leftType;
    private final TypeInformation<BaseRow> rightType;
    private final String genJoinFuncName;
    private final String genJoinFuncCode;
    private final int leftTimeAttribute;
    private final int rightTimeAttribute;
    private final String NEXT_LEFT_INDEX_STATE_NAME;
    private final String LEFT_STATE_NAME;
    private final String RIGHT_STATE_NAME;
    private final String REGISTERED_TIMER_STATE_NAME;
    private final String TIMERS_STATE_NAME;
    private final RowtimeComparator rightRowtimeComparator;
    private ValueState<Long> nextLeftIndex;
    private MapState<Long, BaseRow> leftState;
    private MapState<Long, BaseRow> rightState;
    private ValueState<Long> registeredTimer;
    private HeaderCollector<BaseRow> headerCollector;
    private TimestampedCollector<BaseRow> collector;
    private InternalTimerService<VoidNamespace> timerService;
    private FlatJoinFunction<BaseRow, BaseRow, BaseRow> joinFunction;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        TemporalRowtimeJoin temporalRowtimeJoin = this;
        synchronized (temporalRowtimeJoin) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<FlatJoinFunction<BaseRow, BaseRow, BaseRow>> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private String NEXT_LEFT_INDEX_STATE_NAME() {
        return this.NEXT_LEFT_INDEX_STATE_NAME;
    }

    private String LEFT_STATE_NAME() {
        return this.LEFT_STATE_NAME;
    }

    private String RIGHT_STATE_NAME() {
        return this.RIGHT_STATE_NAME;
    }

    private String REGISTERED_TIMER_STATE_NAME() {
        return this.REGISTERED_TIMER_STATE_NAME;
    }

    private String TIMERS_STATE_NAME() {
        return this.TIMERS_STATE_NAME;
    }

    private RowtimeComparator rightRowtimeComparator() {
        return this.rightRowtimeComparator;
    }

    private ValueState<Long> nextLeftIndex() {
        return this.nextLeftIndex;
    }

    private void nextLeftIndex_$eq(ValueState<Long> x$1) {
        this.nextLeftIndex = x$1;
    }

    private MapState<Long, BaseRow> leftState() {
        return this.leftState;
    }

    private void leftState_$eq(MapState<Long, BaseRow> x$1) {
        this.leftState = x$1;
    }

    private MapState<Long, BaseRow> rightState() {
        return this.rightState;
    }

    private void rightState_$eq(MapState<Long, BaseRow> x$1) {
        this.rightState = x$1;
    }

    private ValueState<Long> registeredTimer() {
        return this.registeredTimer;
    }

    private void registeredTimer_$eq(ValueState<Long> x$1) {
        this.registeredTimer = x$1;
    }

    public HeaderCollector<BaseRow> headerCollector() {
        return this.headerCollector;
    }

    public void headerCollector_$eq(HeaderCollector<BaseRow> x$1) {
        this.headerCollector = x$1;
    }

    private TimestampedCollector<BaseRow> collector() {
        return this.collector;
    }

    private void collector_$eq(TimestampedCollector<BaseRow> x$1) {
        this.collector = x$1;
    }

    private InternalTimerService<VoidNamespace> timerService() {
        return this.timerService;
    }

    private void timerService_$eq(InternalTimerService<VoidNamespace> x$1) {
        this.timerService = x$1;
    }

    private FlatJoinFunction<BaseRow, BaseRow, BaseRow> joinFunction() {
        return this.joinFunction;
    }

    private void joinFunction_$eq(FlatJoinFunction<BaseRow, BaseRow, BaseRow> x$1) {
        this.joinFunction = x$1;
    }

    @Override
    public void open() {
        Class<FlatJoinFunction<BaseRow, BaseRow, BaseRow>> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genJoinFuncName, this.genJoinFuncCode);
        this.joinFunction_$eq(clazz.newInstance());
        FunctionUtils.setFunctionRuntimeContext(this.joinFunction(), (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.joinFunction(), new Configuration());
        this.nextLeftIndex_$eq(this.getRuntimeContext().getState(new ValueStateDescriptor<Long>(this.NEXT_LEFT_INDEX_STATE_NAME(), BasicTypeInfo.LONG_TYPE_INFO)));
        this.leftState_$eq(this.getRuntimeContext().getMapState(new MapStateDescriptor<Long, BaseRow>(this.LEFT_STATE_NAME(), (TypeInformation<Long>)BasicTypeInfo.LONG_TYPE_INFO, this.leftType)));
        this.rightState_$eq(this.getRuntimeContext().getMapState(new MapStateDescriptor<Long, BaseRow>(this.RIGHT_STATE_NAME(), (TypeInformation<Long>)BasicTypeInfo.LONG_TYPE_INFO, this.rightType)));
        this.registeredTimer_$eq(this.getRuntimeContext().getState(new ValueStateDescriptor<Long>(this.REGISTERED_TIMER_STATE_NAME(), BasicTypeInfo.LONG_TYPE_INFO)));
        this.collector_$eq((TimestampedCollector<BaseRow>)new TimestampedCollector(this.output));
        this.headerCollector_$eq(new HeaderCollector<BaseRow>());
        this.headerCollector().out_$eq((Collector<BaseRow>)this.collector());
        this.headerCollector().setHeader((byte)0);
        this.timerService_$eq(this.getInternalTimerService(this.TIMERS_STATE_NAME(), VoidNamespaceSerializer.INSTANCE, this));
    }

    public TwoInputSelection processElement1(StreamRecord<BaseRow> element) {
        BaseRow row2 = (BaseRow)element.getValue();
        this.checkNotRetraction(row2);
        this.leftState().put(this.getNextLeftIndex(), row2);
        this.registerSmallestTimer(this.getLeftTime(row2));
        return TwoInputSelection.ANY;
    }

    public TwoInputSelection processElement2(StreamRecord<BaseRow> element) {
        BaseRow row2 = (BaseRow)element.getValue();
        this.checkNotRetraction(row2);
        long rowTime = this.getRightTime(row2);
        this.rightState().put(Predef$.MODULE$.long2Long(rowTime), row2);
        this.registerSmallestTimer(rowTime);
        return TwoInputSelection.ANY;
    }

    private void registerSmallestTimer(long timestamp) {
        Long currentRegisteredTimer = this.registeredTimer().value();
        if (currentRegisteredTimer == null) {
            this.registerTimer(timestamp);
        } else if (currentRegisteredTimer != null && Predef$.MODULE$.Long2long(currentRegisteredTimer) > timestamp) {
            this.timerService().deleteEventTimeTimer((Object)VoidNamespace.INSTANCE, Predef$.MODULE$.Long2long(currentRegisteredTimer));
            this.registerTimer(timestamp);
        }
    }

    private void registerTimer(long timestamp) {
        this.registeredTimer().update(Predef$.MODULE$.long2Long(timestamp));
        this.timerService().registerEventTimeTimer((Object)VoidNamespace.INSTANCE, timestamp);
    }

    public void onProcessingTime(InternalTimer<Object, VoidNamespace> timer) {
        throw new IllegalStateException("This should never happen");
    }

    public void onEventTime(InternalTimer<Object, VoidNamespace> timer) {
        this.registeredTimer().clear();
        long lastUnprocessedTime = this.emitResultAndCleanUpState(this.timerService().currentWatermark());
        if (lastUnprocessedTime < Long.MAX_VALUE) {
            this.registerTimer(lastUnprocessedTime);
        }
    }

    private long emitResultAndCleanUpState(long timerTimestamp) {
        List<BaseRow> rightRowsSorted = this.getRightRowsSorted(this.rightRowtimeComparator());
        long lastUnprocessedTime = Long.MAX_VALUE;
        Iterator<Map.Entry<Long, BaseRow>> leftIterator = this.leftState().entries().iterator();
        while (leftIterator.hasNext()) {
            Map.Entry<Long, BaseRow> leftEntry = leftIterator.next();
            BaseRow leftRow = leftEntry.getValue();
            long leftTime = this.getLeftTime(leftRow);
            if (leftTime <= timerTimestamp) {
                Optional<BaseRow> rightRow = this.latestRightRowToJoin(rightRowsSorted, leftTime);
                if (rightRow.isPresent()) {
                    this.joinFunction().join(leftRow, rightRow.get(), this.headerCollector());
                }
                leftIterator.remove();
                continue;
            }
            lastUnprocessedTime = Math.min(lastUnprocessedTime, leftTime);
        }
        this.cleanUpState(timerTimestamp, rightRowsSorted);
        return lastUnprocessedTime;
    }

    private void cleanUpState(long timerTimestamp, List<BaseRow> rightRowsSorted) {
        int indexToKeep = this.firstIndexToKeep(timerTimestamp, rightRowsSorted);
        for (int i = 0; i < indexToKeep; ++i) {
            long rightTime = this.getRightTime(rightRowsSorted.get(i));
            this.rightState().remove(Predef$.MODULE$.long2Long(rightTime));
        }
    }

    private int firstIndexToKeep(long timerTimestamp, List<BaseRow> rightRowsSorted) {
        int firstIndexNewerThenTimer = this.indexOfFirstElementNewerThanTimer(timerTimestamp, rightRowsSorted);
        return firstIndexNewerThenTimer < 0 ? rightRowsSorted.size() - 1 : firstIndexNewerThenTimer - 1;
    }

    private int indexOfFirstElementNewerThanTimer(long timerTimestamp, List<BaseRow> list) {
        ListIterator<BaseRow> iter = list.listIterator();
        while (iter.hasNext()) {
            if (this.getRightTime(iter.next()) <= timerTimestamp) continue;
            return iter.previousIndex();
        }
        return -1;
    }

    private Optional<BaseRow> latestRightRowToJoin(List<BaseRow> rightRowsSorted, long leftTime) {
        return this.latestRightRowToJoin(rightRowsSorted, 0, rightRowsSorted.size() - 1, leftTime);
    }

    private Optional<BaseRow> latestRightRowToJoin(List<BaseRow> rightRowsSorted, int low, int high, long leftTime) {
        Optional<BaseRow> optional;
        block3: {
            BaseRow midRow;
            while (true) {
                if (low > high) {
                    optional = low - 1 < 0 ? Optional.empty() : Optional.of(rightRowsSorted.get(low - 1));
                    break block3;
                }
                int mid = low + high >>> 1;
                midRow = rightRowsSorted.get(mid);
                long midTime = this.getRightTime(midRow);
                int cmp = Predef$.MODULE$.long2Long(midTime).compareTo(Predef$.MODULE$.long2Long(leftTime));
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp <= 0) break;
                high = mid - 1;
            }
            optional = Optional.of(midRow);
        }
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    private List<BaseRow> getRightRowsSorted(RowtimeComparator rowtimeComparator) {
        void var2_2;
        ArrayList<BaseRow> rightRows = new ArrayList<BaseRow>();
        JavaConversions$.MODULE$.iterableAsScalaIterable(this.rightState().values()).foreach((Function1)new Serializable(this, rightRows){
            public static final long serialVersionUID = 0L;
            private final ArrayList rightRows$1;

            public final boolean apply(BaseRow row2) {
                return this.rightRows$1.add(row2);
            }
            {
                this.rightRows$1 = rightRows$1;
            }
        });
        rightRows.sort(rowtimeComparator);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Long getNextLeftIndex() {
        void var1_1;
        Long index = this.nextLeftIndex().value();
        if (index == null) {
            index = Predef$.MODULE$.long2Long(0L);
        }
        this.nextLeftIndex().update(Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(index) + 1L));
        return var1_1;
    }

    private long getLeftTime(BaseRow leftRow) {
        return leftRow.getLong(this.leftTimeAttribute);
    }

    private long getRightTime(BaseRow rightRow) {
        return rightRow.getLong(this.rightTimeAttribute);
    }

    private void checkNotRetraction(BaseRow row2) {
        if (BaseRowUtil.isRetractMsg(row2)) {
            throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retractions are not supported by [", "]. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TemporalRowtimeJoin.class.getSimpleName()}))).append((Object)"If this can happen it should be validated during planning!").toString());
        }
    }

    public TwoInputSelection firstInputSelection() {
        return TwoInputSelection.ANY;
    }

    public void endInput1() {
    }

    public void endInput2() {
    }

    public TemporalRowtimeJoin(TypeInformation<BaseRow> leftType, TypeInformation<BaseRow> rightType, String genJoinFuncName, String genJoinFuncCode, int leftTimeAttribute, int rightTimeAttribute) {
        this.leftType = leftType;
        this.rightType = rightType;
        this.genJoinFuncName = genJoinFuncName;
        this.genJoinFuncCode = genJoinFuncCode;
        this.leftTimeAttribute = leftTimeAttribute;
        this.rightTimeAttribute = rightTimeAttribute;
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
        this.NEXT_LEFT_INDEX_STATE_NAME = "next-index";
        this.LEFT_STATE_NAME = "left";
        this.RIGHT_STATE_NAME = "right";
        this.REGISTERED_TIMER_STATE_NAME = "timer";
        this.TIMERS_STATE_NAME = "timers";
        this.rightRowtimeComparator = new RowtimeComparator(rightTimeAttribute);
    }
}

