/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join.batch;

import java.util.BitSet;
import org.apache.flink.table.codegen.JoinConditionFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.runtime.join.batch.SortMergeFullOuterJoinIterator;
import org.apache.flink.table.runtime.join.batch.SortMergeInnerJoinIterator;
import org.apache.flink.table.runtime.join.batch.SortMergeOneSideOuterJoinIterator;
import org.apache.flink.table.runtime.util.ResettableListBuffer;
import org.apache.flink.util.Collector;

public class SortMergeJoinHelper {
    private final Collector<BaseRow> collector;
    private final JoinConditionFunction condFunc;
    private final BaseRow leftNullRow;
    private final BaseRow rightNullRow;
    private final JoinedRow joinedRow;

    public SortMergeJoinHelper(Collector<BaseRow> collector, JoinConditionFunction condFunc, BaseRow leftNullRow, BaseRow rightNullRow, JoinedRow joinedRow) {
        this.collector = collector;
        this.condFunc = condFunc;
        this.leftNullRow = leftNullRow;
        this.rightNullRow = rightNullRow;
        this.joinedRow = joinedRow;
    }

    public void innerJoin(SortMergeInnerJoinIterator iterator, boolean reverseInvoke) throws Exception {
        while (iterator.nextInnerJoin()) {
            BaseRow probeRow = iterator.getProbeRow();
            ResettableListBuffer.BufferIterator iter = iterator.getMatchBuffer().newIterator();
            while (iter.advanceNext()) {
                BaseRow row2 = iter.getRow();
                this.joinWithCondition(probeRow, row2, reverseInvoke);
            }
            iter.close();
        }
    }

    public void oneSideOuterJoin(SortMergeOneSideOuterJoinIterator iterator, boolean reverseInvoke, BaseRow buildNullRow) throws Exception {
        while (iterator.nextOuterJoin()) {
            BaseRow probeRow = iterator.getProbeRow();
            boolean found = false;
            if (iterator.getMatchKey() != null) {
                ResettableListBuffer.BufferIterator iter = iterator.getMatchBuffer().newIterator();
                while (iter.advanceNext()) {
                    BaseRow row2 = iter.getRow();
                    found |= this.joinWithCondition(probeRow, row2, reverseInvoke);
                }
                iter.close();
            }
            if (found) continue;
            this.collect(probeRow, buildNullRow, reverseInvoke);
        }
    }

    public void fullOuterJoin(SortMergeFullOuterJoinIterator iterator) throws Exception {
        BitSet bitSet = new BitSet();
        while (iterator.nextOuterJoin()) {
            ResettableListBuffer.BufferIterator iter;
            bitSet.clear();
            BinaryRow matchKey = iterator.getMatchKey();
            ResettableListBuffer buffer1 = iterator.getBuffer1();
            ResettableListBuffer buffer2 = iterator.getBuffer2();
            if (matchKey == null && buffer1.size() > 0) {
                iter = buffer1.newIterator();
                while (iter.advanceNext()) {
                    BaseRow row1 = iter.getRow();
                    this.collector.collect(this.joinedRow.replace(row1, this.rightNullRow));
                }
                iter.close();
                continue;
            }
            if (matchKey == null && buffer2.size() > 0) {
                iter = buffer2.newIterator();
                while (iter.advanceNext()) {
                    BaseRow row2 = iter.getRow();
                    this.collector.collect(this.joinedRow.replace(this.leftNullRow, row2));
                }
                iter.close();
                continue;
            }
            if (matchKey != null) {
                ResettableListBuffer.BufferIterator iter1 = buffer1.newIterator();
                while (iter1.advanceNext()) {
                    BaseRow row1 = iter1.getRow();
                    boolean found = false;
                    int index = 0;
                    ResettableListBuffer.BufferIterator iter2 = buffer2.newIterator();
                    while (iter2.advanceNext()) {
                        BaseRow row2 = iter2.getRow();
                        if (this.condFunc.apply(row1, row2)) {
                            this.collector.collect(this.joinedRow.replace(row1, row2));
                            found = true;
                            bitSet.set(index);
                        }
                        ++index;
                    }
                    iter2.close();
                    if (found) continue;
                    this.collector.collect(this.joinedRow.replace(row1, this.rightNullRow));
                }
                iter1.close();
                int index = 0;
                ResettableListBuffer.BufferIterator iter2 = buffer2.newIterator();
                while (iter2.advanceNext()) {
                    BaseRow row2 = iter2.getRow();
                    if (!bitSet.get(index)) {
                        this.collector.collect(this.joinedRow.replace(this.leftNullRow, row2));
                    }
                    ++index;
                }
                iter2.close();
                continue;
            }
            throw new RuntimeException("There is a bug.");
        }
    }

    private boolean joinWithCondition(BaseRow row1, BaseRow row2, boolean reverseInvoke) throws Exception {
        if (reverseInvoke) {
            if (this.condFunc.apply(row2, row1)) {
                this.collector.collect(this.joinedRow.replace(row2, row1));
                return true;
            }
        } else if (this.condFunc.apply(row1, row2)) {
            this.collector.collect(this.joinedRow.replace(row1, row2));
            return true;
        }
        return false;
    }

    private void collect(BaseRow row1, BaseRow row2, boolean reverseInvoke) {
        if (reverseInvoke) {
            this.collector.collect(this.joinedRow.replace(row2, row1));
        } else {
            this.collector.collect(this.joinedRow.replace(row1, row2));
        }
    }
}

