/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join.batch;

import java.io.Closeable;
import java.io.IOException;
import org.apache.flink.table.codegen.Projection;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.join.batch.NullAwareJoinHelper;
import org.apache.flink.table.runtime.sort.RecordComparator;
import org.apache.flink.table.runtime.util.ResettableListBuffer;
import org.apache.flink.table.typeutils.BinaryRowSerializer;
import org.apache.flink.util.MutableObjectIterator;

public abstract class SortMergeJoinIterator
implements Closeable {
    private final Projection<BaseRow, BinaryRow> probeProjection;
    private final Projection<BinaryRow, BinaryRow> bufferedProjection;
    protected final RecordComparator keyComparator;
    private final MutableObjectIterator<BaseRow> probeIterator;
    private final MutableObjectIterator<BinaryRow> bufferedIterator;
    private BaseRow probeRow;
    protected BinaryRow probeKey;
    protected BinaryRow bufferedRow;
    protected BinaryRow bufferedKey;
    protected BinaryRow matchKey;
    protected ResettableListBuffer matchBuffer;
    private final int[] nullFilterKeys;
    private final boolean nullSafe;
    private final boolean filterAllNulls;

    public SortMergeJoinIterator(BinaryRowSerializer probeSerializer, BinaryRowSerializer bufferedSerializer, Projection probeProjection, Projection bufferedProjection, RecordComparator keyComparator, MutableObjectIterator<BaseRow> probeIterator, MutableObjectIterator<BinaryRow> bufferedIterator, ResettableListBuffer buffer, boolean[] filterNulls) throws IOException {
        this.probeProjection = probeProjection;
        this.bufferedProjection = bufferedProjection;
        this.keyComparator = keyComparator;
        this.probeIterator = probeIterator;
        this.bufferedIterator = bufferedIterator;
        this.probeRow = probeSerializer.createInstance();
        this.bufferedRow = bufferedSerializer.createInstance();
        this.matchBuffer = buffer;
        this.nullFilterKeys = NullAwareJoinHelper.getNullFilterKeys(filterNulls);
        this.nullSafe = this.nullFilterKeys.length == 0;
        this.filterAllNulls = this.nullFilterKeys.length == filterNulls.length;
        this.advanceNextSuitableBufferedRow();
    }

    protected boolean advanceNextSuitableProbeRow() throws IOException {
        while (this.nextProbe() && this.shouldFilter(this.probeKey)) {
        }
        return this.probeRow != null;
    }

    protected boolean advanceNextSuitableBufferedRow() throws IOException {
        while (this.nextBuffered() && this.shouldFilter(this.bufferedKey)) {
        }
        return this.bufferedRow != null;
    }

    private boolean shouldFilter(BinaryRow key) {
        return NullAwareJoinHelper.shouldFilter(this.nullSafe, this.filterAllNulls, this.nullFilterKeys, key);
    }

    protected boolean nextProbe() throws IOException {
        this.probeRow = this.probeIterator.next(this.probeRow);
        if (this.probeRow != null) {
            this.probeKey = this.probeProjection.apply(this.probeRow);
            return true;
        }
        this.probeRow = null;
        this.probeKey = null;
        return false;
    }

    private boolean nextBuffered() throws IOException {
        this.bufferedRow = this.bufferedIterator.next(this.bufferedRow);
        if (this.bufferedRow != null) {
            this.bufferedKey = this.bufferedProjection.apply(this.bufferedRow);
            return true;
        }
        this.bufferedRow = null;
        this.bufferedKey = null;
        return false;
    }

    protected void bufferMatchingRows() throws IOException {
        this.matchKey = this.probeKey.copy();
        this.matchBuffer.reset();
        do {
            this.matchBuffer.add(this.bufferedRow);
        } while (this.advanceNextSuitableBufferedRow() && this.keyComparator.compare(this.probeKey, this.bufferedKey) == 0);
    }

    public BaseRow getProbeRow() {
        return this.probeRow;
    }

    public BinaryRow getMatchKey() {
        return this.matchKey;
    }

    public ResettableListBuffer getMatchBuffer() {
        return this.matchBuffer;
    }

    @Override
    public void close() {
        this.matchBuffer.close();
    }
}

