/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join.stream;

import java.util.Iterator;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.TwoInputSelection;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.codegen.GeneratedJoinConditionFunction;
import org.apache.flink.table.codegen.GeneratedProjection;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.util.BaseRowUtil;
import org.apache.flink.table.runtime.join.stream.JoinStreamOperator;
import org.apache.flink.table.runtime.join.stream.state.JoinStateHandler;
import org.apache.flink.table.runtime.join.stream.state.match.JoinMatchStateHandler;
import org.apache.flink.table.runtime.join.stream.state.match.NonBatchOnlyEqualityConditionMatchStateHandler;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;

public class SemiAntiJoinStreamOperator
extends JoinStreamOperator {
    private boolean isAntiJoin;
    private final JoinMatchStateHandler.Type leftMatchStateType;
    private final boolean careLeftMatchTimes;
    protected final JoinStateHandler.Type leftEmitedJoinStateType;
    protected final JoinStateHandler.Type leftNotEmitedJoinStateType;
    private transient JoinStateHandler leftEmitedStateHandler;
    private transient JoinStateHandler leftNotEmitedStateHandler;
    private transient JoinMatchStateHandler leftMatchStateHandler;
    private boolean rightNotEmitRetraction;

    public SemiAntiJoinStreamOperator(BaseRowTypeInfo leftType, BaseRowTypeInfo rightType, GeneratedJoinConditionFunction condFuncCode, KeySelector<BaseRow, BaseRow> leftKeySelector, KeySelector<BaseRow, BaseRow> rightKeySelector, GeneratedProjection leftPkProjectCode, GeneratedProjection rightPkProjectCode, JoinStateHandler.Type leftJoinStateType, JoinStateHandler.Type rightJoinStateType, long maxRetentionTime, long minRetentionTime, boolean isAntiJoin, JoinMatchStateHandler.Type leftMatchStateType, boolean rightNotEmitRetraction, boolean[] filterNullKeys) {
        super(leftType, rightType, condFuncCode, leftKeySelector, rightKeySelector, leftPkProjectCode, rightPkProjectCode, leftJoinStateType, rightJoinStateType, maxRetentionTime, minRetentionTime, filterNullKeys);
        this.isAntiJoin = isAntiJoin;
        this.rightNotEmitRetraction = rightNotEmitRetraction;
        if (isAntiJoin) {
            this.leftNotEmitedJoinStateType = rightNotEmitRetraction ? JoinStateHandler.Type.EMPTY : leftJoinStateType;
            this.leftEmitedJoinStateType = leftJoinStateType;
        } else {
            this.leftEmitedJoinStateType = rightNotEmitRetraction ? JoinStateHandler.Type.EMPTY : leftJoinStateType;
            this.leftNotEmitedJoinStateType = leftJoinStateType;
        }
        this.leftMatchStateType = leftMatchStateType;
        this.careLeftMatchTimes = !leftMatchStateType.equals((Object)JoinMatchStateHandler.Type.EMPTY_MATCH) && !leftMatchStateType.equals((Object)JoinMatchStateHandler.Type.ONLY_EQUALITY_CONDITION_EMPTY_MATCH);
    }

    @Override
    public void open() throws Exception {
        super.open();
        LOG.info("leftNotEmitedJoinStateType {}, leftEmitedJoinStateType {}, leftMatchStateType {}, rightJoinStateType {}, rightNotEmitRetraction {}", new Object[]{this.leftNotEmitedJoinStateType, this.leftEmitedJoinStateType, this.leftMatchStateType, this.rightNotEmitRetraction});
        LOG.info("Init SemiAntiJoinStreamOperator.");
    }

    @Override
    protected void initAllStates() throws Exception {
        this.leftEmitedStateHandler = this.createJoinStateHandler(this.leftType, this.leftEmitedJoinStateType, "leftEmitedState", this.leftKeySelector, this.leftKeyType, this.leftPkProjectCode);
        this.leftNotEmitedStateHandler = this.createJoinStateHandler(this.leftType, this.leftNotEmitedJoinStateType, "leftNotEmitedState", this.leftKeySelector, this.leftKeyType, this.leftPkProjectCode);
        this.leftMatchStateHandler = this.createMatchStateHandler(this.leftType, this.leftMatchStateType, this.leftKeyType, "LeftMatchHandler", this.leftPkProjectCode);
        this.rightStateHandler = this.createJoinStateHandler(this.rightType, this.rightJoinStateType, "rightJoinState", this.rightKeySelector, this.rightKeyType, this.rightPkProjectCode);
        if (this.stateCleaningEnabled) {
            this.leftTimerState = this.createCleanupTimeState("left-time-state");
            this.rightTimerState = this.createCleanupTimeState("right-time-state");
        }
    }

    @Override
    public TwoInputSelection firstInputSelection() {
        return TwoInputSelection.ANY;
    }

    public TwoInputSelection processElement1(StreamRecord<BaseRow> element) throws Exception {
        boolean canEmit;
        long currentTime2 = this.internalTimerService.currentProcessingTime();
        BaseRow input = this.getOrCopyBaseRow(element, true);
        BaseRow joinKey = (BaseRow)this.leftKeySelector.getKey(input);
        if (BaseRowUtil.isAccumulateMsg(input)) {
            this.registerProcessingCleanupTimer(joinKey, currentTime2, true, (KeyedValueState<BaseRow, Long>)this.leftTimerState);
        }
        boolean bl = canEmit = this.isAntiJoin;
        if (this.leftEmitedStateHandler.contains(joinKey, input)) {
            canEmit = true;
        } else {
            Iterator<Tuple3<BaseRow, Long, Long>> iterator = this.rightStateHandler.getRecords(joinKey);
            long inputRowMatchOtherSideNum = 0L;
            while (iterator.hasNext()) {
                Tuple3<BaseRow, Long, Long> tuple3 = iterator.next();
                BaseRow matchRow = (BaseRow)tuple3.f0;
                if ((Long)tuple3.f2 < currentTime2 && this.stateCleaningEnabled) {
                    iterator.remove();
                    continue;
                }
                if (!this.applyCondition(input, matchRow, (BaseRow)this.leftKeySelector.getKey(input))) continue;
                inputRowMatchOtherSideNum += ((Long)tuple3.f1).longValue();
                boolean bl2 = canEmit = !this.isAntiJoin;
                if (this.careLeftMatchTimes) continue;
                break;
            }
            if (this.careLeftMatchTimes && inputRowMatchOtherSideNum > 0L && BaseRowUtil.isAccumulateMsg(input)) {
                this.leftMatchStateHandler.updateRowMatchJoinCnt(joinKey, input, inputRowMatchOtherSideNum);
            }
        }
        if (canEmit) {
            this.collector.collect((Object)input);
            this.leftEmitedStateHandler.extractCurrentJoinKey(input);
            this.leftEmitedStateHandler.extractCurrentPrimaryKey(input);
            if (BaseRowUtil.isRetractMsg(input)) {
                this.leftEmitedStateHandler.retract(input);
            } else {
                this.leftEmitedStateHandler.add(input, currentTime2 + this.maxRetentionTime);
            }
        } else {
            this.leftNotEmitedStateHandler.extractCurrentJoinKey(input);
            this.leftNotEmitedStateHandler.extractCurrentPrimaryKey(input);
            if (BaseRowUtil.isRetractMsg(input)) {
                this.leftNotEmitedStateHandler.retract(input);
            } else {
                this.leftNotEmitedStateHandler.add(input, currentTime2 + this.maxRetentionTime);
            }
        }
        return TwoInputSelection.ANY;
    }

    public TwoInputSelection processElement2(StreamRecord<BaseRow> element) throws Exception {
        BaseRow input = this.getOrCopyBaseRow(element, false);
        if (this.isAntiJoin) {
            this.processReceivedRightRow(input, this.leftNotEmitedStateHandler, this.leftEmitedStateHandler);
        } else {
            this.processReceivedRightRow(input, this.leftEmitedStateHandler, this.leftNotEmitedStateHandler);
        }
        return TwoInputSelection.ANY;
    }

    @Override
    public void endInput1() throws Exception {
    }

    @Override
    public void endInput2() throws Exception {
    }

    private void processReceivedRightRow(BaseRow rightRow, JoinStateHandler leftJoinStateHandler, JoinStateHandler leftNotJoinStateHandler) throws Exception {
        long currentTime2 = this.internalTimerService.currentProcessingTime();
        this.rightStateHandler.extractCurrentJoinKey(rightRow);
        this.rightStateHandler.extractCurrentPrimaryKey(rightRow);
        BaseRow joinKey = this.rightStateHandler.getCurrentJoinKey();
        if (BaseRowUtil.isRetractMsg(rightRow)) {
            long possibleJoinCnt = this.getOtherSidePossibleMatchJoinCnt(this.leftMatchStateHandler, this.rightStateHandler, joinKey);
            Iterator<Tuple3<BaseRow, Long, Long>> iterator = leftJoinStateHandler.getRecords(joinKey);
            while (iterator.hasNext()) {
                Tuple3<BaseRow, Long, Long> tuple3 = iterator.next();
                BaseRow matchedRow = (BaseRow)tuple3.f0;
                if ((Long)tuple3.f2 < currentTime2 && this.stateCleaningEnabled) {
                    iterator.remove();
                    this.leftMatchStateHandler.remove(joinKey, matchedRow);
                    continue;
                }
                if (!this.applyCondition(matchedRow, rightRow, this.rightStateHandler.getCurrentJoinKey())) continue;
                this.leftMatchStateHandler.extractCurrentRowMatchJoinCount(joinKey, matchedRow, possibleJoinCnt);
                long currentJoinCnt = this.leftMatchStateHandler.getCurrentRowMatchJoinCnt() - 1L;
                if (currentJoinCnt == 0L) {
                    this.leftMatchStateHandler.remove(joinKey, matchedRow);
                    if (!this.isAntiJoin) {
                        matchedRow.setHeader((byte)1);
                    }
                    int i = 0;
                    while ((long)i < (Long)tuple3.f1) {
                        this.collector.collect((Object)matchedRow);
                        ++i;
                    }
                    matchedRow.setHeader((byte)0);
                    leftNotJoinStateHandler.update(joinKey, matchedRow, (Long)tuple3.f1, (Long)tuple3.f2);
                    iterator.remove();
                    continue;
                }
                this.leftMatchStateHandler.resetCurrentRowMatchJoinCnt(currentJoinCnt);
            }
            this.rightStateHandler.retract(rightRow);
        } else {
            this.registerProcessingCleanupTimer(joinKey, currentTime2, false, (KeyedValueState<BaseRow, Long>)this.rightTimerState);
            Iterator<Tuple3<BaseRow, Long, Long>> iterator = leftJoinStateHandler.getRecords(joinKey);
            while (iterator.hasNext()) {
                Tuple3<BaseRow, Long, Long> tuple3 = iterator.next();
                BaseRow matchedRow = (BaseRow)tuple3.f0;
                if ((Long)tuple3.f2 < currentTime2 && this.stateCleaningEnabled) {
                    iterator.remove();
                    this.leftMatchStateHandler.remove(joinKey, matchedRow);
                    continue;
                }
                if (!this.applyCondition(matchedRow, rightRow, this.rightStateHandler.getCurrentJoinKey())) continue;
                this.leftMatchStateHandler.addRowMatchJoinCnt(joinKey, matchedRow, 1L);
            }
            Iterator<Tuple3<BaseRow, Long, Long>> iterator1 = leftNotJoinStateHandler.getRecords(joinKey);
            while (iterator1.hasNext()) {
                Tuple3<BaseRow, Long, Long> tuple3 = iterator1.next();
                BaseRow matchedRow = (BaseRow)tuple3.f0;
                if ((Long)tuple3.f2 < currentTime2 && this.stateCleaningEnabled) {
                    iterator.remove();
                    this.leftMatchStateHandler.remove(joinKey, matchedRow);
                    continue;
                }
                if (!this.applyCondition(matchedRow, rightRow, this.rightStateHandler.getCurrentJoinKey())) continue;
                if (this.isAntiJoin) {
                    matchedRow.setHeader((byte)1);
                }
                int i = 0;
                while ((long)i < (Long)tuple3.f1) {
                    this.collector.collect((Object)matchedRow);
                    ++i;
                }
                matchedRow.setHeader((byte)0);
                this.leftMatchStateHandler.updateRowMatchJoinCnt(joinKey, matchedRow, 1L);
                leftJoinStateHandler.update(joinKey, matchedRow, (Long)tuple3.f1, (Long)tuple3.f2);
                iterator1.remove();
            }
            this.rightStateHandler.add(rightRow, currentTime2 + this.maxRetentionTime);
        }
    }

    private long getOtherSidePossibleMatchJoinCnt(JoinMatchStateHandler otherSideStateHandler, JoinStateHandler inputSideStateHandler, BaseRow joinKey) {
        if (otherSideStateHandler instanceof NonBatchOnlyEqualityConditionMatchStateHandler) {
            long matchJoinCount;
            Tuple3<BaseRow, Long, Long> tuple3;
            Iterator<Tuple3<BaseRow, Long, Long>> iterator = inputSideStateHandler.getRecords(joinKey);
            for (matchJoinCount = 0L; iterator.hasNext() && matchJoinCount < 2L; matchJoinCount += ((Long)tuple3.f1).longValue()) {
                tuple3 = iterator.next();
            }
            return matchJoinCount;
        }
        return 0L;
    }

    public void onProcessingTime(InternalTimer<BaseRow, Byte> timer) throws Exception {
        byte namespace = (Byte)timer.getNamespace();
        if (namespace == 1) {
            if (this.needToCleanupState((BaseRow)timer.getKey(), timer.getTimestamp(), (KeyedValueState<BaseRow, Long>)this.leftTimerState)) {
                this.leftEmitedStateHandler.remove((BaseRow)timer.getKey());
                this.leftNotEmitedStateHandler.remove((BaseRow)timer.getKey());
                this.leftMatchStateHandler.remove((BaseRow)timer.getKey());
            }
        } else if (this.needToCleanupState((BaseRow)timer.getKey(), timer.getTimestamp(), (KeyedValueState<BaseRow, Long>)this.rightTimerState)) {
            this.rightStateHandler.remove((BaseRow)timer.getKey());
        }
    }
}

