/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join.stream.state;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.runtime.state.keyed.KeyedMapState;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.join.stream.state.JoinStateHandler;
import org.apache.flink.util.Preconditions;

@Internal
public class WithoutPrimaryKeyStateHandler
implements JoinStateHandler {
    private final KeyedMapState<BaseRow, BaseRow, Tuple2<Long, Long>> keyedMapState;
    private final KeySelector<BaseRow, BaseRow> keySelector;
    private transient BaseRow joinKey;

    public WithoutPrimaryKeyStateHandler(KeyedMapState<BaseRow, BaseRow, Tuple2<Long, Long>> keyedMapState, KeySelector<BaseRow, BaseRow> keySelector) {
        this.keyedMapState = keyedMapState;
        this.keySelector = keySelector;
    }

    @Override
    public void extractCurrentJoinKey(BaseRow row2) throws Exception {
        this.joinKey = this.keySelector.getKey(row2);
    }

    @Override
    public BaseRow getCurrentJoinKey() {
        return this.joinKey;
    }

    @Override
    public void extractCurrentPrimaryKey(BaseRow row2) {
    }

    @Override
    public BaseRow getCurrentPrimaryKey() {
        return null;
    }

    @Override
    public long add(BaseRow row2, long expireTime) {
        Tuple2 tuple2 = (Tuple2)this.keyedMapState.get((Object)this.joinKey, (Object)row2);
        if (tuple2 == null) {
            tuple2 = new Tuple2();
        }
        if (tuple2.f0 == null || (Long)tuple2.f0 == 0L) {
            tuple2.f0 = 1L;
        } else {
            Tuple2 tuple22 = tuple2;
            tuple22.f0 = (Long)tuple22.f0 + 1L;
        }
        tuple2.f1 = expireTime;
        this.keyedMapState.add((Object)this.joinKey, (Object)row2, tuple2);
        return (Long)tuple2.f0;
    }

    @Override
    public long retract(BaseRow row2) {
        row2.setHeader((byte)0);
        Tuple2 tuple2 = (Tuple2)this.keyedMapState.get((Object)this.joinKey, (Object)row2);
        if (tuple2 == null) {
            tuple2 = new Tuple2();
        }
        if (tuple2.f0 == null || (Long)tuple2.f0 <= 1L) {
            tuple2.f0 = 0L;
            this.keyedMapState.remove((Object)this.joinKey, (Object)row2);
        } else {
            Tuple2 tuple22 = tuple2;
            tuple22.f0 = (Long)tuple22.f0 - 1L;
            this.keyedMapState.add((Object)this.joinKey, (Object)row2, tuple2);
        }
        row2.setHeader((byte)1);
        return (Long)tuple2.f0;
    }

    @Override
    public Iterator<Tuple3<BaseRow, Long, Long>> getRecords(BaseRow key) {
        return new Tuple3Iterator(this.keyedMapState.iterator((Object)key));
    }

    @Override
    public Iterator<Tuple3<BaseRow, Long, Long>> getRecordsFromCache(BaseRow key) {
        return this.getRecords(key);
    }

    @Override
    public boolean contains(BaseRow key, BaseRow row2) {
        return this.keyedMapState.contains((Object)key, (Object)row2);
    }

    @Override
    public void update(BaseRow key, BaseRow row2, long count, long expireTime) {
        this.keyedMapState.add((Object)key, (Object)row2, new Tuple2<Long, Long>(count, expireTime));
    }

    @Override
    public void batchGet(Collection<? extends BaseRow> keys) {
        throw new RuntimeException("batchGet is not supported for WithoutPrimaryKeyStateHandler");
    }

    @Override
    public long[] batchUpdate(BaseRow key, List<Tuple2<BaseRow, Long>> rows, long expireTime) {
        HashSet rowSet = new HashSet();
        long[] updateStatus = new long[rows.size()];
        long oldCnt = 0L;
        int idx = 0;
        for (Tuple2<BaseRow, Long> tuple2 : rows) {
            rowSet.add(tuple2.f0);
        }
        HashSet deleteSet = new HashSet();
        Map oldMap = this.keyedMapState.getAll((Object)key, rowSet);
        for (Tuple2<BaseRow, Long> tuple2 : rows) {
            Tuple2<Long, Long> cntAndTime = (Tuple2<Long, Long>)oldMap.get(tuple2.f0);
            if (cntAndTime == null) {
                cntAndTime = new Tuple2<Long, Long>(0L, expireTime);
            }
            oldCnt = (Long)cntAndTime.f0;
            Tuple2<Long, Long> tuple22 = cntAndTime;
            Long.valueOf((Long)tuple22.f0 + (Long)tuple2.f1);
            tuple22.f0 = tuple22.f0;
            if ((Long)cntAndTime.f0 == 0L) {
                updateStatus[idx] = -1L;
                deleteSet.add(tuple2.f0);
            } else {
                oldMap.put(tuple2.f0, cntAndTime);
                if (oldCnt == 0L) {
                    updateStatus[idx] = 1L;
                }
            }
            ++idx;
        }
        this.keyedMapState.addAll((Object)key, oldMap);
        this.keyedMapState.removeAll((Object)key, deleteSet);
        return updateStatus;
    }

    @Override
    public void putAll(Map<BaseRow, BaseRow> putMap) {
        throw new RuntimeException("MapState don't support putAll!");
    }

    @Override
    public void removeAll(Set<BaseRow> keys) {
        throw new RuntimeException("MapState don't support removeAll!");
    }

    @Override
    public void setCurrentJoinKey(BaseRow row2) {
        this.joinKey = row2;
    }

    @Override
    public void remove(BaseRow joinKey) {
        this.keyedMapState.remove((Object)joinKey);
    }

    private class Tuple3Iterator
    implements Iterator<Tuple3<BaseRow, Long, Long>> {
        private final Iterator<Map.Entry<BaseRow, Tuple2<Long, Long>>> internalIterator;
        private final Tuple3<BaseRow, Long, Long> reuse;

        Tuple3Iterator(Iterator<Map.Entry<BaseRow, Tuple2<Long, Long>>> internalIterator) {
            Preconditions.checkNotNull(internalIterator);
            this.internalIterator = internalIterator;
            this.reuse = new Tuple3();
        }

        @Override
        public boolean hasNext() {
            return this.internalIterator.hasNext();
        }

        @Override
        public Tuple3<BaseRow, Long, Long> next() {
            Map.Entry<BaseRow, Tuple2<Long, Long>> entry = this.internalIterator.next();
            this.reuse.f0 = entry.getKey();
            this.reuse.f1 = entry.getValue().f0;
            this.reuse.f2 = entry.getValue().f1;
            return this.reuse;
        }

        @Override
        public void remove() {
            this.internalIterator.remove();
        }
    }
}

