/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join.stream.state.match;

import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.state.keyed.KeyedMapState;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.join.stream.state.match.JoinMatchStateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WithoutPrimaryKeyMatchStateHandler
implements JoinMatchStateHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WithoutPrimaryKeyMatchStateHandler.class);
    private final KeyedMapState<BaseRow, BaseRow, Long> keyedMapState;
    private transient BaseRow currentJoinKey;
    private transient BaseRow currentRow;
    private transient long currentRowMatchJoinCont;

    public WithoutPrimaryKeyMatchStateHandler(KeyedMapState<BaseRow, BaseRow, Long> keyedMapState) {
        this.keyedMapState = keyedMapState;
    }

    @Override
    public void extractCurrentRowMatchJoinCount(BaseRow joinKey, BaseRow row2, long possibleJoinCnt) {
        this.currentJoinKey = joinKey;
        this.currentRow = row2;
        Long count = (Long)this.keyedMapState.get((Object)joinKey, (Object)row2);
        this.currentRowMatchJoinCont = null == count ? 0L : count;
    }

    @Override
    public long getCurrentRowMatchJoinCnt() {
        return this.currentRowMatchJoinCont;
    }

    @Override
    public void resetCurrentRowMatchJoinCnt(long joinCnt) {
        this.keyedMapState.add((Object)this.currentJoinKey, (Object)this.currentRow, (Object)joinCnt);
        this.currentRowMatchJoinCont = joinCnt;
    }

    @Override
    public void updateRowMatchJoinCnt(BaseRow joinKey, BaseRow baseRow, long joinCnt) {
        this.keyedMapState.add((Object)joinKey, (Object)baseRow, (Object)joinCnt);
    }

    @Override
    public void addRowMatchJoinCnt(BaseRow joinKey, BaseRow baseRow, long joinCnt) {
        Long count = (Long)this.keyedMapState.get((Object)joinKey, (Object)baseRow);
        if (count != null) {
            this.keyedMapState.add((Object)joinKey, (Object)baseRow, (Object)(joinCnt + count));
        } else {
            LOG.warn("The state is cleared because of state ttl. This will result in incorrect result. You can increase the state ttl to avoid this.");
            this.keyedMapState.add((Object)joinKey, (Object)baseRow, (Object)joinCnt);
        }
    }

    @Override
    public void remove(BaseRow joinKey, BaseRow baseRow) {
        this.keyedMapState.remove((Object)joinKey, (Object)baseRow);
    }

    @Override
    public void remove(BaseRow joinKey) {
        this.keyedMapState.remove((Object)joinKey);
    }

    @Override
    public void removeAll(BaseRow joinKey, Set<BaseRow> keys) {
        this.keyedMapState.removeAll((Object)joinKey, keys);
    }

    @Override
    public void addAll(BaseRow joinKey, Map<BaseRow, Long> kvs) {
        this.keyedMapState.addAll((Object)joinKey, kvs);
    }
}

