/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.range;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.util.Preconditions;

@Internal
public class IdPartitioner
implements Partitioner<Integer> {
    private static final long serialVersionUID = -1206233785103357568L;
    private final int totalRangeNum;

    public IdPartitioner(int totalRangeNum) {
        this.totalRangeNum = totalRangeNum;
    }

    @Override
    public int partition(Integer key, int numPartitions) {
        Preconditions.checkArgument(numPartitions < this.totalRangeNum, "Num of subPartitions should < totalRangeNum: " + this.totalRangeNum);
        double partitionSize = this.totalRangeNum / numPartitions;
        int partition2 = (int)((double)key.intValue() / partitionSize);
        return partition2 >= numPartitions ? numPartitions - 1 : partition2;
    }
}

