/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.sort;

import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.table.runtime.util.MemorySegmentPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicMemorySegmentPool
implements MemorySegmentPool {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicMemorySegmentPool.class);
    private final List<MemorySegment> segments;
    private final Object owner;
    private final int pageSize;
    private final MemoryManager memoryManager;
    private final int perRequestNumBuffers;
    private final int additionalLimitNumPages;
    private int allocateFloatingNum;

    public DynamicMemorySegmentPool(MemoryManager memoryManager, List<MemorySegment> memorySegments, int perRequestNumBuffers, int additionalLimitNumPages) {
        this.memoryManager = memoryManager;
        this.perRequestNumBuffers = perRequestNumBuffers;
        this.additionalLimitNumPages = additionalLimitNumPages;
        this.segments = memorySegments;
        this.pageSize = this.segments.get(0).size();
        this.owner = this.segments.get(0).getOwner();
    }

    @Override
    public MemorySegment nextSegment() {
        if (this.segments.size() > 0) {
            return this.segments.remove(this.segments.size() - 1);
        }
        if (this.allocateFloatingNum < this.additionalLimitNumPages) {
            int requestNum = Math.min(this.perRequestNumBuffers, this.additionalLimitNumPages - this.allocateFloatingNum);
            try {
                List allocates = this.memoryManager.allocatePages(this.owner, requestNum, false);
                this.segments.addAll(allocates);
                this.allocateFloatingNum += allocates.size();
                allocates.clear();
                LOG.info("{} allocate {} floating segments successfully!", this.owner, (Object)requestNum);
            }
            catch (MemoryAllocationException e2) {
                LOG.warn("DynamicMemorySegmentPool can't allocate {} floating pages, use {} floating pages now", new Object[]{requestNum, this.perRequestNumBuffers + this.allocateFloatingNum, e2});
                return null;
            }
            if (this.segments.size() > 0) {
                return this.segments.remove(this.segments.size() - 1);
            }
            return null;
        }
        return null;
    }

    public int resetAndReturnFloatingNum() {
        int old = this.allocateFloatingNum;
        this.allocateFloatingNum = 0;
        return old;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public void returnAll(List<MemorySegment> memory) {
        this.segments.addAll(memory);
    }

    @Override
    public void clear() {
        this.segments.clear();
    }
}

