/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.sort;

import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.sort.IndexedSortable;
import org.apache.flink.runtime.operators.sort.IndexedSorter;
import org.apache.flink.runtime.operators.sort.QuickSort;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.keyed.KeyedListState;
import org.apache.flink.runtime.state.keyed.KeyedListStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.runtime.state.keyed.KeyedValueStateDescriptor;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.codegen.GeneratedSorter;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.sort.BinaryInMemorySortBuffer;
import org.apache.flink.table.runtime.sort.NormalizedKeyComputer;
import org.apache.flink.table.runtime.sort.RecordComparator;
import org.apache.flink.table.runtime.sort.SortBaseOperator;
import org.apache.flink.table.typeutils.AbstractRowSerializer;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.typeutils.BinaryRowSerializer;
import org.apache.flink.util.MutableObjectIterator;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\u0001\u0003\u0001=\u00111CU8x)&lWmU8si>\u0003XM]1u_JT!a\u0001\u0003\u0002\tM|'\u000f\u001e\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005A\u0019vN\u001d;CCN,w\n]3sCR|'\u000f\u0003\u0005\u0016\u0001\t\u0015\r\u0011\"\u0003\u0017\u00031Ig\u000e];u%><H+\u001f9f+\u00059\u0002C\u0001\r\u001c\u001b\u0005I\"B\u0001\u000e\u0007\u0003%!\u0018\u0010]3vi&d7/\u0003\u0002\u001d3\ty!)Y:f%><H+\u001f9f\u0013:4w\u000e\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003\u0018\u00035Ig\u000e];u%><H+\u001f9fA!A\u0001\u0005\u0001BA\u0002\u0013%\u0011%A\u0004h'>\u0014H/\u001a:\u0016\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R!!\n\u0004\u0002\u000f\r|G-Z4f]&\u0011q\u0005\n\u0002\u0010\u000f\u0016tWM]1uK\u0012\u001cvN\u001d;fe\"A\u0011\u0006\u0001BA\u0002\u0013%!&A\u0006h'>\u0014H/\u001a:`I\u0015\fHCA\u00162!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0011)f.\u001b;\t\u000fIB\u0013\u0011!a\u0001E\u0005\u0019\u0001\u0010J\u0019\t\u0011Q\u0002!\u0011!Q!\n\t\n\u0001bZ*peR,'\u000f\t\u0005\tm\u0001\u0011)\u0019!C\u0005o\u0005Q!o\\<uS6,\u0017\n\u001a=\u0016\u0003a\u0002\"\u0001L\u001d\n\u0005ij#aA%oi\"AA\b\u0001B\u0001B\u0003%\u0001(A\u0006s_^$\u0018.\\3JIb\u0004\u0003\u0002\u0003 \u0001\u0005\u000b\u0007I\u0011B \u0002\u00155,Wn\u001c:z'&TX-F\u0001A!\ta\u0013)\u0003\u0002C[\t1Ai\\;cY\u0016D\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I\u0001Q\u0001\f[\u0016lwN]=TSj,\u0007\u0005C\u0003G\u0001\u0011\u0005q)\u0001\u0004=S:LGO\u0010\u000b\u0006\u0011&S5\n\u0014\t\u0003#\u0001AQ!F#A\u0002]AQ\u0001I#A\u0002\tBQAN#A\u0002aBQAP#A\u0002\u0001C\u0011B\u0014\u0001A\u0002\u0003\u0007I\u0011B(\u0002\u001bQLW.\u001a'jgR\u001cF/\u0019;f+\u0005\u0001\u0006\u0003B)X3\u0006l\u0011A\u0015\u0006\u0003'R\u000bQa[3zK\u0012T!!\u0016,\u0002\u000bM$\u0018\r^3\u000b\u0005\u0015A\u0011B\u0001-S\u00059YU-_3e\u0019&\u001cHo\u0015;bi\u0016\u0004\"AW0\u000e\u0003mS!\u0001X/\u0002\t1\fgn\u001a\u0006\u0002=\u0006!!.\u0019<b\u0013\t\u00017L\u0001\u0003M_:<\u0007C\u00012f\u001b\u0005\u0019'B\u00013\u0007\u0003)!\u0017\r^1g_Jl\u0017\r^\u0005\u0003M\u000e\u0014qAQ1tKJ{w\u000fC\u0005i\u0001\u0001\u0007\t\u0019!C\u0005S\u0006\tB/[7f\u0019&\u001cHo\u0015;bi\u0016|F%Z9\u0015\u0005-R\u0007b\u0002\u001ah\u0003\u0003\u0005\r\u0001\u0015\u0005\u0007Y\u0002\u0001\u000b\u0015\u0002)\u0002\u001dQLW.\u001a'jgR\u001cF/\u0019;fA!\u00121N\u001c\t\u0003Y=L!\u0001]\u0017\u0003\u0013Q\u0014\u0018M\\:jK:$\b\"\u0003:\u0001\u0001\u0004\u0005\r\u0011\"\u0003t\u0003Ua\u0017m\u001d;Ue&<w-\u001a:j]\u001e$6o\u0015;bi\u0016,\u0012\u0001\u001e\t\u0005#V<\u0018,\u0003\u0002w%\ny1*Z=fIZ\u000bG.^3Ti\u0006$X\r\u0005\u0002ys6\tA+\u0003\u0002{)\niak\\5e\u001d\u0006lWm\u001d9bG\u0016D\u0011\u0002 \u0001A\u0002\u0003\u0007I\u0011B?\u000231\f7\u000f\u001e+sS\u001e<WM]5oOR\u001b8\u000b^1uK~#S-\u001d\u000b\u0003WyDqAM>\u0002\u0002\u0003\u0007A\u000fC\u0004\u0002\u0002\u0001\u0001\u000b\u0015\u0002;\u0002-1\f7\u000f\u001e+sS\u001e<WM]5oOR\u001b8\u000b^1uK\u0002B#a 8\t\u0017\u0005\u001d\u0001\u00011AA\u0002\u0013%\u0011\u0011B\u0001\u0007EV4g-\u001a:\u0016\u0005\u0005-\u0001cA\t\u0002\u000e%\u0019\u0011q\u0002\u0002\u00031\tKg.\u0019:z\u0013:lU-\\8ssN{'\u000f\u001e\"vM\u001a,'\u000fC\u0006\u0002\u0014\u0001\u0001\r\u00111A\u0005\n\u0005U\u0011A\u00032vM\u001a,'o\u0018\u0013fcR\u00191&a\u0006\t\u0013I\n\t\"!AA\u0002\u0005-\u0001\u0002CA\u000e\u0001\u0001\u0006K!a\u0003\u0002\u000f\t,hMZ3sA!\u001a\u0011\u0011\u00048\t\u0017\u0005\u0005\u0002\u00011AA\u0002\u0013%\u00111E\u0001\u0007g>\u0014H/\u001a:\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003_i!!!\u000b\u000b\u0007\r\tYCC\u0002\u0002.Y\u000b\u0011b\u001c9fe\u0006$xN]:\n\t\u0005E\u0012\u0011\u0006\u0002\u000e\u0013:$W\r_3e'>\u0014H/\u001a:\t\u0017\u0005U\u0002\u00011AA\u0002\u0013%\u0011qG\u0001\u000bg>\u0014H/\u001a:`I\u0015\fHcA\u0016\u0002:!I!'a\r\u0002\u0002\u0003\u0007\u0011Q\u0005\u0005\t\u0003{\u0001\u0001\u0015)\u0003\u0002&\u000591o\u001c:uKJ\u0004\u0003fAA\u001e]\"Y\u00111\t\u0001A\u0002\u0003\u0007I\u0011BA#\u0003A\u0011\u0017N\\1ssN+'/[1mSj,'/\u0006\u0002\u0002HA\u0019\u0001$!\u0013\n\u0007\u0005-\u0013DA\nCS:\f'/\u001f*poN+'/[1mSj,'\u000fC\u0006\u0002P\u0001\u0001\r\u00111A\u0005\n\u0005E\u0013\u0001\u00062j]\u0006\u0014\u0018pU3sS\u0006d\u0017N_3s?\u0012*\u0017\u000fF\u0002,\u0003'B\u0011BMA'\u0003\u0003\u0005\r!a\u0012\t\u0011\u0005]\u0003\u0001)Q\u0005\u0003\u000f\n\u0011CY5oCJL8+\u001a:jC2L'0\u001a:!Q\r\t)F\u001c\u0005\b\u0003;\u0002A\u0011IA0\u0003\u0011y\u0007/\u001a8\u0015\u0003-Bq!a\u0019\u0001\t\u0003\n)'\u0001\bqe>\u001cWm]:FY\u0016lWM\u001c;\u0015\u0007-\n9\u0007\u0003\u0005\u0002j\u0005\u0005\u0004\u0019AA6\u0003\tIg\u000eE\u0003\u0002n\u0005e\u0014-\u0004\u0002\u0002p)!\u0011\u0011OA:\u00031\u0019HO]3b[J,7m\u001c:e\u0015\r)\u0011Q\u000f\u0006\u0004\u0003oB\u0011!C:ue\u0016\fW.\u001b8h\u0013\u0011\tY(a\u001c\u0003\u0019M#(/Z1n%\u0016\u001cwN\u001d3\t\u000f\u0005}\u0004\u0001\"\u0011\u0002\u0002\u0006YqN\\#wK:$H+[7f)\rY\u00131\u0011\u0005\t\u0003\u000b\u000bi\b1\u0001\u0002\b\u0006)A/[7feB1\u0011\u0011RAIC^l!!a#\u000b\t\u00055\u0012Q\u0012\u0006\u0005\u0003\u001f\u000b)(A\u0002ba&LA!a%\u0002\f\ni\u0011J\u001c;fe:\fG\u000eV5nKJDq!a&\u0001\t\u0003\ny&\u0001\u0005f]\u0012Le\u000e];u\u0001")
public class RowTimeSortOperator
extends SortBaseOperator {
    private final BaseRowTypeInfo inputRowType;
    private GeneratedSorter gSorter;
    private final int rowtimeIdx;
    private final double memorySize;
    private transient KeyedListState<Long, BaseRow> timeListState;
    private transient KeyedValueState<VoidNamespace, Long> lastTriggeringTsState;
    private transient BinaryInMemorySortBuffer buffer;
    private transient IndexedSorter sorter;
    private transient BinaryRowSerializer binarySerializer;

    private BaseRowTypeInfo inputRowType() {
        return this.inputRowType;
    }

    private GeneratedSorter gSorter() {
        return this.gSorter;
    }

    private void gSorter_$eq(GeneratedSorter x$1) {
        this.gSorter = x$1;
    }

    private int rowtimeIdx() {
        return this.rowtimeIdx;
    }

    private double memorySize() {
        return this.memorySize;
    }

    private KeyedListState<Long, BaseRow> timeListState() {
        return this.timeListState;
    }

    private void timeListState_$eq(KeyedListState<Long, BaseRow> x$1) {
        this.timeListState = x$1;
    }

    private KeyedValueState<VoidNamespace, Long> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(KeyedValueState<VoidNamespace, Long> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private BinaryInMemorySortBuffer buffer() {
        return this.buffer;
    }

    private void buffer_$eq(BinaryInMemorySortBuffer x$1) {
        this.buffer = x$1;
    }

    private IndexedSorter sorter() {
        return this.sorter;
    }

    private void sorter_$eq(IndexedSorter x$1) {
        this.sorter = x$1;
    }

    private BinaryRowSerializer binarySerializer() {
        return this.binarySerializer;
    }

    private void binarySerializer_$eq(BinaryRowSerializer x$1) {
        this.binarySerializer = x$1;
    }

    @Override
    public void open() {
        super.open();
        AbstractRowSerializer<BaseRow> recordSerializer = this.inputRowType().createSerializer();
        KeyedListStateDescriptor dataStateDescriptor = new KeyedListStateDescriptor("dataState", (TypeSerializer)LongSerializer.INSTANCE, recordSerializer);
        this.timeListState_$eq((KeyedListState<Long, BaseRow>)((KeyedListState)this.getKeyedState((KeyedStateDescriptor)dataStateDescriptor)));
        KeyedValueStateDescriptor lastTriggeringTsDescriptor = new KeyedValueStateDescriptor("lastTriggeringTsState", (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (TypeSerializer)LongSerializer.INSTANCE);
        this.lastTriggeringTsState_$eq((KeyedValueState<VoidNamespace, Long>)((KeyedValueState)this.getKeyedState((KeyedStateDescriptor)lastTriggeringTsDescriptor)));
        this.binarySerializer_$eq(new BinaryRowSerializer(recordSerializer.getTypes()));
        MemoryManager memManager = this.getContainingTask().getEnvironment().getMemoryManager();
        List memorySegments = memManager.allocatePages((Object)this.getContainingTask(), (int)(this.memorySize() / (double)memManager.getPageSize()));
        RecordComparator comparator = this.getComparator(this.gSorter());
        NormalizedKeyComputer computer = this.getComputer(this.gSorter());
        this.buffer_$eq(BinaryInMemorySortBuffer.createBuffer(memManager, computer, recordSerializer, this.binarySerializer(), comparator, memorySegments, 0, 0));
        this.sorter_$eq((IndexedSorter)new QuickSort());
        this.gSorter_$eq(null);
    }

    public void processElement(StreamRecord<BaseRow> in) {
        BaseRow input = (BaseRow)in.getValue();
        long rowtime2 = input.getLong(this.rowtimeIdx());
        Long lastTriggeringTs = (Long)this.lastTriggeringTsState().get((Object)VoidNamespace.INSTANCE);
        if (lastTriggeringTs == null || rowtime2 > Predef$.MODULE$.Long2long(lastTriggeringTs)) {
            this.timeListState().add((Object)Predef$.MODULE$.long2Long(rowtime2), (Object)input);
            this.timerService().registerEventTimeTimer(rowtime2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onEventTime(InternalTimer<BaseRow, VoidNamespace> timer) {
        long timestamp = timer.getTimestamp();
        Iterator itr = ((List)this.timeListState().get((Object)Predef$.MODULE$.long2Long(timestamp))).iterator();
        if (itr.hasNext()) {
            while (itr.hasNext()) {
                this.buffer().write((BaseRow)itr.next());
            }
            this.sorter().sort((IndexedSortable)this.buffer());
            MutableObjectIterator<BinaryRow> outputItor = this.buffer().getIterator();
            BinaryRow row2 = this.binarySerializer().createInstance();
            row2 = outputItor.next(row2);
            while (true) {
                void var5_4;
                BinaryRow binaryRow;
                if (row2 == null) {
                    this.timeListState().remove((Object)Predef$.MODULE$.long2Long(timestamp));
                    this.lastTriggeringTsState().put((Object)VoidNamespace.INSTANCE, (Object)Predef$.MODULE$.long2Long(timestamp));
                    this.buffer().reset();
                    break;
                }
                this.collector().collect((Object)binaryRow);
                binaryRow = (BinaryRow)var5_4.next(binaryRow);
            }
        }
    }

    public void endInput() {
    }

    public RowTimeSortOperator(BaseRowTypeInfo inputRowType, GeneratedSorter gSorter, int rowtimeIdx, double memorySize) {
        this.inputRowType = inputRowType;
        this.gSorter = gSorter;
        this.rowtimeIdx = rowtimeIdx;
        this.memorySize = memorySize;
    }
}

