/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemorySegmentSource;
import org.apache.flink.runtime.io.disk.RandomAccessInputView;
import org.apache.flink.runtime.io.disk.SimpleCollectingOutputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.util.BinaryRowUtil;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.typeutils.BinaryRowSerializer;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytesHashMap {
    private static final Logger LOG = LoggerFactory.getLogger(BytesHashMap.class);
    public static final int BUCKET_SIZE = 16;
    public static final int RECORD_EXTRA_LENGTH = 8;
    private static final int BUCKET_SIZE_BITS = 4;
    private static final int ELEMENT_POINT_LENGTH = 8;
    private static final long END_OF_LIST = Long.MAX_VALUE;
    private static final int STEP_INCREMENT = 1;
    private static final double LOAD_FACTOR = 0.75;
    private static final long INIT_BUCKET_MEMORY_IN_BYTES = 0x100000L;
    private final Object owner;
    private final int numBucketsPerSegment;
    private final int numBucketsPerSegmentBits;
    private final int numBucketsPerSegmentMask;
    private final int lastBucketPosition;
    private final int segmentSize;
    private final RecordArea recordArea;
    private final boolean hashSetMode;
    private final BinaryRowSerializer valueSerializer;
    private final BinaryRowSerializer keySerializer;
    private final LookupInfo reuseLookInfo;
    private final MemoryManager memoryManager;
    private BinaryRow reusedValue;
    private BinaryRow reusedKey;
    private final List<MemorySegment> freeMemorySegments;
    private List<MemorySegment> bucketSegments;
    private long numElements = 0L;
    private int numBucketsMask;
    private int log2NumBuckets;
    private int numBucketsMask2;
    private int growthThreshold;
    private volatile RecordArea.DestructiveEntryIterator destructiveIterator = null;
    private final int reservedNumBuffers;
    private final int preferredNumBuffers;
    private final int perRequestNumBuffers;
    private final int initBucketSegmentNum;
    private int allocatedFloatingNum;
    private long numSpillFiles;
    private long spillInBytes;

    public BytesHashMap(Object owner, MemoryManager memoryManager, long minMemorySize, InternalType[] keyTypes, InternalType[] valueTypes) {
        this(owner, memoryManager, minMemorySize, minMemorySize, 0L, keyTypes, valueTypes);
    }

    public BytesHashMap(Object owner, MemoryManager memoryManager, long minMemorySize, long maxMemorySize, long eachRequestMemorySize, InternalType[] keyTypes, InternalType[] valueTypes) {
        this(owner, memoryManager, minMemorySize, maxMemorySize, eachRequestMemorySize, keyTypes, valueTypes, false);
    }

    public BytesHashMap(Object owner, MemoryManager memoryManager, long minMemorySize, long maxMemorySize, long eachRequestMemorySize, InternalType[] keyTypes, InternalType[] valueTypes, boolean inferBucketMemory) {
        this.owner = owner;
        this.segmentSize = memoryManager.getPageSize();
        this.reservedNumBuffers = (int)(minMemorySize / (long)this.segmentSize);
        this.preferredNumBuffers = (int)(maxMemorySize / (long)this.segmentSize);
        this.perRequestNumBuffers = (int)(eachRequestMemorySize / (long)this.segmentSize);
        this.memoryManager = memoryManager;
        try {
            this.freeMemorySegments = memoryManager.allocatePages(owner, this.reservedNumBuffers);
        }
        catch (MemoryAllocationException e2) {
            throw new IllegalArgumentException("BytesHashMap can't allocate " + this.reservedNumBuffers + " pages", e2);
        }
        this.numBucketsPerSegment = this.segmentSize / 16;
        this.numBucketsPerSegmentBits = MathUtils.log2strict(this.numBucketsPerSegment);
        this.numBucketsPerSegmentMask = (1 << this.numBucketsPerSegmentBits) - 1;
        this.lastBucketPosition = (this.numBucketsPerSegment - 1) * 16;
        Preconditions.checkArgument(keyTypes.length > 0);
        this.keySerializer = new BinaryRowSerializer(keyTypes);
        this.reusedKey = this.keySerializer.createInstance();
        if (valueTypes.length == 0) {
            this.valueSerializer = new BinaryRowSerializer();
            this.hashSetMode = true;
            this.reusedValue = new BinaryRow(0);
            this.reusedValue.pointTo(MemorySegmentFactory.wrap(new byte[8]), 0, 8);
            LOG.info("BytesHashMap with hashSetMode = true.");
        } else {
            this.valueSerializer = new BinaryRowSerializer(valueTypes);
            this.hashSetMode = false;
            this.reusedValue = this.valueSerializer.createInstance();
        }
        this.reuseLookInfo = new LookupInfo();
        this.recordArea = new RecordArea();
        if (inferBucketMemory) {
            this.initBucketSegmentNum = this.calcNumBucketSegments(keyTypes, valueTypes);
        } else {
            Preconditions.checkArgument(minMemorySize > 0x100000L, "The minBucketMemorySize is not valid!");
            this.initBucketSegmentNum = MathUtils.roundDownToPowerOf2((int)(0x100000L / (long)this.segmentSize));
        }
        this.initBucketSegments(this.initBucketSegmentNum);
        LOG.info("BytesHashMap with initial memory segments {}, {} in bytes, init allocating {} for bucket area. And the preferred memory segments is {} in bytes, per request {} segments from floating memory pool.", new Object[]{this.reservedNumBuffers, this.reservedNumBuffers * this.segmentSize, this.initBucketSegmentNum, this.preferredNumBuffers * this.segmentSize, this.perRequestNumBuffers});
    }

    private int calcNumBucketSegments(InternalType[] keyTypes, InternalType[] valueTypes) {
        double averageBucketSize = 21.333333333333332;
        int calcRecordLength = this.reusedValue.getFixedLengthPartSize() + BinaryRowUtil.getVariableLength(valueTypes) + this.reusedKey.getFixedLengthPartSize() + BinaryRowUtil.getVariableLength(keyTypes);
        double fraction = averageBucketSize / (averageBucketSize + (double)calcRecordLength + 8.0);
        int ret = Math.max(1, MathUtils.roundDownToPowerOf2((int)((double)this.reservedNumBuffers * fraction)));
        if ((long)ret * (long)this.numBucketsPerSegment > Integer.MAX_VALUE) {
            ret = MathUtils.roundDownToPowerOf2(Integer.MAX_VALUE / this.numBucketsPerSegment);
        }
        return ret;
    }

    public boolean isHashSetMode() {
        return this.hashSetMode;
    }

    public LookupInfo lookup(BinaryRow key) {
        Preconditions.checkArgument(key.getAllSegments().length == 1);
        int hashCode1 = key.hashCode();
        int newPos = hashCode1 & this.numBucketsMask;
        int bucketSegmentIndex = newPos >>> this.numBucketsPerSegmentBits;
        int bucketOffset = (newPos & this.numBucketsPerSegmentMask) << 4;
        boolean found = false;
        int step = 1;
        long hashCode2 = 0L;
        try {
            long findElementPtr;
            while ((findElementPtr = this.bucketSegments.get(bucketSegmentIndex).getLong(bucketOffset)) != Long.MAX_VALUE) {
                int storedHashCode = this.bucketSegments.get(bucketSegmentIndex).getInt(bucketOffset + 8);
                if (hashCode1 == storedHashCode) {
                    this.recordArea.setReadPosition(findElementPtr);
                    if (this.recordArea.readKeyAndEquals(key)) {
                        found = true;
                        this.reusedValue = this.recordArea.readValue(this.reusedValue);
                        break;
                    }
                }
                if (step == 1) {
                    hashCode2 = this.calcSecondHashCode(hashCode1);
                }
                newPos = (int)((long)hashCode1 + (long)step * hashCode2 & (long)this.numBucketsMask);
                bucketSegmentIndex = newPos >>> this.numBucketsPerSegmentBits;
                bucketOffset = (newPos & this.numBucketsPerSegmentMask) << 4;
                ++step;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading record from the aggregate map: " + ex.getMessage(), ex);
        }
        this.reuseLookInfo.set(found, hashCode1, key, this.reusedValue, bucketSegmentIndex, bucketOffset);
        return this.reuseLookInfo;
    }

    private long calcSecondHashCode(int firstHashCode) {
        return (((long)(firstHashCode >> this.log2NumBuckets) & (long)this.numBucketsMask2) << 1) + 1L;
    }

    public BinaryRow append(LookupInfo info, BinaryRow value) throws IOException {
        try {
            if (this.numElements >= (long)this.growthThreshold) {
                this.growAndRehash();
                this.lookup(info.key);
            }
            BinaryRow toAppend = this.hashSetMode ? this.reusedValue : value;
            long pointerToAppended = this.recordArea.appendRecord(info.key, toAppend);
            this.bucketSegments.get(info.bucketSegmentIndex).putLong(info.bucketOffset, pointerToAppended);
            this.bucketSegments.get(info.bucketSegmentIndex).putInt(info.bucketOffset + 8, info.keyHashCode);
            ++this.numElements;
            this.recordArea.setReadPosition(pointerToAppended);
            this.recordArea.skipKey();
            return this.recordArea.readValue(this.reusedValue);
        }
        catch (EOFException e2) {
            ++this.numSpillFiles;
            this.spillInBytes += (long)this.recordArea.segments.size() * (long)this.segmentSize;
            throw e2;
        }
    }

    public long getNumSpillFiles() {
        return this.numSpillFiles;
    }

    public long getUsedMemoryInBytes() {
        return (long)(this.bucketSegments.size() + this.recordArea.segments.size()) * (long)this.segmentSize;
    }

    public long getSpillInBytes() {
        return this.spillInBytes;
    }

    public long getNumElements() {
        return this.numElements;
    }

    private void initBucketSegments(int numBucketSegments) {
        if (numBucketSegments < 1) {
            throw new RuntimeException("Too small memory allocated for BytesHashMap");
        }
        this.bucketSegments = new ArrayList<MemorySegment>(numBucketSegments);
        for (int i = 0; i < numBucketSegments; ++i) {
            this.bucketSegments.add(i, this.freeMemorySegments.remove(this.freeMemorySegments.size() - 1));
        }
        this.resetBucketSegments(this.bucketSegments);
        int numBuckets = numBucketSegments * this.numBucketsPerSegment;
        this.log2NumBuckets = MathUtils.log2strict(numBuckets);
        this.numBucketsMask = (1 << MathUtils.log2strict(numBuckets)) - 1;
        this.numBucketsMask2 = (1 << MathUtils.log2strict(numBuckets >> 1)) - 1;
        this.growthThreshold = (int)((double)numBuckets * 0.75);
    }

    private List<MemorySegment> allocateSegments(int required) throws MemoryAllocationException {
        if (this.reservedNumBuffers + this.allocatedFloatingNum + required >= this.preferredNumBuffers) {
            throw new MemoryAllocationException("Could not allocate " + required + " pages limited to the max memory size. ");
        }
        List memorySegments = this.memoryManager.allocatePages(this.owner, required, false);
        if (memorySegments.size() != required) {
            throw new MemoryAllocationException("Could not allocate " + required + " pages limited to the max memory size. ");
        }
        LOG.info("{} allocate {} floating segments successfully!", this.owner, (Object)required);
        this.allocatedFloatingNum += memorySegments.size();
        return memorySegments;
    }

    private void resetBucketSegments(List<MemorySegment> resetBucketSegs) {
        for (MemorySegment segment : resetBucketSegs) {
            for (int j2 = 0; j2 <= this.lastBucketPosition; j2 += 16) {
                segment.putLong(j2, Long.MAX_VALUE);
            }
        }
    }

    private void growAndRehash() throws EOFException {
        int required = 2 * this.bucketSegments.size();
        if (required * this.numBucketsPerSegment > Integer.MAX_VALUE) {
            LOG.warn("We can't handle more than Integer.MAX_VALUE buckets (eg. because hash functions return int)");
            throw new EOFException();
        }
        ArrayList<MemorySegment> newBucketSegments = new ArrayList<MemorySegment>(required);
        try {
            int needNumFromFreeSegments;
            int freeNumSegments = this.freeMemorySegments.size();
            int numAllocatedSegments = required - freeNumSegments;
            if (numAllocatedSegments > 0) {
                List<MemorySegment> returnSegments = this.allocateSegments(numAllocatedSegments);
                newBucketSegments.addAll(returnSegments);
                returnSegments.clear();
            }
            for (int end = needNumFromFreeSegments = required - newBucketSegments.size(); end > 0; --end) {
                newBucketSegments.add(this.freeMemorySegments.remove(this.freeMemorySegments.size() - 1));
            }
            int numBuckets = newBucketSegments.size() * this.numBucketsPerSegment;
            this.log2NumBuckets = MathUtils.log2strict(numBuckets);
            this.numBucketsMask = (1 << MathUtils.log2strict(numBuckets)) - 1;
            this.numBucketsMask2 = (1 << MathUtils.log2strict(numBuckets >> 1)) - 1;
            this.growthThreshold = (int)((double)numBuckets * 0.75);
        }
        catch (MemoryAllocationException e2) {
            LOG.warn("BytesHashMap can't allocate {} pages, and now used {} pages", new Object[]{required, this.reservedNumBuffers + this.allocatedFloatingNum, e2});
            throw new EOFException();
        }
        long reHashStartTime = System.currentTimeMillis();
        this.resetBucketSegments(newBucketSegments);
        for (MemorySegment memorySegment : this.bucketSegments) {
            for (int j2 = 0; j2 < this.numBucketsPerSegment; ++j2) {
                long recordPointer = memorySegment.getLong(j2 * 16);
                if (recordPointer == Long.MAX_VALUE) continue;
                int hashCode1 = memorySegment.getInt(j2 * 16 + 8);
                int newPos = hashCode1 & this.numBucketsMask;
                int bucketSegmentIndex = newPos >>> this.numBucketsPerSegmentBits;
                int bucketOffset = (newPos & this.numBucketsPerSegmentMask) << 4;
                int step = 1;
                long hashCode2 = 0L;
                while (((MemorySegment)newBucketSegments.get(bucketSegmentIndex)).getLong(bucketOffset) != Long.MAX_VALUE) {
                    if (step == 1) {
                        hashCode2 = this.calcSecondHashCode(hashCode1);
                    }
                    newPos = (int)((long)hashCode1 + (long)step * hashCode2 & (long)this.numBucketsMask);
                    bucketSegmentIndex = newPos >>> this.numBucketsPerSegmentBits;
                    bucketOffset = (newPos & this.numBucketsPerSegmentMask) << 4;
                    ++step;
                }
                ((MemorySegment)newBucketSegments.get(bucketSegmentIndex)).putLong(bucketOffset, recordPointer);
                ((MemorySegment)newBucketSegments.get(bucketSegmentIndex)).putInt(bucketOffset + 8, hashCode1);
            }
        }
        LOG.info("The rehash take {} ms for {} segments", (Object)(System.currentTimeMillis() - reHashStartTime), (Object)required);
        this.freeMemorySegments.addAll(this.bucketSegments);
        this.bucketSegments = newBucketSegments;
    }

    public MutableObjectIterator<Entry> getEntryIterator() {
        if (this.destructiveIterator != null) {
            throw new IllegalArgumentException("DestructiveIterator is not null, so this method can't be invoke!");
        }
        return this.recordArea.destructiveEntryIterator();
    }

    public ArrayList<MemorySegment> getRecordAreaMemorySegments() {
        return this.recordArea.segments;
    }

    public List<MemorySegment> getBucketAreaMemorySegments() {
        return this.bucketSegments;
    }

    public List<MemorySegment> getFreeMemorySegments() {
        return this.freeMemorySegments;
    }

    public void free() {
        this.free(false);
    }

    public void free(boolean reservedFixedMemmory) {
        this.returnSegments(this.bucketSegments);
        this.bucketSegments.clear();
        this.recordArea.release();
        this.releaseFloatingMemory();
        if (!reservedFixedMemmory) {
            this.memoryManager.release(this.freeMemorySegments);
        }
        this.numElements = 0L;
        this.destructiveIterator = null;
    }

    public void reset() {
        int numBuckets = this.bucketSegments.size() * this.numBucketsPerSegment;
        this.log2NumBuckets = MathUtils.log2strict(numBuckets);
        this.numBucketsMask = (1 << MathUtils.log2strict(numBuckets)) - 1;
        this.numBucketsMask2 = (1 << MathUtils.log2strict(numBuckets >> 1)) - 1;
        this.growthThreshold = (int)((double)numBuckets * 0.75);
        this.recordArea.reset();
        this.resetBucketSegments(this.bucketSegments);
        this.numElements = 0L;
        this.destructiveIterator = null;
        LOG.info("reset BytesHashMap with record memory segments {}, {} in bytes, init allocating {} for bucket area.", new Object[]{this.freeMemorySegments.size(), this.freeMemorySegments.size() * this.segmentSize, this.bucketSegments.size()});
    }

    private void returnSegment(MemorySegment segments) {
        this.freeMemorySegments.add(segments);
    }

    private void returnSegments(List<MemorySegment> segments) {
        this.freeMemorySegments.addAll(segments);
    }

    private void releaseFloatingMemory() {
        this.memoryManager.release(this.freeMemorySegments, false);
        this.allocatedFloatingNum = 0;
    }

    public static final class Entry {
        private final BinaryRow key;
        private final BinaryRow value;

        public Entry(BinaryRow key, BinaryRow value) {
            this.key = key;
            this.value = value;
        }

        public BinaryRow getKey() {
            return this.key;
        }

        public BinaryRow getValue() {
            return this.value;
        }
    }

    public static final class LookupInfo {
        private boolean found = false;
        private BinaryRow key = null;
        private BinaryRow value = null;
        private int keyHashCode = -1;
        private int bucketSegmentIndex = -1;
        private int bucketOffset = -1;

        LookupInfo() {
        }

        void set(boolean found, int keyHashCode, BinaryRow key, BinaryRow value, int bucketSegmentIndex, int bucketOffset) {
            this.found = found;
            this.keyHashCode = keyHashCode;
            this.key = key;
            this.value = value;
            this.bucketSegmentIndex = bucketSegmentIndex;
            this.bucketOffset = bucketOffset;
        }

        public boolean isFound() {
            return this.found;
        }

        public BinaryRow getValue() {
            return this.value;
        }
    }

    private final class RecordArea {
        private final ArrayList<MemorySegment> segments = new ArrayList();
        private final RandomAccessInputView inView;
        private final SimpleCollectingOutputView outView;

        RecordArea() {
            this.outView = new SimpleCollectingOutputView(this.segments, (MemorySegmentSource)new RecordAreaMemorySource(), BytesHashMap.this.segmentSize);
            this.inView = new RandomAccessInputView(this.segments, BytesHashMap.this.segmentSize);
        }

        void release() {
            BytesHashMap.this.returnSegments(this.segments);
            this.segments.clear();
        }

        void reset() {
            this.release();
            this.outView.reset();
            this.inView.setReadPosition(0L);
        }

        private long appendRecord(BinaryRow key, BinaryRow value) throws IOException {
            long oldLastPosition = this.outView.getCurrentOffset();
            int skip = BytesHashMap.this.keySerializer.serializeToPages(key, (AbstractPagedOutputView)this.outView);
            BytesHashMap.this.valueSerializer.serializeToPages(value, (AbstractPagedOutputView)this.outView);
            return oldLastPosition + (long)skip;
        }

        void setReadPosition(long position) {
            this.inView.setReadPosition(position);
        }

        boolean readKeyAndEquals(BinaryRow lookup) throws IOException {
            BytesHashMap.this.reusedKey = BytesHashMap.this.keySerializer.mapFromPages(BytesHashMap.this.reusedKey, (AbstractPagedInputView)this.inView);
            return lookup.equals(BytesHashMap.this.reusedKey);
        }

        long skipKey() throws IOException {
            long index = this.inView.getReadPosition();
            this.inView.skipBytes(this.inView.readInt());
            return index;
        }

        BinaryRow readValue(BinaryRow reuse) throws IOException {
            return BytesHashMap.this.valueSerializer.mapFromPages(reuse, (AbstractPagedInputView)this.inView);
        }

        MutableObjectIterator<Entry> destructiveEntryIterator() {
            return new DestructiveEntryIterator();
        }

        final class DestructiveEntryIterator
        extends AbstractPagedInputView
        implements MutableObjectIterator<Entry> {
            private int count;
            private int currentSegmentIndex;

            public DestructiveEntryIterator() {
                super((MemorySegment)RecordArea.this.segments.get(0), BytesHashMap.this.segmentSize, 0);
                this.count = 0;
                this.currentSegmentIndex = 0;
                BytesHashMap.this.destructiveIterator = this;
            }

            public boolean hasNext() {
                return (long)this.count < BytesHashMap.this.numElements;
            }

            @Override
            public Entry next(Entry reuse) throws IOException {
                if (this.hasNext()) {
                    ++this.count;
                    BytesHashMap.this.keySerializer.mapFromPages(reuse.getKey(), (AbstractPagedInputView)this);
                    BytesHashMap.this.valueSerializer.mapFromPages(reuse.getValue(), (AbstractPagedInputView)this);
                    return reuse;
                }
                return null;
            }

            @Override
            public Entry next() throws IOException {
                throw new UnsupportedOperationException("");
            }

            @Override
            protected int getLimitForSegment(MemorySegment segment) {
                return BytesHashMap.this.segmentSize;
            }

            @Override
            protected MemorySegment nextSegment(MemorySegment current) throws EOFException, IOException {
                return (MemorySegment)RecordArea.this.segments.get(++this.currentSegmentIndex);
            }
        }

        private final class RecordAreaMemorySource
        implements MemorySegmentSource {
            private RecordAreaMemorySource() {
            }

            @Override
            public MemorySegment nextSegment() {
                int s = BytesHashMap.this.freeMemorySegments.size();
                if (s > 0) {
                    return (MemorySegment)BytesHashMap.this.freeMemorySegments.remove(s - 1);
                }
                if (BytesHashMap.this.reservedNumBuffers + BytesHashMap.this.allocatedFloatingNum < BytesHashMap.this.preferredNumBuffers) {
                    int requestNum = Math.min(BytesHashMap.this.perRequestNumBuffers, BytesHashMap.this.preferredNumBuffers - BytesHashMap.this.allocatedFloatingNum - BytesHashMap.this.reservedNumBuffers);
                    try {
                        List allocateSegs = BytesHashMap.this.allocateSegments(requestNum);
                        BytesHashMap.this.freeMemorySegments.addAll(allocateSegs);
                        allocateSegs.clear();
                        return (MemorySegment)BytesHashMap.this.freeMemorySegments.remove(BytesHashMap.this.freeMemorySegments.size() - 1);
                    }
                    catch (MemoryAllocationException e2) {
                        LOG.warn("BytesHashMap can't allocate {} pages, and now used {} pages", new Object[]{BytesHashMap.this.perRequestNumBuffers, BytesHashMap.this.reservedNumBuffers + BytesHashMap.this.allocatedFloatingNum, e2});
                        return null;
                    }
                }
                return null;
            }
        }
    }
}

