/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.apache.flink.table.runtime.util.ResettableRowBuffer;
import org.apache.flink.table.typeutils.AbstractRowSerializer;

public class ResettableListBuffer
implements ResettableRowBuffer<BaseRow> {
    private final MemoryManager memoryManager;
    private final IOManager ioManager;
    private final List<MemorySegment> memory;
    private final AbstractRowSerializer<BaseRow> serializer;
    private final int maxSize;
    private boolean fallback;
    private ArrayList<BaseRow> list;
    private ResettableExternalBuffer externalBuffer;

    public ResettableListBuffer(MemoryManager memoryManager, IOManager ioManager, List<MemorySegment> memory, AbstractRowSerializer serializer) {
        this(memoryManager, ioManager, memory, serializer, 2048);
    }

    public ResettableListBuffer(MemoryManager memoryManager, IOManager ioManager, List<MemorySegment> memory, AbstractRowSerializer serializer, int maxSize) {
        this.memoryManager = memoryManager;
        this.ioManager = ioManager;
        this.memory = memory;
        this.serializer = serializer;
        this.maxSize = maxSize;
        this.list = new ArrayList(maxSize);
        this.fallback = false;
    }

    private void fallbackToExternal() throws IOException {
        this.externalBuffer = new ResettableExternalBuffer(this.memoryManager, this.ioManager, this.memory, this.serializer);
        for (BaseRow row2 : this.list) {
            this.externalBuffer.add(row2);
        }
        this.list = null;
        this.fallback = true;
    }

    @Override
    public void reset() {
        if (this.fallback) {
            this.externalBuffer.reset();
        } else {
            this.list.clear();
        }
    }

    @Override
    public void add(BaseRow row2) throws IOException {
        if (this.fallback) {
            this.externalBuffer.add(row2);
        } else {
            this.list.add(this.serializer.copy(row2));
            if (this.list.size() > this.maxSize) {
                this.fallbackToExternal();
            }
        }
    }

    @Override
    public int size() {
        return this.fallback ? this.externalBuffer.size() : this.list.size();
    }

    public BufferIterator newIterator() {
        BufferIterator iter = new BufferIterator();
        if (this.fallback) {
            iter.externalIter = this.externalBuffer.newIterator();
        } else {
            iter.memIter = this.list.iterator();
        }
        return iter;
    }

    public BufferIterator newIterator(int beginRow) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.fallback) {
            this.externalBuffer.close();
        } else {
            this.list = null;
            this.memoryManager.release(this.memory);
        }
    }

    public class BufferIterator
    implements ResettableRowBuffer.ResettableIterator<BaseRow> {
        private Iterator<BaseRow> memIter;
        private BaseRow currRow;
        private ResettableExternalBuffer.BufferIterator externalIter;

        @Override
        public void reset() throws IOException {
            if (ResettableListBuffer.this.fallback) {
                this.externalIter.reset();
            } else {
                this.memIter = ResettableListBuffer.this.list.iterator();
            }
        }

        @Override
        public void close() throws IOException {
            if (ResettableListBuffer.this.fallback) {
                this.externalIter.close();
            }
        }

        @Override
        public boolean advanceNext() {
            if (ResettableListBuffer.this.fallback) {
                return this.externalIter.advanceNext();
            }
            boolean has = this.memIter.hasNext();
            if (has) {
                this.currRow = this.memIter.next();
            }
            return has;
        }

        @Override
        public BaseRow getRow() {
            return ResettableListBuffer.this.fallback ? this.externalIter.getRow() : this.currRow;
        }
    }
}

