/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.window;

import java.time.Duration;
import java.util.TimeZone;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.table.codegen.GeneratedRecordEqualiser;
import org.apache.flink.table.codegen.GeneratedSubKeyedAggsHandleFunction;
import org.apache.flink.table.runtime.functions.SubKeyedAggsHandleFunction;
import org.apache.flink.table.runtime.sort.RecordEqualiser;
import org.apache.flink.table.runtime.window.WindowOperator;
import org.apache.flink.table.runtime.window.assigners.CountSlidingWindowAssigner;
import org.apache.flink.table.runtime.window.assigners.CountTumblingWindowAssigner;
import org.apache.flink.table.runtime.window.assigners.InternalTimeWindowAssigner;
import org.apache.flink.table.runtime.window.assigners.SessionWindowAssigner;
import org.apache.flink.table.runtime.window.assigners.SlidingWindowAssigner;
import org.apache.flink.table.runtime.window.assigners.TumblingWindowAssigner;
import org.apache.flink.table.runtime.window.assigners.WindowAssigner;
import org.apache.flink.table.runtime.window.triggers.Element;
import org.apache.flink.table.runtime.window.triggers.EventTime;
import org.apache.flink.table.runtime.window.triggers.ProcessingTime;
import org.apache.flink.table.runtime.window.triggers.Trigger;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.util.Preconditions;

public class WindowOperatorBuilder {
    private InternalType[] inputFieldTypes;
    private WindowAssigner<?> windowAssigner;
    private Trigger<?> trigger;
    private SubKeyedAggsHandleFunction<?> aggregateFunction;
    private GeneratedSubKeyedAggsHandleFunction<?> generatedAggregateFunction;
    private RecordEqualiser equaliser;
    private GeneratedRecordEqualiser generatedEqualiser;
    private InternalType[] accumulatorTypes;
    private InternalType[] aggResultTypes;
    private InternalType[] windowPropertyTypes;
    private long allowedLateness = 0L;
    private boolean sendRetraction = false;
    private int rowtimeIndex = -1;

    public static WindowOperatorBuilder builder() {
        return new WindowOperatorBuilder();
    }

    public WindowOperatorBuilder withInputFields(InternalType[] inputFieldTypes) {
        this.inputFieldTypes = inputFieldTypes;
        return this;
    }

    public WindowOperatorBuilder tumble(Duration size, TimeZone timeZone) {
        Preconditions.checkArgument(this.windowAssigner == null);
        this.windowAssigner = TumblingWindowAssigner.of(size).withTimeZone(timeZone);
        return this;
    }

    public WindowOperatorBuilder sliding(Duration size, Duration slide, TimeZone timeZone) {
        Preconditions.checkArgument(this.windowAssigner == null);
        this.windowAssigner = SlidingWindowAssigner.of(size, slide).withTimeZone(timeZone);
        return this;
    }

    public WindowOperatorBuilder session(Duration sessionGap) {
        Preconditions.checkArgument(this.windowAssigner == null);
        this.windowAssigner = SessionWindowAssigner.withGap(sessionGap);
        return this;
    }

    public WindowOperatorBuilder countWindow(long size) {
        Preconditions.checkArgument(this.windowAssigner == null);
        Preconditions.checkArgument(this.trigger == null);
        this.windowAssigner = CountTumblingWindowAssigner.of(size);
        this.trigger = Element.count(size);
        return this;
    }

    public WindowOperatorBuilder countWindow(long size, long slide) {
        Preconditions.checkArgument(this.windowAssigner == null);
        Preconditions.checkArgument(this.trigger == null);
        this.windowAssigner = CountSlidingWindowAssigner.of(size, slide);
        this.trigger = Element.count(size);
        return this;
    }

    public WindowOperatorBuilder assigner(WindowAssigner<?> windowAssigner) {
        Preconditions.checkArgument(this.windowAssigner == null);
        Preconditions.checkNotNull(windowAssigner);
        this.windowAssigner = windowAssigner;
        return this;
    }

    public WindowOperatorBuilder triggering(Trigger<?> trigger) {
        Preconditions.checkNotNull(trigger);
        this.trigger = trigger;
        return this;
    }

    public WindowOperatorBuilder withEventTime(int rowtimeIndex) {
        Preconditions.checkNotNull(this.windowAssigner);
        Preconditions.checkArgument(this.windowAssigner instanceof InternalTimeWindowAssigner);
        InternalTimeWindowAssigner timeWindowAssigner = (InternalTimeWindowAssigner)((Object)this.windowAssigner);
        this.windowAssigner = (WindowAssigner)((Object)timeWindowAssigner.withEventTime());
        this.rowtimeIndex = rowtimeIndex;
        if (this.trigger == null) {
            this.trigger = EventTime.afterEndOfWindow();
        }
        return this;
    }

    public WindowOperatorBuilder withProcessingTime() {
        Preconditions.checkNotNull(this.windowAssigner);
        Preconditions.checkArgument(this.windowAssigner instanceof InternalTimeWindowAssigner);
        InternalTimeWindowAssigner timeWindowAssigner = (InternalTimeWindowAssigner)((Object)this.windowAssigner);
        this.windowAssigner = (WindowAssigner)((Object)timeWindowAssigner.withProcessingTime());
        if (this.trigger == null) {
            this.trigger = ProcessingTime.afterEndOfWindow();
        }
        return this;
    }

    public WindowOperatorBuilder withAllowedLateness(Duration allowedLateness) {
        Preconditions.checkArgument(!allowedLateness.isNegative());
        if (allowedLateness.toMillis() > 0L) {
            this.allowedLateness = allowedLateness.toMillis();
            this.sendRetraction = true;
        }
        return this;
    }

    public WindowOperatorBuilder aggregate(SubKeyedAggsHandleFunction<?> aggregateFunction, RecordEqualiser equaliser, InternalType[] accumulatorTypes, InternalType[] aggResultTypes, InternalType[] windowPropertyTypes) {
        ClosureCleaner.clean(aggregateFunction, (boolean)true);
        this.accumulatorTypes = accumulatorTypes;
        this.aggResultTypes = aggResultTypes;
        this.windowPropertyTypes = windowPropertyTypes;
        this.aggregateFunction = Preconditions.checkNotNull(aggregateFunction);
        this.equaliser = Preconditions.checkNotNull(equaliser);
        return this;
    }

    public WindowOperatorBuilder aggregate(GeneratedSubKeyedAggsHandleFunction<?> generatedAggregateFunction, GeneratedRecordEqualiser generatedEqualiser, InternalType[] accumulatorTypes, InternalType[] aggResultTypes, InternalType[] windowPropertyTypes) {
        this.accumulatorTypes = accumulatorTypes;
        this.aggResultTypes = aggResultTypes;
        this.windowPropertyTypes = windowPropertyTypes;
        this.generatedAggregateFunction = Preconditions.checkNotNull(generatedAggregateFunction);
        this.generatedEqualiser = Preconditions.checkNotNull(generatedEqualiser);
        return this;
    }

    public WindowOperatorBuilder withSendRetraction() {
        this.sendRetraction = true;
        return this;
    }

    public WindowOperator build() {
        Preconditions.checkNotNull(this.trigger, "trigger is not set");
        if (this.generatedAggregateFunction != null && this.generatedEqualiser != null) {
            return new WindowOperator(this.generatedAggregateFunction, this.generatedEqualiser, this.windowAssigner, this.trigger, this.windowAssigner.getWindowSerializer(new ExecutionConfig()), this.inputFieldTypes, this.accumulatorTypes, this.aggResultTypes, this.windowPropertyTypes, this.rowtimeIndex, this.sendRetraction, this.allowedLateness);
        }
        return new WindowOperator(this.aggregateFunction, this.equaliser, this.windowAssigner, this.trigger, this.windowAssigner.getWindowSerializer(new ExecutionConfig()), this.inputFieldTypes, this.accumulatorTypes, this.aggResultTypes, this.windowPropertyTypes, this.rowtimeIndex, this.sendRetraction, this.allowedLateness);
    }
}

