/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.window.aligned;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.window.TimeWindow;
import org.apache.flink.table.codegen.GeneratedSubKeyedAggsHandleFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.functions.ExecutionContext;
import org.apache.flink.table.runtime.functions.SubKeyedAggsHandleFunction;
import org.apache.flink.table.runtime.window.aligned.AlignedWindowAggregator;
import org.apache.flink.table.runtime.window.aligned.BufferedAlignedWindowAggregator;

public final class GlobalAlignedWindowAggregator
extends BufferedAlignedWindowAggregator {
    private static final long serialVersionUID = 8587640048900077451L;
    private final GeneratedSubKeyedAggsHandleFunction<TimeWindow> generatedLocalWindowAgg;
    private transient SubKeyedAggsHandleFunction<TimeWindow> localWindowAggregator;

    public GlobalAlignedWindowAggregator(TypeInformation<BaseRow> accTypeInfo, TypeInformation<BaseRow> aggResultTypeInfo, GeneratedSubKeyedAggsHandleFunction<TimeWindow> generatedLocalWindowAgg, GeneratedSubKeyedAggsHandleFunction<TimeWindow> generatedGlobalWindowAgg, long minibatchSize, boolean sendRetraction) {
        super(accTypeInfo, aggResultTypeInfo, generatedGlobalWindowAgg, minibatchSize, sendRetraction);
        this.generatedLocalWindowAgg = generatedLocalWindowAgg;
    }

    @Override
    public void open(AlignedWindowAggregator.Context context) throws Exception {
        super.open(context);
        ExecutionContext ctx = context.getExecutionContext();
        this.localWindowAggregator = (SubKeyedAggsHandleFunction)this.generatedLocalWindowAgg.newInstance(ctx.getRuntimeContext().getUserCodeClassLoader());
        this.localWindowAggregator.open(ctx);
    }

    @Override
    protected BaseRow processInput(TimeWindow window, BaseRow input, BaseRow acc) throws Exception {
        this.localWindowAggregator.setAccumulators(null, acc);
        this.localWindowAggregator.merge(window, input);
        return this.localWindowAggregator.getAccumulators();
    }
}

