/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.window.aligned;

import java.time.Duration;
import java.util.TimeZone;
import org.apache.flink.table.api.window.TimeWindow;
import org.apache.flink.table.runtime.window.aligned.AlignedWindowTrigger;

public class InternalAlignedWindowTriggers {
    public static AlignedWindowTrigger tumbling(Duration size, TimeZone timeZone) {
        return new TumblingTimeWindowTrigger(size.toMillis(), timeZone);
    }

    public static AlignedWindowTrigger sliding(Duration size, Duration slide, TimeZone timeZone) {
        return new SlidingTimeWindowTrigger(size.toMillis(), slide.toMillis(), timeZone);
    }

    private static final class SlidingTimeWindowTrigger
    implements AlignedWindowTrigger {
        private static final long serialVersionUID = 1L;
        private final long size;
        private final long slide;
        private final long offset;
        private final TimeZone timeZone;

        private SlidingTimeWindowTrigger(long size, long slide, long offset, TimeZone timeZone) {
            if (size % slide != 0L) {
                throw new IllegalArgumentException("SlidingAlignedEventTimeTrigger parameters must satisfy size % slide = 0");
            }
            this.size = size;
            this.slide = slide;
            this.offset = offset;
            this.timeZone = timeZone;
        }

        private SlidingTimeWindowTrigger(long size, long slide, long offset) {
            this(size, slide, offset, TimeZone.getTimeZone("UTC"));
        }

        private SlidingTimeWindowTrigger(long size, long slide, TimeZone timeZone) {
            this(size, slide, -timeZone.getOffset(15L), timeZone);
        }

        @Override
        public long nextTriggerTime(long clockTime) {
            long start;
            long max;
            long tzOffset = this.offset;
            if (this.timeZone.useDaylightTime()) {
                tzOffset = -this.timeZone.getOffset(clockTime);
            }
            return (max = (start = TimeWindow.getWindowStartWithOffset(clockTime, tzOffset, this.slide)) + this.slide - 1L) > clockTime ? max : max + this.slide;
        }

        @Override
        public TimeWindow nextTriggerWindow(long clockTime) {
            long maxTimestamp = this.nextTriggerTime(clockTime);
            long windowEnd = maxTimestamp + 1L;
            return new TimeWindow(windowEnd - this.size, windowEnd);
        }
    }

    private static final class TumblingTimeWindowTrigger
    implements AlignedWindowTrigger {
        private static final long serialVersionUID = 1L;
        private final long size;
        private final long offset;
        private final TimeZone timeZone;

        private TumblingTimeWindowTrigger(long size, long offset, TimeZone timeZone) {
            this.size = size;
            this.offset = offset;
            this.timeZone = timeZone;
        }

        private TumblingTimeWindowTrigger(long size, long offset) {
            this(size, offset, TimeZone.getTimeZone("UTC"));
        }

        private TumblingTimeWindowTrigger(long size, TimeZone timeZone) {
            this(size, -timeZone.getOffset(15L), timeZone);
        }

        @Override
        public long nextTriggerTime(long clockTime) {
            long start;
            long max;
            long tzOffset = this.offset;
            if (this.timeZone.useDaylightTime()) {
                tzOffset = -this.timeZone.getOffset(clockTime);
            }
            return (max = (start = TimeWindow.getWindowStartWithOffset(clockTime, tzOffset, this.size)) + this.size - 1L) > clockTime ? max : max + this.size;
        }

        @Override
        public TimeWindow nextTriggerWindow(long clockTime) {
            long maxTimestamp = this.nextTriggerTime(clockTime);
            long windowEnd = maxTimestamp + 1L;
            return new TimeWindow(windowEnd - this.size, windowEnd);
        }
    }
}

