/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.window.aligned;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.window.TimeWindow;
import org.apache.flink.table.codegen.GeneratedSubKeyedAggsHandleFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.util.BaseRowUtil;
import org.apache.flink.table.runtime.window.aligned.BufferedAlignedWindowAggregator;

public class OnePhaseAlignedWindowAggregator
extends BufferedAlignedWindowAggregator {
    private static final long serialVersionUID = 2229485674427835761L;

    public OnePhaseAlignedWindowAggregator(TypeInformation<BaseRow> accTypeInfo, TypeInformation<BaseRow> aggResultTypeInfo, GeneratedSubKeyedAggsHandleFunction<TimeWindow> generatedWindowAggregator, long minibatchSize, boolean sendRetraction) {
        super(accTypeInfo, aggResultTypeInfo, generatedWindowAggregator, minibatchSize, sendRetraction);
    }

    @Override
    protected BaseRow processInput(TimeWindow window, BaseRow input, BaseRow acc) throws Exception {
        this.windowAggregator.setAccumulators(null, acc);
        if (BaseRowUtil.isAccumulateMsg(input)) {
            this.windowAggregator.accumulate(input);
        } else {
            this.windowAggregator.retract(input);
        }
        return this.windowAggregator.getAccumulators();
    }
}

