/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.window.assigners;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TimeZone;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.window.TimeWindow;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.window.assigners.InternalTimeWindowAssigner;
import org.apache.flink.table.runtime.window.assigners.PanedWindowAssigner;
import org.apache.flink.util.IterableIterator;
import org.apache.flink.util.MathUtils;

public class SlidingWindowAssigner
extends PanedWindowAssigner<TimeWindow>
implements InternalTimeWindowAssigner {
    private static final long serialVersionUID = 4895551155814656518L;
    private final long size;
    private final long slide;
    private final long offset;
    private final long paneSize;
    private final TimeZone timeZone;
    private final int numPanesPerWindow;
    private final boolean isEventTime;

    protected SlidingWindowAssigner(long size, long slide, long offset, TimeZone timeZone, boolean isEventTime) {
        if (size <= 0L || slide <= 0L) {
            throw new IllegalArgumentException("SlidingWindowAssigner parameters must satisfy slide > 0 and size > 0");
        }
        this.size = size;
        this.slide = slide;
        this.offset = offset;
        this.timeZone = timeZone;
        this.isEventTime = isEventTime;
        this.paneSize = ArithmeticUtils.gcd((long)size, (long)slide);
        this.numPanesPerWindow = MathUtils.checkedDownCast(size / this.paneSize);
    }

    protected SlidingWindowAssigner(long size, long slide, long offset, boolean isEventTime) {
        this(size, slide, offset, TimeZone.getTimeZone("UTC"), isEventTime);
    }

    protected SlidingWindowAssigner(long size, long slide, TimeZone timeZone, boolean isEventTime) {
        this(size, slide, -timeZone.getOffset(15L), timeZone, isEventTime);
    }

    @Override
    public Collection<TimeWindow> assignWindows(BaseRow element, long timestamp) {
        long lastStart;
        ArrayList<TimeWindow> windows = new ArrayList<TimeWindow>((int)(this.size / this.slide));
        long tzOffset = this.offset;
        if (this.timeZone.useDaylightTime()) {
            tzOffset = -this.timeZone.getOffset(timestamp);
        }
        for (long start = lastStart = TimeWindow.getWindowStartWithOffset(timestamp, tzOffset, this.slide); start > timestamp - this.size; start -= this.slide) {
            windows.add(new TimeWindow(start, start + this.size));
        }
        return windows;
    }

    @Override
    public TimeWindow assignPane(Object element, long timestamp) {
        long tzOffset = this.offset;
        if (this.timeZone.useDaylightTime()) {
            tzOffset = -this.timeZone.getOffset(timestamp);
        }
        long start = TimeWindow.getWindowStartWithOffset(timestamp, tzOffset, this.paneSize);
        return new TimeWindow(start, start + this.paneSize);
    }

    @Override
    public Iterable<TimeWindow> splitIntoPanes(TimeWindow window) {
        return new PanesIterable(window.getStart(), this.paneSize, this.numPanesPerWindow);
    }

    @Override
    public TimeWindow getLastWindow(TimeWindow pane) {
        long tzOffset = this.offset;
        if (this.timeZone.useDaylightTime()) {
            tzOffset = -this.timeZone.getOffset(pane.getStart());
        }
        long lastStart = TimeWindow.getWindowStartWithOffset(pane.getStart(), tzOffset, this.slide);
        return new TimeWindow(lastStart, lastStart + this.size);
    }

    @Override
    public TypeSerializer<TimeWindow> getWindowSerializer(ExecutionConfig executionConfig) {
        return new TimeWindow.Serializer();
    }

    @Override
    public boolean isEventTime() {
        return this.isEventTime;
    }

    @Override
    public String toString() {
        return "SlidingWindow(" + this.size + ", " + this.slide + ")";
    }

    public static SlidingWindowAssigner of(Duration size, Duration slide) {
        return new SlidingWindowAssigner(size.toMillis(), slide.toMillis(), 0L, true);
    }

    public SlidingWindowAssigner withOffset(Duration offset) {
        return new SlidingWindowAssigner(this.size, this.slide, offset.toMillis(), this.isEventTime);
    }

    public SlidingWindowAssigner withTimeZone(TimeZone timeZone) {
        return new SlidingWindowAssigner(this.size, this.slide, timeZone, this.isEventTime);
    }

    @Override
    public SlidingWindowAssigner withEventTime() {
        return new SlidingWindowAssigner(this.size, this.slide, this.offset, this.timeZone, true);
    }

    @Override
    public SlidingWindowAssigner withProcessingTime() {
        return new SlidingWindowAssigner(this.size, this.slide, this.offset, this.timeZone, false);
    }

    private static class PanesIterable
    implements IterableIterator<TimeWindow> {
        private final long paneSize;
        private long paneStart;
        private int numPanesRemaining;

        PanesIterable(long paneStart, long paneSize, int numPanesPerWindow) {
            this.paneStart = paneStart;
            this.paneSize = paneSize;
            this.numPanesRemaining = numPanesPerWindow;
        }

        @Override
        public boolean hasNext() {
            return this.numPanesRemaining > 0;
        }

        @Override
        public TimeWindow next() {
            TimeWindow window = new TimeWindow(this.paneStart, this.paneStart + this.paneSize);
            --this.numPanesRemaining;
            this.paneStart += this.paneSize;
            return window;
        }

        @Override
        public Iterator<TimeWindow> iterator() {
            return this;
        }
    }
}

