/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.window.grouping;

import java.io.IOException;
import org.apache.flink.table.api.window.TimeWindow;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.functions.DateTimeFunctions;
import org.apache.flink.table.runtime.util.RowIterator;
import org.apache.flink.util.Preconditions;

public abstract class AbstractWindowsGrouping {
    private final long windowStartOffset;
    private final long windowSize;
    private final long slideSize;
    private final int timeIndex;
    private long watermark;
    private TimeWindow nextWindow;
    private TimeWindow currentWindow;
    private int triggerWindowStartIndex;
    private boolean emptyWindowTriggered;
    private boolean isDate;

    AbstractWindowsGrouping(long windowSize, long slideSize, int timestampIndex, boolean isDate) {
        this(0L, windowSize, slideSize, timestampIndex, isDate);
    }

    AbstractWindowsGrouping(long offset, long windowSize, long slideSize, int timeIndex, boolean isDate) {
        this.windowStartOffset = offset;
        this.windowSize = windowSize;
        this.slideSize = slideSize;
        this.timeIndex = timeIndex;
        this.isDate = isDate;
        this.nextWindow = null;
        this.watermark = Long.MIN_VALUE;
        this.triggerWindowStartIndex = 0;
        this.emptyWindowTriggered = true;
        this.createBuffer();
    }

    public void reset() {
        this.nextWindow = null;
        this.watermark = Long.MIN_VALUE;
        this.triggerWindowStartIndex = 0;
        this.emptyWindowTriggered = true;
        this.resetBuffer();
    }

    public void close() {
    }

    public void addInputToBuffer(BinaryRow input) throws IOException {
        if (!input.isNullAt(this.timeIndex)) {
            this.addIntoBuffer(input.copy());
            this.advanceWatermark(this.getTimeValue(input));
        }
    }

    public void advanceWatermarkToTriggerAllWindows() {
        this.skipEmptyWindow();
        this.advanceWatermark(this.watermark + this.windowSize);
    }

    public boolean hasTriggerWindow() {
        this.skipEmptyWindow();
        Preconditions.checkState(this.watermark == Long.MIN_VALUE || this.nextWindow != null, "next trigger window cannot be null.");
        return this.nextWindow != null && this.nextWindow.getEnd() <= this.watermark;
    }

    public RowIterator<BinaryRow> buildTriggerWindowElementsIterator() {
        this.currentWindow = this.nextWindow;
        Preconditions.checkState(this.watermark == Long.MIN_VALUE || this.nextWindow != null, "next trigger window cannot be null.");
        if (this.nextWindow.getEnd() > this.watermark) {
            throw new IllegalStateException("invalid window triggered " + this.currentWindow);
        }
        this.nextWindow = TimeWindow.of(this.currentWindow.getStart() + this.slideSize, this.currentWindow.getStart() + this.slideSize + this.windowSize);
        this.emptyWindowTriggered = true;
        this.onBufferEvict(this.triggerWindowStartIndex);
        return new WindowsElementsIterator(this.newBufferIterator(this.triggerWindowStartIndex));
    }

    public TimeWindow getTriggerWindow() {
        return this.currentWindow;
    }

    private boolean belongsToCurrentWindow(BinaryRow element) {
        long currentTimestamp2 = this.getTimeValue(element);
        if (currentTimestamp2 >= this.currentWindow.getStart() && currentTimestamp2 < this.currentWindow.getEnd()) {
            this.evictForWindow(element, this.nextWindow);
            return true;
        }
        return false;
    }

    private boolean evictForWindow(BinaryRow element, TimeWindow window) {
        if (this.getTimeValue(element) < window.getStart()) {
            ++this.triggerWindowStartIndex;
            return true;
        }
        return false;
    }

    private void advanceWatermark(long timestamp) {
        this.watermark = timestamp;
    }

    private void skipEmptyWindow() {
        if (this.emptyWindowTriggered && this.watermark != Long.MIN_VALUE) {
            this.nextWindow = this.advanceNextWindowByWatermark(this.watermark);
            this.emptyWindowTriggered = false;
        }
    }

    private TimeWindow advanceNextWindowByWatermark(long watermark) {
        long nextStart;
        int maxOverlapping = (int)Math.ceil((double)this.windowSize * 1.0 / (double)this.slideSize);
        long start = this.getWindowStartWithOffset(watermark, this.windowStartOffset, this.slideSize);
        for (int i = 1; i < maxOverlapping && (nextStart = start - this.slideSize) + this.windowSize > watermark; ++i) {
            start = nextStart;
        }
        if (this.nextWindow == null || start > this.nextWindow.getStart()) {
            return TimeWindow.of(start, start + this.windowSize);
        }
        return this.nextWindow;
    }

    private long getWindowStartWithOffset(long timestamp, long offset, long windowSize) {
        long remainder = (timestamp - offset) % windowSize;
        if (remainder < 0L) {
            return timestamp - (remainder + windowSize);
        }
        return timestamp - remainder;
    }

    private long getTimeValue(BaseRow row2) {
        if (this.isDate) {
            return row2.getInt(this.timeIndex) * DateTimeFunctions.MILLIS_PER_DAY();
        }
        return row2.getLong(this.timeIndex);
    }

    protected abstract void createBuffer();

    protected abstract void resetBuffer();

    protected abstract void addIntoBuffer(BinaryRow var1) throws IOException;

    protected abstract void onBufferEvict(int var1);

    protected abstract RowIterator<BinaryRow> newBufferIterator(int var1);

    class WindowsElementsIterator
    implements RowIterator<BinaryRow> {
        private final RowIterator<BinaryRow> bufferIterator;
        private BinaryRow next;

        WindowsElementsIterator(RowIterator<BinaryRow> iterator) {
            this.bufferIterator = iterator;
        }

        @Override
        public boolean advanceNext() {
            do {
                if (!this.bufferIterator.advanceNext()) {
                    this.next = null;
                    return false;
                }
                this.next = this.bufferIterator.getRow();
            } while (AbstractWindowsGrouping.this.evictForWindow(this.next, AbstractWindowsGrouping.this.currentWindow));
            if (AbstractWindowsGrouping.this.belongsToCurrentWindow(this.next)) {
                AbstractWindowsGrouping.this.emptyWindowTriggered = false;
                return true;
            }
            this.next = null;
            return false;
        }

        @Override
        public BinaryRow getRow() {
            return this.next;
        }
    }
}

