/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.window.grouping;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.util.RowIterator;
import org.apache.flink.table.runtime.window.grouping.AbstractWindowsGrouping;

public class HeapWindowsGrouping
extends AbstractWindowsGrouping {
    private LinkedList<BinaryRow> buffer;
    private final int limit;
    private int evictLimitIndex;
    private Iterator<BinaryRow> iterator;

    public HeapWindowsGrouping(int limit, long windowSize, long slideSize, int timeIndex, boolean isDate) {
        this(limit, 0L, windowSize, slideSize, timeIndex, isDate);
    }

    public HeapWindowsGrouping(int limit, long offset, long windowSize, long slideSize, int timeIndex, boolean isDate) {
        super(offset, windowSize, slideSize, timeIndex, isDate);
        this.limit = limit;
        this.evictLimitIndex = 0;
    }

    @Override
    protected void createBuffer() {
        this.buffer = new LinkedList();
    }

    @Override
    protected void resetBuffer() {
        this.buffer.clear();
        this.evictLimitIndex = 0;
        this.iterator = null;
    }

    @Override
    protected void onBufferEvict(int limitIndex) {
        while (this.evictLimitIndex < limitIndex) {
            this.buffer.removeFirst();
            ++this.evictLimitIndex;
        }
    }

    @Override
    protected void addIntoBuffer(BinaryRow input) throws IOException {
        if (this.buffer.size() >= this.limit) {
            throw new IOException("HeapWindowsGrouping out of memory, element size limit " + this.limit);
        }
        this.buffer.add(input);
    }

    @Override
    protected RowIterator<BinaryRow> newBufferIterator(int startIndex) {
        this.iterator = this.buffer.subList(startIndex - this.evictLimitIndex, this.buffer.size()).iterator();
        return new BufferIterator(this.iterator);
    }

    private final class BufferIterator
    implements RowIterator<BinaryRow> {
        private final Iterator<BinaryRow> iterator;
        private BinaryRow next;

        BufferIterator(Iterator<BinaryRow> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean advanceNext() {
            if (this.iterator.hasNext()) {
                this.next = this.iterator.next();
                return true;
            }
            this.next = null;
            return false;
        }

        @Override
        public BinaryRow getRow() {
            return this.next;
        }
    }
}

