/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.window.triggers;

import java.time.Duration;
import org.apache.flink.api.common.functions.Merger;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.api.window.Window;
import org.apache.flink.table.runtime.window.triggers.Trigger;
import org.apache.flink.util.Preconditions;

public class ProcessingTime {
    private static final Merger<Long> MERGER = new MinAmongSet();
    private static final String TO_STRING = "ProcessingTime.afterEndOfWindow()";

    public static <W extends Window> AfterEndOfWindow<W> afterEndOfWindow() {
        return new AfterEndOfWindow();
    }

    public static <W extends Window> AfterFirstElementPeriodic<W> every(Duration time) {
        return new AfterFirstElementPeriodic(time.toMillis());
    }

    private static final class MinAmongSet
    implements Merger<Long> {
        private static final long serialVersionUID = 1L;

        private MinAmongSet() {
        }

        @Override
        public Long merge(Long value1, Long value2) {
            if (value1 == null || value2 == null) {
                return value1 == null ? value2 : value1;
            }
            return Math.min(value1, value2);
        }
    }

    public static final class AfterEndOfWindowNoLate<W extends Window>
    extends Trigger<W> {
        private static final long serialVersionUID = 2310050856564792734L;
        private final Trigger<W> earlyTrigger;
        private Trigger.TriggerContext ctx;

        AfterEndOfWindowNoLate(Trigger<W> earlyTrigger) {
            Preconditions.checkNotNull(earlyTrigger);
            this.earlyTrigger = earlyTrigger;
        }

        @Override
        public void open(Trigger.TriggerContext ctx) throws Exception {
            this.ctx = ctx;
            this.earlyTrigger.open(ctx);
        }

        @Override
        public boolean onElement(Object element, long timestamp, W window) throws Exception {
            this.ctx.registerProcessingTimeTimer(((Window)window).maxTimestamp());
            return this.earlyTrigger.onElement(element, timestamp, window);
        }

        @Override
        public boolean onProcessingTime(long time, W window) throws Exception {
            return time == ((Window)window).maxTimestamp() || this.earlyTrigger.onProcessingTime(time, window);
        }

        @Override
        public boolean onEventTime(long time, W window) throws Exception {
            return this.earlyTrigger.onEventTime(time, window);
        }

        @Override
        public boolean canMerge() {
            return this.earlyTrigger.canMerge();
        }

        @Override
        public void onMerge(W window, Trigger.OnMergeContext mergeContext) throws Exception {
            this.ctx.registerProcessingTimeTimer(((Window)window).maxTimestamp());
            this.earlyTrigger.onMerge(window, mergeContext);
        }

        @Override
        public void clear(W window) throws Exception {
            this.ctx.deleteProcessingTimeTimer(((Window)window).maxTimestamp());
            this.earlyTrigger.clear(window);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(ProcessingTime.TO_STRING);
            if (this.earlyTrigger != null) {
                builder.append(".withEarlyFirings(").append(this.earlyTrigger).append(")");
            }
            return builder.toString();
        }
    }

    public static final class AfterEndOfWindow<W extends Window>
    extends Trigger<W> {
        private static final long serialVersionUID = 2369815941792574642L;
        private Trigger.TriggerContext ctx;

        public AfterEndOfWindowNoLate<W> withEarlyFirings(Trigger<W> earlyFirings) {
            Preconditions.checkNotNull(earlyFirings);
            return new AfterEndOfWindowNoLate<W>(earlyFirings);
        }

        @Override
        public void open(Trigger.TriggerContext ctx) throws Exception {
            this.ctx = ctx;
        }

        @Override
        public boolean onElement(Object element, long timestamp, W window) throws Exception {
            this.ctx.registerProcessingTimeTimer(((Window)window).maxTimestamp());
            return false;
        }

        @Override
        public boolean onProcessingTime(long time, W window) throws Exception {
            return time == ((Window)window).maxTimestamp();
        }

        @Override
        public boolean onEventTime(long time, W window) throws Exception {
            return false;
        }

        @Override
        public void clear(W window) throws Exception {
            this.ctx.deleteProcessingTimeTimer(((Window)window).maxTimestamp());
        }

        @Override
        public boolean canMerge() {
            return true;
        }

        @Override
        public void onMerge(W window, Trigger.OnMergeContext mergeContext) throws Exception {
            this.ctx.registerProcessingTimeTimer(((Window)window).maxTimestamp());
        }

        public String toString() {
            return ProcessingTime.TO_STRING;
        }
    }

    public static final class AfterFirstElementPeriodic<W extends Window>
    extends Trigger<W> {
        private static final long serialVersionUID = -4710472821577125673L;
        private final long interval;
        private transient Trigger.TriggerContext ctx;
        private transient ValueState<Long> nextFiring;

        AfterFirstElementPeriodic(long interval) {
            Preconditions.checkArgument(interval > 0L);
            this.interval = interval;
        }

        @Override
        public void open(Trigger.TriggerContext ctx) throws Exception {
            this.ctx = ctx;
            String descriptorName = "processingTime-every-" + this.interval;
            ValueStateDescriptor<Long> nextFiringDescriptor = new ValueStateDescriptor<Long>(descriptorName, Types.LONG);
            this.nextFiring = ctx.getValueState(nextFiringDescriptor);
        }

        @Override
        public boolean onElement(Object element, long timestamp, W window) throws Exception {
            Long timer = this.nextFiring.value();
            if (timer == null) {
                long nextTimer = this.ctx.getCurrentProcessingTime() + this.interval;
                this.ctx.registerProcessingTimeTimer(nextTimer);
                this.nextFiring.update(nextTimer);
            }
            return false;
        }

        @Override
        public boolean onProcessingTime(long time, W window) throws Exception {
            Long timer = this.nextFiring.value();
            if (timer != null && timer == time) {
                long newTimer = time + this.interval;
                this.ctx.registerProcessingTimeTimer(newTimer);
                this.nextFiring.update(newTimer);
                return true;
            }
            return false;
        }

        @Override
        public boolean onEventTime(long time, W window) throws Exception {
            return false;
        }

        @Override
        public boolean canMerge() {
            return true;
        }

        @Override
        public void onMerge(W window, Trigger.OnMergeContext mergeContext) throws Exception {
            Long nextTimer = mergeContext.mergeValueState(this.nextFiring, MERGER);
            if (nextTimer != null) {
                this.ctx.registerProcessingTimeTimer(nextTimer);
            }
        }

        @Override
        public void clear(W window) throws Exception {
            Long timer = this.nextFiring.value();
            if (timer != null) {
                this.ctx.deleteProcessingTimeTimer(timer);
                this.nextFiring.clear();
            }
        }

        public String toString() {
            return "ProcessingTime.every(" + this.interval + ")";
        }
    }
}

