/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks.filesystem;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.table.util.TableProperties;
import org.apache.flink.util.FlinkException;

public final class FileSystemOptions$ {
    public static final FileSystemOptions$ MODULE$;
    private final ConfigOption<String> PATH;
    private final ConfigOption<String> FORMAT;
    private final ConfigOption<String> TIME_ZONE;
    private final ConfigOption<String> WRITE_MODE;
    private final List<String> SUPPORTED_KEYS;

    static {
        new FileSystemOptions$();
    }

    public ConfigOption<String> PATH() {
        return this.PATH;
    }

    public ConfigOption<String> FORMAT() {
        return this.FORMAT;
    }

    public ConfigOption<String> TIME_ZONE() {
        return this.TIME_ZONE;
    }

    public ConfigOption<String> WRITE_MODE() {
        return this.WRITE_MODE;
    }

    public List<String> SUPPORTED_KEYS() {
        return this.SUPPORTED_KEYS;
    }

    public FileSystem.WriteMode readWriteMode(TableProperties tableProperties) {
        block4: {
            FileSystem.WriteMode writeMode;
            block3: {
                String writeMode2;
                block2: {
                    writeMode2 = tableProperties.getString(this.WRITE_MODE()).toLowerCase();
                    if (!"no_overwrite".equals(writeMode2)) break block2;
                    writeMode = FileSystem.WriteMode.NO_OVERWRITE;
                    break block3;
                }
                if (!"overwrite".equals(writeMode2)) break block4;
                writeMode = FileSystem.WriteMode.NO_OVERWRITE;
            }
            return writeMode;
        }
        throw new FlinkException("Unknown overwrite mode, optional: no_overwrite/overwrite");
    }

    private FileSystemOptions$() {
        MODULE$ = this;
        this.PATH = ConfigOptions.key("path").noDefaultValue();
        this.FORMAT = ConfigOptions.key("format".toLowerCase()).noDefaultValue();
        this.TIME_ZONE = ConfigOptions.key("timeZone".toLowerCase()).defaultValue("UTC");
        this.WRITE_MODE = ConfigOptions.key("writeMode".toLowerCase()).defaultValue("NO_OVERWRITE");
        this.SUPPORTED_KEYS = Arrays.asList((Object[])new String[]{this.TIME_ZONE().key(), this.PATH().key(), this.FORMAT().key(), this.WRITE_MODE().key()});
    }
}

