/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks.filesystem;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.flink.table.api.RichTableSchema;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.factories.BatchTableSinkFactory;
import org.apache.flink.table.factories.csv.CsvOptions;
import org.apache.flink.table.factories.orc.ORCOptions;
import org.apache.flink.table.factories.parquet.ParquetOptions;
import org.apache.flink.table.sinks.BatchTableSink;
import org.apache.flink.table.sinks.filesystem.BatchTableSinkHelper;
import org.apache.flink.table.sinks.filesystem.FileSystemOptions$;
import org.apache.flink.table.sinks.filesystem.FileSystemOutputFormat;
import org.apache.flink.table.sinks.filesystem.FileSystemOutputFormat$;
import org.apache.flink.table.sinks.filesystem.OutputFormatFactory;
import org.apache.flink.table.sinks.filesystem.OutputJobDescription;
import org.apache.flink.table.sinks.filesystem.csv.CSVFormatFactory;
import org.apache.flink.table.sinks.filesystem.orc.OrcFormatFactory;
import org.apache.flink.table.sinks.filesystem.parquet.ParquetFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.util.TableProperties;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u001f\tQb)\u001b7f'f\u001cH/Z7UC\ndWmU5oW\u001a\u000b7\r^8ss*\u00111\u0001B\u0001\u000bM&dWm]=ti\u0016l'BA\u0003\u0007\u0003\u0015\u0019\u0018N\\6t\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0019!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003mC:<'\"A\u000b\u0002\t)\fg/Y\u0005\u0003/I\u0011aa\u00142kK\u000e$\bcA\r\u001d=5\t!D\u0003\u0002\u001c\r\u0005Ia-Y2u_JLWm]\u0005\u0003;i\u0011QCQ1uG\"$\u0016M\u00197f'&t7NR1di>\u0014\u0018\u0010\u0005\u0002 E5\t\u0001E\u0003\u0002\"\r\u0005QA-\u0019;bM>\u0014X.\u0019;\n\u0005\r\u0002#a\u0002\"bg\u0016\u0014vn\u001e\u0005\u0006K\u0001!\tAJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0002\"\u0001\u000b\u0001\u000e\u0003\tAQA\u000b\u0001\u0005B-\nAc\u0019:fCR,')\u0019;dQR\u000b'\r\\3TS:\\GC\u0001\u00171!\ricFH\u0007\u0002\t%\u0011q\u0006\u0002\u0002\u000f\u0005\u0006$8\r\u001b+bE2,7+\u001b8l\u0011\u0015\t\u0014\u00061\u00013\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0005gYB\u0004(D\u00015\u0015\t)D#\u0001\u0003vi&d\u0017BA\u001c5\u0005\ri\u0015\r\u001d\t\u0003s}r!AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\na\u0001\u0015:fI\u00164\u0017B\u0001!B\u0005\u0019\u0019FO]5oO*\u0011ah\u000f\u0005\u0006\u0007\u0002!I\u0001R\u0001\u0011O\u0016$hi\u001c:nCR4\u0015m\u0019;pef$\"!\u0012%\u0011\u0005!2\u0015BA$\u0003\u0005MyU\u000f\u001e9vi\u001a{'/\\1u\r\u0006\u001cGo\u001c:z\u0011\u0015I%\t1\u0001K\u0003\u0015\u0001(o\u001c9t!\tYU*D\u0001M\u0015\t)d!\u0003\u0002O\u0019\nyA+\u00192mKB\u0013x\u000e]3si&,7\u000fC\u0003Q\u0001\u0011\u0005\u0013+A\bsKF,\u0018N]3e\u0007>tG/\u001a=u)\u0005\u0011\u0004\"B*\u0001\t\u0003\"\u0016aE:vaB|'\u000f^3e!J|\u0007/\u001a:uS\u0016\u001cH#A+\u0011\u0007M2\u0006(\u0003\u0002Xi\t!A*[:u\u0001")
public class FileSystemTableSinkFactory
implements BatchTableSinkFactory<BaseRow> {
    @Override
    public BatchTableSink<BaseRow> createBatchTableSink(Map<String, String> properties) {
        TableProperties tableProperties = new TableProperties();
        tableProperties.putProperties(properties);
        RichTableSchema richSchema = tableProperties.readSchemaFromProperties(null);
        OutputFormatFactory formatFactory = this.getFormatFactory(tableProperties);
        String path = tableProperties.getString(FileSystemOptions$.MODULE$.PATH());
        String jobID = UUID.randomUUID().toString();
        RowType inputSchema = richSchema.getResultType();
        RowType partitionSchema = new RowType((DataType[])richSchema.getPartitionDataTypes().toArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(DataType.class))), (String[])richSchema.getPartitionColumns().toArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        OutputJobDescription writeJobDescription = FileSystemOutputFormat$.MODULE$.getOutputJobDescription(formatFactory, new FileSystemOutputFormat.OutputSpec(path, null, inputSchema), (Option<RowType>)new Some((Object)partitionSchema), properties);
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])richSchema.getColumnTypes()).forall((Function1)new Serializable(this, formatFactory){
            public static final long serialVersionUID = 0L;
            private final OutputFormatFactory formatFactory$1;

            public final boolean apply(InternalType x$1) {
                return this.formatFactory$1.supportDataSchema(x$1);
            }
            {
                this.formatFactory$1 = formatFactory$1;
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "FileFormat sink only support built-in data types now.";
            }
        });
        return new BatchTableSinkHelper(writeJobDescription, jobID, path, formatFactory, richSchema);
    }

    private OutputFormatFactory getFormatFactory(TableProperties props) {
        block5: {
            OutputFormatFactory outputFormatFactory;
            block3: {
                String string;
                block4: {
                    block2: {
                        string = props.getString(FileSystemOptions$.MODULE$.FORMAT().key(), "").toLowerCase();
                        if (!"csv".equals(string)) break block2;
                        outputFormatFactory = new CSVFormatFactory();
                        break block3;
                    }
                    if (!"orc".equals(string)) break block4;
                    outputFormatFactory = new OrcFormatFactory();
                    break block3;
                }
                if (!"parquet".equals(string)) break block5;
                outputFormatFactory = new ParquetFormatFactory();
            }
            return outputFormatFactory;
        }
        throw new RuntimeException("Required attribute fileFormat must not be null!");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, String> requiredContext() {
        void var1_1;
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("connector.type", "FILESYSTEM");
        context.put("connector.property-version", "1");
        return var1_1;
    }

    @Override
    public List<String> supportedProperties() {
        return JavaConversions$.MODULE$.bufferAsJavaList(JavaConversions$.MODULE$.asScalaBuffer(FileSystemOptions$.MODULE$.SUPPORTED_KEYS()).$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(CsvOptions.SUPPORTED_KEYS)).$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(ParquetOptions.SUPPORTED_KEYS)).$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(ORCOptions.SUPPORTED_KEYS)));
    }
}

