/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks.filesystem.csv;

import java.util.Map;
import java.util.TimeZone;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.factories.csv.CsvOptions;
import org.apache.flink.table.sinks.csv.BaseRowCsvOutputFormat;
import org.apache.flink.table.sinks.filesystem.FileSystemOptions$;
import org.apache.flink.table.sinks.filesystem.OutputFormatFactory;
import org.apache.flink.table.types.AtomicType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.TypeInfoWrappedDataType;
import org.apache.flink.table.util.TableProperties;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001#\t\u00012i\u0015,G_Jl\u0017\r\u001e$bGR|'/\u001f\u0006\u0003\u0007\u0011\t1aY:w\u0015\t)a!\u0001\u0006gS2,7/_:uK6T!a\u0002\u0005\u0002\u000bMLgn[:\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Qi\u0011\u0001B\u0005\u0003+\u0011\u00111cT;uaV$hi\u001c:nCR4\u0015m\u0019;pefDQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"\u0001\u0002\t\u0013q\u0001\u0001\u0019!A!B\u0013i\u0012aB8qi&|gn\u001d\t\u0005=\r*S%D\u0001 \u0015\t\u0001\u0013%\u0001\u0003vi&d'\"\u0001\u0012\u0002\t)\fg/Y\u0005\u0003I}\u00111!T1q!\t1CF\u0004\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003&\u0001\u0004Qe\u0016$WMZ\u0005\u0003[9\u0012aa\u0015;sS:<'BA\u0016)\u0011\u0015\u0001\u0004\u0001\"\u00112\u0003%\u0019wN\u001c4jOV\u0014X\r\u0006\u00023kA\u0011qeM\u0005\u0003i!\u0012A!\u00168ji\")Ad\fa\u0001;!)q\u0007\u0001C!q\u0005\u0001r-\u001a;GS2,W\t\u001f;f]NLwN\u001c\u000b\u0003KeBQA\u000f\u001cA\u0002m\na\u0001^1tW&#\u0007CA\u0014=\u0013\ti\u0004FA\u0002J]RDQa\u0010\u0001\u0005B\u0001\u000bqB\\3x\u001fV$\b/\u001e;G_Jl\u0017\r\u001e\u000b\u0005\u0003F\u001b6\fE\u0002C\u0013.k\u0011a\u0011\u0006\u0003\t\u0016\u000b!![8\u000b\u0005\u0019;\u0015AB2p[6|gN\u0003\u0002I\u0015\u0005\u0019\u0011\r]5\n\u0005)\u001b%\u0001D(viB,HOR8s[\u0006$\bC\u0001'P\u001b\u0005i%B\u0001(\t\u0003)!\u0017\r^1g_Jl\u0017\r^\u0005\u0003!6\u0013qAQ1tKJ{w\u000fC\u0003S}\u0001\u0007Q%\u0001\u0003qCRD\u0007\"\u0002+?\u0001\u0004)\u0016A\u00033bi\u0006\u001c6\r[3nCB\u0011a+W\u0007\u0002/*\u0011\u0001\fC\u0001\u0006if\u0004Xm]\u0005\u00035^\u0013qAU8x)f\u0004X\rC\u0003;}\u0001\u00071\bC\u0003^\u0001\u0011\u0005c,A\ttkB\u0004xN\u001d;ECR\f7k\u00195f[\u0006$\"a\u00182\u0011\u0005\u001d\u0002\u0017BA1)\u0005\u001d\u0011un\u001c7fC:DQa\u0019/A\u0002\u0011\f\u0001\u0002Z1uCRK\b/\u001a\t\u0003-\u0016L!AZ,\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQ\u0001\u001b\u0001\u0005B%\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002K!)1\u000e\u0001C!Y\u0006A\u0001.Y:i\u0007>$W\rF\u0001<\u0011\u0015q\u0007\u0001\"\u0011p\u0003\u0019)\u0017/^1mgR\u0011q\f\u001d\u0005\u0006c6\u0004\rA]\u0001\u0006_RDWM\u001d\t\u0003OML!\u0001\u001e\u0015\u0003\u0007\u0005s\u0017\u0010")
public class CSVFormatFactory
extends OutputFormatFactory {
    private Map<String, String> options;

    @Override
    public void configure(Map<String, String> options) {
        this.options = options;
    }

    @Override
    public String getFileExtension(int taskId) {
        return ".csv";
    }

    @Override
    public OutputFormat<BaseRow> newOutputFormat(String path, RowType dataSchema, int taskId) {
        TableProperties csvOptions = new TableProperties().putProperties(this.options).toKeyLowerCase();
        BaseRowCsvOutputFormat outputFormat = new BaseRowCsvOutputFormat(new Path(path), dataSchema.getFieldInternalTypes());
        outputFormat.setAllowNullValues(csvOptions.getBoolean(CsvOptions.EMPTY_COLUMN_AS_NULL));
        outputFormat.setRecordDelimiter(csvOptions.getString(CsvOptions.OPTIONAL_LINE_DELIM));
        outputFormat.setFieldDelimiter(csvOptions.getString(CsvOptions.OPTIONAL_FIELD_DELIM));
        outputFormat.setQuoteCharacter(csvOptions.getString(CsvOptions.OPTIONAL_QUOTE_CHARACTER));
        outputFormat.setTimezone(TimeZone.getTimeZone(csvOptions.getString(CsvOptions.OPTIONAL_TIME_ZONE, FileSystemOptions$.MODULE$.TIME_ZONE().defaultValue())));
        outputFormat.setWriteMode(FileSystemOptions$.MODULE$.readWriteMode(csvOptions));
        boolean outputFieldNames = csvOptions.getBoolean(CsvOptions.OPTIONAL_FIRST_LINE_AS_HEADER);
        if (outputFieldNames) {
            outputFormat.setOutputFieldName(true);
            outputFormat.setFieldNames(dataSchema.getFieldNames());
        }
        outputFormat.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.NEVER);
        return outputFormat;
    }

    @Override
    public boolean supportDataSchema(DataType dataType2) {
        boolean bl;
        DataType dataType3 = dataType2;
        if (dataType3 instanceof AtomicType) {
            bl = true;
        } else if (dataType3 instanceof TypeInfoWrappedDataType) {
            TypeInfoWrappedDataType typeInfoWrappedDataType = (TypeInfoWrappedDataType)dataType3;
            bl = this.supportDataSchema(typeInfoWrappedDataType.toInternalType());
        } else {
            bl = false;
        }
        return bl;
    }

    public String toString() {
        return "CSV";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof CSVFormatFactory;
    }
}

