/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks.filesystem.orc;

import java.io.File;
import java.util.Map;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.factories.orc.ORCOptions;
import org.apache.flink.table.sinks.filesystem.FileSystemOptions$;
import org.apache.flink.table.sinks.filesystem.OutputFormatFactory;
import org.apache.flink.table.sinks.orc.RowOrcOutputFormat;
import org.apache.flink.table.types.AtomicType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.TypeInfoWrappedDataType;
import org.apache.flink.table.util.TableProperties;
import org.apache.hadoop.fs.FileUtil;
import org.apache.orc.CompressionKind;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001#\t\u0001rJ]2G_Jl\u0017\r\u001e$bGR|'/\u001f\u0006\u0003\u0007\u0011\t1a\u001c:d\u0015\t)a!\u0001\u0006gS2,7/_:uK6T!a\u0002\u0005\u0002\u000bMLgn[:\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Qi\u0011\u0001B\u0005\u0003+\u0011\u00111cT;uaV$hi\u001c:nCR4\u0015m\u0019;pefDQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"\u0001\u0002\t\u0013q\u0001\u0001\u0019!A!B\u0013i\u0012aB8qi&|gn\u001d\t\u0005=\r*S%D\u0001 \u0015\t\u0001\u0013%\u0001\u0003vi&d'\"\u0001\u0012\u0002\t)\fg/Y\u0005\u0003I}\u00111!T1q!\t1CF\u0004\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003&\u0001\u0004Qe\u0016$WMZ\u0005\u0003[9\u0012aa\u0015;sS:<'BA\u0016)\u0011\u0015\u0001\u0004\u0001\"\u00112\u0003%\u0019wN\u001c4jOV\u0014X\r\u0006\u00023kA\u0011qeM\u0005\u0003i!\u0012A!\u00168ji\")Ad\fa\u0001;!)q\u0007\u0001C!q\u0005\u0001r-\u001a;GS2,W\t\u001f;f]NLwN\u001c\u000b\u0003KeBQA\u000f\u001cA\u0002m\na\u0001^1tW&#\u0007CA\u0014=\u0013\ti\u0004FA\u0002J]RDQa\u0010\u0001\u0005B\u0001\u000b\u0011c];qa>\u0014H\u000fR1uCN\u001b\u0007.Z7b)\t\tE\t\u0005\u0002(\u0005&\u00111\t\u000b\u0002\b\u0005>|G.Z1o\u0011\u0015)e\b1\u0001G\u0003!!\u0017\r^1UsB,\u0007CA$K\u001b\u0005A%BA%\t\u0003\u0015!\u0018\u0010]3t\u0013\tY\u0005J\u0001\u0005ECR\fG+\u001f9f\u0011\u0015i\u0005\u0001\"\u0011O\u0003=qWm^(viB,HOR8s[\u0006$H\u0003B(`C\u001a\u00042\u0001U,Z\u001b\u0005\t&B\u0001*T\u0003\tIwN\u0003\u0002U+\u000611m\\7n_:T!A\u0016\u0006\u0002\u0007\u0005\u0004\u0018.\u0003\u0002Y#\naq*\u001e;qkR4uN]7biB\u0011!,X\u0007\u00027*\u0011A\fC\u0001\u000bI\u0006$\u0018MZ8s[\u0006$\u0018B\u00010\\\u0005\u001d\u0011\u0015m]3S_^DQ\u0001\u0019'A\u0002\u0015\nA\u0001]1uQ\")!\r\u0014a\u0001G\u0006QA-\u0019;b'\u000eDW-\\1\u0011\u0005\u001d#\u0017BA3I\u0005\u001d\u0011vn\u001e+za\u0016DQA\u000f'A\u0002mBQ\u0001\u001b\u0001\u0005B%\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002K\u0001")
public class OrcFormatFactory
extends OutputFormatFactory {
    private Map<String, String> options;

    @Override
    public void configure(Map<String, String> options) {
        this.options = options;
    }

    @Override
    public String getFileExtension(int taskId) {
        return ".orc";
    }

    @Override
    public boolean supportDataSchema(DataType dataType2) {
        boolean bl;
        DataType dataType3 = dataType2;
        if (dataType3 instanceof AtomicType) {
            bl = true;
        } else if (dataType3 instanceof TypeInfoWrappedDataType) {
            TypeInfoWrappedDataType typeInfoWrappedDataType = (TypeInfoWrappedDataType)dataType3;
            bl = this.supportDataSchema(typeInfoWrappedDataType.toInternalType());
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public OutputFormat<BaseRow> newOutputFormat(String path, RowType dataSchema, int taskId) {
        TableProperties orcOptions = new TableProperties().putProperties(this.options).toKeyLowerCase();
        FileSystem.WriteMode writeMode = FileSystemOptions$.MODULE$.readWriteMode(orcOptions);
        Object object = writeMode.equals((Object)FileSystem.WriteMode.OVERWRITE) ? BoxesRunTime.boxToBoolean((boolean)FileUtil.fullyDelete((File)new File(path))) : BoxedUnit.UNIT;
        Path p = new Path(path);
        if (p.getFileSystem().exists(p) && !p.getFileSystem().getFileStatus(p).isDir()) {
            throw new RuntimeException(new StringBuilder().append((Object)"output dir [").append((Object)path).append((Object)"] already existed.").toString());
        }
        CompressionKind compression = CompressionKind.valueOf((String)orcOptions.getString(ORCOptions.COMPRESSION_CODEC_NAME));
        return new RowOrcOutputFormat(dataSchema.getFieldInternalTypes(), dataSchema.getFieldNames(), path, compression);
    }

    public String toString() {
        return "ORC";
    }
}

