/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks.filesystem.parquet;

import java.io.File;
import java.util.Map;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.factories.parquet.ParquetOptions;
import org.apache.flink.table.sinks.filesystem.FileSystemOptions$;
import org.apache.flink.table.sinks.filesystem.OutputFormatFactory;
import org.apache.flink.table.sinks.parquet.RowParquetOutputFormat;
import org.apache.flink.table.types.AtomicType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.TypeInfoWrappedDataType;
import org.apache.flink.table.util.TableProperties;
import org.apache.hadoop.fs.FileUtil;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001#\t!\u0002+\u0019:rk\u0016$hi\u001c:nCR4\u0015m\u0019;pefT!a\u0001\u0003\u0002\u000fA\f'/];fi*\u0011QAB\u0001\u000bM&dWm]=ti\u0016l'BA\u0004\t\u0003\u0015\u0019\u0018N\\6t\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0003\n\u0005U!!aE(viB,HOR8s[\u0006$h)Y2u_JL\b\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\tQ\u0002!D\u0001\u0003\u0011%a\u0002\u00011A\u0001B\u0003&Q$A\u0004paRLwN\\:\u0011\ty\u0019S%J\u0007\u0002?)\u0011\u0001%I\u0001\u0005kRLGNC\u0001#\u0003\u0011Q\u0017M^1\n\u0005\u0011z\"aA'baB\u0011a\u0005\f\b\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006K\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,Q!)\u0001\u0007\u0001C!c\u0005I1m\u001c8gS\u001e,(/\u001a\u000b\u0003eU\u0002\"aJ\u001a\n\u0005QB#\u0001B+oSRDQ\u0001H\u0018A\u0002uAQa\u000e\u0001\u0005Ba\n\u0001cZ3u\r&dW-\u0012=uK:\u001c\u0018n\u001c8\u0015\u0005\u0015J\u0004\"\u0002\u001e7\u0001\u0004Y\u0014A\u0002;bg.LE\r\u0005\u0002(y%\u0011Q\b\u000b\u0002\u0004\u0013:$\b\"B \u0001\t\u0003\u0002\u0015!E:vaB|'\u000f\u001e#bi\u0006\u001c6\r[3nCR\u0011\u0011\t\u0012\t\u0003O\tK!a\u0011\u0015\u0003\u000f\t{w\u000e\\3b]\")QI\u0010a\u0001\r\u0006AA-\u0019;b)f\u0004X\r\u0005\u0002H\u00156\t\u0001J\u0003\u0002J\u0011\u0005)A/\u001f9fg&\u00111\n\u0013\u0002\t\t\u0006$\u0018\rV=qK\")Q\n\u0001C!\u001d\u0006ya.Z<PkR\u0004X\u000f\u001e$pe6\fG\u000f\u0006\u0003P?\u00064\u0007c\u0001)X36\t\u0011K\u0003\u0002S'\u0006\u0011\u0011n\u001c\u0006\u0003)V\u000baaY8n[>t'B\u0001,\u000b\u0003\r\t\u0007/[\u0005\u00031F\u0013AbT;uaV$hi\u001c:nCR\u0004\"AW/\u000e\u0003mS!\u0001\u0018\u0005\u0002\u0015\u0011\fG/\u00194pe6\fG/\u0003\u0002_7\n9!)Y:f%><\b\"\u00021M\u0001\u0004)\u0013\u0001\u00029bi\"DQA\u0019'A\u0002\r\f!\u0002Z1uCN\u001b\u0007.Z7b!\t9E-\u0003\u0002f\u0011\n9!k\\<UsB,\u0007\"\u0002\u001eM\u0001\u0004Y\u0004\"\u00025\u0001\t\u0003J\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\u0015\u0002")
public class ParquetFormatFactory
extends OutputFormatFactory {
    private Map<String, String> options;

    @Override
    public void configure(Map<String, String> options) {
        this.options = options;
    }

    @Override
    public String getFileExtension(int taskId) {
        return ".parquet";
    }

    @Override
    public boolean supportDataSchema(DataType dataType2) {
        boolean bl;
        DataType dataType3 = dataType2;
        if (dataType3 instanceof AtomicType) {
            bl = true;
        } else if (dataType3 instanceof TypeInfoWrappedDataType) {
            TypeInfoWrappedDataType typeInfoWrappedDataType = (TypeInfoWrappedDataType)dataType3;
            bl = this.supportDataSchema(typeInfoWrappedDataType.toInternalType());
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public OutputFormat<BaseRow> newOutputFormat(String path, RowType dataSchema, int taskId) {
        TableProperties parquetOptions = new TableProperties().putProperties(this.options).toKeyLowerCase();
        FileSystem.WriteMode writeMode = FileSystemOptions$.MODULE$.readWriteMode(parquetOptions);
        Object object = writeMode.equals((Object)FileSystem.WriteMode.OVERWRITE) ? BoxesRunTime.boxToBoolean((boolean)FileUtil.fullyDelete((File)new File(path))) : BoxedUnit.UNIT;
        Path p = new Path(path);
        if (p.getFileSystem().exists(p) && !p.getFileSystem().getFileStatus(p).isDir()) {
            throw new RuntimeException(new StringBuilder().append((Object)"output dir [").append((Object)path).append((Object)"] already existed.").toString());
        }
        int blockSize = parquetOptions.getInteger(ParquetOptions.BLOCK_SIZE);
        boolean enableDictionary = parquetOptions.getBoolean(ParquetOptions.DICTIONARY_ENABLED);
        CompressionCodecName compression = CompressionCodecName.valueOf((String)parquetOptions.getString(ParquetOptions.COMPRESSION_CODEC_NAME));
        return new RowParquetOutputFormat(path, dataSchema.getFieldInternalTypes(), dataSchema.getFieldNames(), compression, blockSize, enableDictionary, false);
    }

    public String toString() {
        return "PARQUET";
    }
}

