/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks.parquet;

import java.io.IOException;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.VirtualColumn;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.sinks.parquet.RowParquetOutputFormat;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.util.Preconditions;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class DeleteRowParquetOutputFormat
extends RowParquetOutputFormat {
    public static final String DELETE_DIR_SUFFIX = "_delete";
    private final int rowIdIndex = 0;
    private final int inputFileNameIndex = 1;
    private transient BinaryString lastInputFileName = null;
    private transient BinaryString currentInputFileName = null;
    private int taskNumber;
    private int numTasks;

    public DeleteRowParquetOutputFormat(String dir, InternalType[] fieldTypes2, String[] fieldNames, CompressionCodecName compression, int blockSize, boolean enableDictionary) {
        super(dir, new InternalType[]{VirtualColumn.ROWID.getInternalType()}, new String[]{VirtualColumn.ROWID.getName()}, compression, blockSize, enableDictionary, false);
        Preconditions.checkArgument(fieldNames.length == 2, "Delete outputFormat should receive only " + VirtualColumn.ROWID.getName() + " and " + VirtualColumn.FILENAME.getName());
        Preconditions.checkArgument(fieldNames[0].equals(VirtualColumn.ROWID.getName()), VirtualColumn.ROWID.getName() + " should be first.");
        Preconditions.checkArgument(fieldNames[1].equals(VirtualColumn.FILENAME.getName()), VirtualColumn.FILENAME.getName() + " should be second.");
    }

    @Override
    public void open(int taskNumber, int numTasks) throws IOException {
        this.taskNumber = taskNumber;
        this.numTasks = numTasks;
    }

    @Override
    public void writeRecord(BaseRow record) throws IOException {
        this.currentInputFileName = record.getBinaryString(1);
        if (this.lastInputFileName == null || this.currentInputFileName.compareTo(this.lastInputFileName) != 0) {
            this.lastInputFileName = this.currentInputFileName.copy();
            String writeFileName = "parquet-" + this.numTasks + "-" + this.taskNumber + ".parquet";
            Path inputPath = new Path(this.lastInputFileName.toString());
            Path path = new Path(inputPath.suffix(DELETE_DIR_SUFFIX).toString() + "/" + this.initTime, writeFileName);
            this.makeRealWriter(path);
        }
        try {
            this.realWriter.write(null, (Object)record);
        }
        catch (InterruptedException e2) {
            throw new IOException(e2);
        }
    }
}

