/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks.parquet;

import java.util.HashMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.sinks.parquet.RowWritableWriter;
import org.apache.flink.table.types.InternalType;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;

public class RowWritableWriteSupport
extends WriteSupport<BaseRow> {
    public static final String PARQUET_FLINK_SCHEMA = "parquet.flink.schema";
    private RowWritableWriter writer;
    private MessageType schema;
    private InternalType[] fieldTypes;
    private boolean supportUpdate;

    public RowWritableWriteSupport(InternalType[] fieldTypes2, boolean supportUpdate) {
        this.fieldTypes = fieldTypes2;
        this.supportUpdate = supportUpdate;
    }

    public static void setSchema(MessageType schema2, Configuration configuration) {
        configuration.set(PARQUET_FLINK_SCHEMA, schema2.toString());
    }

    public static MessageType getSchema(Configuration configuration) {
        return MessageTypeParser.parseMessageType((String)configuration.get(PARQUET_FLINK_SCHEMA));
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        this.schema = RowWritableWriteSupport.getSchema(configuration);
        return new WriteSupport.WriteContext(this.schema, new HashMap());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.writer = new RowWritableWriter(this.fieldTypes, recordConsumer, (GroupType)this.schema, this.supportUpdate);
    }

    public void write(BaseRow record) {
        this.writer.write(record);
    }
}

