/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks.parquet;

import java.util.Arrays;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.sources.parquet.ParquetSchemaConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.util.Preconditions;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowWritableWriter {
    private static final Logger LOG = LoggerFactory.getLogger(RowWritableWriter.class);
    protected final RecordConsumer recordConsumer;
    private final GroupType schema;
    private RowWriter messageWriter;
    private InternalType[] fieldTypes;
    private boolean supportUpdate;

    public RowWritableWriter(InternalType[] fieldTypes2, RecordConsumer recordConsumer, GroupType schema2, boolean supportUpdate) {
        this.recordConsumer = recordConsumer;
        this.schema = schema2;
        this.fieldTypes = fieldTypes2;
        this.supportUpdate = supportUpdate;
    }

    public void write(BaseRow record) {
        if (record != null) {
            if (this.messageWriter == null) {
                try {
                    this.messageWriter = this.createMessageWriter(new RowType((DataType[])this.fieldTypes), this.schema);
                }
                catch (RuntimeException e2) {
                    String errorMessage = "Parquet record is malformed: " + e2.getMessage();
                    LOG.error(errorMessage, (Throwable)e2);
                    throw new RuntimeException(errorMessage, e2);
                }
            }
            this.messageWriter.write(record);
        }
    }

    private MessageRowWriter createMessageWriter(RowType rowTypeInfo, GroupType schema2) {
        return new MessageRowWriter(rowTypeInfo, schema2);
    }

    private FieldWriter createWriter(InternalType t, Type type) {
        if (type.isPrimitive()) {
            if (DataTypes.INT.equals(t)) {
                return new IntegerWriter();
            }
            if (DataTypes.SHORT.equals(t)) {
                return new ShortWriter();
            }
            if (DataTypes.BOOLEAN.equals(t)) {
                return new BooleanWriter();
            }
            if (DataTypes.DOUBLE.equals(t)) {
                return new DoubleWriter();
            }
            if (DataTypes.FLOAT.equals(t)) {
                return new FloatWriter();
            }
            if (DataTypes.LONG.equals(t)) {
                return new LongWriter();
            }
            if (DataTypes.STRING.equals(t)) {
                return new StringWriter();
            }
            if (DataTypes.BYTE.equals(t)) {
                return new ByteWriter();
            }
            if (DataTypes.TIMESTAMP.equals(t)) {
                return new TimestampWriter();
            }
            if (DataTypes.DATE.equals(t)) {
                return new DateWriter();
            }
            if (DataTypes.TIME.equals(t)) {
                return new TimeWriter();
            }
            if (t instanceof DecimalType) {
                DecimalType decimalTypeInfo = (DecimalType)t;
                return this.makeDecimalWriter(decimalTypeInfo.precision(), decimalTypeInfo.scale());
            }
            throw new IllegalArgumentException("Unsupported  data type: " + t);
        }
        throw new IllegalArgumentException("Unsupported  data type: " + t);
    }

    private FieldWriter makeDecimalWriter(final int precision, final int scale) {
        Preconditions.checkArgument(precision <= 38, "Decimal precision %s exceeds max precision %s", precision, 38);
        if (Decimal.is32BitDecimal(precision)) {
            class Int32Writer
            implements FieldWriter {
                Int32Writer() {
                }

                @Override
                public void write(BaseRow row2, int ordinal) {
                    long unscaledLong = row2.getDecimal(ordinal, precision, scale).toUnscaledLong();
                    RowWritableWriter.this.recordConsumer.addInteger((int)unscaledLong);
                }
            }
            return new Int32Writer();
        }
        if (Decimal.is64BitDecimal(precision)) {
            class Int64Writer
            implements FieldWriter {
                Int64Writer() {
                }

                @Override
                public void write(BaseRow row2, int ordinal) {
                    long unscaledLong = row2.getDecimal(ordinal, precision, scale).toUnscaledLong();
                    RowWritableWriter.this.recordConsumer.addLong(unscaledLong);
                }
            }
            return new Int64Writer();
        }
        class UnscaledBytesWriter
        implements FieldWriter {
            private final byte[] decimalBuffer;

            UnscaledBytesWriter() {
                int maxNumBytes = ParquetSchemaConverter.computeMinBytesForPrecision(38);
                this.decimalBuffer = new byte[maxNumBytes];
            }

            @Override
            public void write(BaseRow row2, int ordinal) {
                byte[] fixedLengthBytes;
                int numBytes;
                byte[] bytes = row2.getDecimal(ordinal, precision, scale).toUnscaledBytes();
                if (bytes.length == (numBytes = ParquetSchemaConverter.computeMinBytesForPrecision(precision))) {
                    fixedLengthBytes = bytes;
                } else {
                    byte signByte = bytes[0] < 0 ? (byte)-1 : 0;
                    Arrays.fill(this.decimalBuffer, 0, numBytes - bytes.length, signByte);
                    System.arraycopy(bytes, 0, this.decimalBuffer, numBytes - bytes.length, bytes.length);
                    fixedLengthBytes = this.decimalBuffer;
                }
                RowWritableWriter.this.recordConsumer.addBinary(Binary.fromReusedByteArray((byte[])fixedLengthBytes, (int)0, (int)numBytes));
            }
        }
        return new UnscaledBytesWriter();
    }

    private class DateWriter
    implements FieldWriter {
        private DateWriter() {
        }

        @Override
        public void write(BaseRow row2, int ordinal) {
            RowWritableWriter.this.recordConsumer.addInteger(row2.getInt(ordinal));
        }
    }

    private class TimeWriter
    implements FieldWriter {
        private TimeWriter() {
        }

        @Override
        public void write(BaseRow row2, int ordinal) {
            RowWritableWriter.this.recordConsumer.addInteger(row2.getInt(ordinal));
        }
    }

    private class TimestampWriter
    implements FieldWriter {
        private TimestampWriter() {
        }

        @Override
        public void write(BaseRow row2, int ordinal) {
            RowWritableWriter.this.recordConsumer.addLong(row2.getLong(ordinal));
        }
    }

    private class IntegerWriter
    implements FieldWriter {
        private IntegerWriter() {
        }

        @Override
        public void write(BaseRow row2, int ordinal) {
            RowWritableWriter.this.recordConsumer.addInteger(row2.getInt(ordinal));
        }
    }

    private class StringWriter
    implements FieldWriter {
        private StringWriter() {
        }

        @Override
        public void write(BaseRow row2, int ordinal) {
            RowWritableWriter.this.recordConsumer.addBinary(Binary.fromReusedByteArray((byte[])row2.getBinaryString(ordinal).getBytes()));
        }
    }

    private class DoubleWriter
    implements FieldWriter {
        private DoubleWriter() {
        }

        @Override
        public void write(BaseRow row2, int ordinal) {
            RowWritableWriter.this.recordConsumer.addDouble(row2.getDouble(ordinal));
        }
    }

    private class FloatWriter
    implements FieldWriter {
        private FloatWriter() {
        }

        @Override
        public void write(BaseRow row2, int ordinal) {
            RowWritableWriter.this.recordConsumer.addFloat(row2.getFloat(ordinal));
        }
    }

    private class LongWriter
    implements FieldWriter {
        private LongWriter() {
        }

        @Override
        public void write(BaseRow row2, int ordinal) {
            RowWritableWriter.this.recordConsumer.addLong(row2.getLong(ordinal));
        }
    }

    private class ShortWriter
    implements FieldWriter {
        private ShortWriter() {
        }

        @Override
        public void write(BaseRow row2, int ordinal) {
            RowWritableWriter.this.recordConsumer.addInteger((int)row2.getShort(ordinal));
        }
    }

    private class ByteWriter
    implements FieldWriter {
        private ByteWriter() {
        }

        @Override
        public void write(BaseRow row2, int ordinal) {
            RowWritableWriter.this.recordConsumer.addInteger((int)row2.getByte(ordinal));
        }
    }

    private class BooleanWriter
    implements FieldWriter {
        private BooleanWriter() {
        }

        @Override
        public void write(BaseRow row2, int ordinal) {
            RowWritableWriter.this.recordConsumer.addBoolean(row2.getBoolean(ordinal));
        }
    }

    private class MessageRowWriter
    extends GroupRowWriter
    implements RowWriter {
        public MessageRowWriter(RowType rowTypeInfo, GroupType groupType) {
            super(rowTypeInfo, groupType);
        }

        @Override
        public void write(BaseRow row2) {
            RowWritableWriter.this.recordConsumer.startMessage();
            if (row2 != null) {
                super.write(row2);
            }
            RowWritableWriter.this.recordConsumer.endMessage();
        }
    }

    private class GroupRowWriter
    implements RowWriter {
        private RowType rowTypeInfo;
        private FieldWriter[] writers;
        private String[] fieldNames;
        private int rowId = 0;

        public GroupRowWriter(RowType rowTypeInfo, GroupType groupType) {
            this.rowTypeInfo = rowTypeInfo;
            this.writers = new FieldWriter[rowTypeInfo.getFieldTypes().length];
            this.fieldNames = rowTypeInfo.getFieldNames();
            for (int i = 0; i < this.rowTypeInfo.getFieldTypes().length; ++i) {
                this.writers[i] = RowWritableWriter.this.createWriter(rowTypeInfo.getInternalTypeAt(i), groupType.getType(i));
            }
        }

        @Override
        public void write(BaseRow row2) {
            int endPos = this.writers.length;
            if (RowWritableWriter.this.supportUpdate) {
                endPos = this.writers.length - 1;
            }
            for (int i = 0; i < endPos; ++i) {
                if (row2.isNullAt(i)) continue;
                String fieldName = this.fieldNames[i];
                FieldWriter writer = this.writers[i];
                RowWritableWriter.this.recordConsumer.startField(fieldName, i);
                writer.write(row2, i);
                RowWritableWriter.this.recordConsumer.endField(fieldName, i);
            }
            if (RowWritableWriter.this.supportUpdate) {
                RowWritableWriter.this.recordConsumer.startField(this.fieldNames[endPos], endPos);
                RowWritableWriter.this.recordConsumer.addInteger(this.rowId++);
                if (this.rowId >= Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("Row number of a single file should be < 2147483647");
                }
                RowWritableWriter.this.recordConsumer.endField(this.fieldNames[endPos], endPos);
            }
        }
    }

    private static interface FieldWriter {
        public void write(BaseRow var1, int var2);
    }

    private static interface RowWriter {
        public void write(BaseRow var1);
    }
}

