/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources;

import java.io.IOException;
import org.apache.flink.api.common.io.GenericInputFormat;
import org.apache.flink.api.common.io.NonParallelInput;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BoxedWrapperRow;

public class RangeInputFormat
extends GenericInputFormat<BaseRow>
implements NonParallelInput {
    private static final long serialVersionUID = 1L;
    private long start;
    private long end;
    private transient long current;
    private transient BoxedWrapperRow reuse;

    public RangeInputFormat(long start, long end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean reachedEnd() throws IOException {
        return this.current >= this.end;
    }

    @Override
    public void open(GenericInputSplit split) throws IOException {
        super.open(split);
        this.current = this.start;
    }

    @Override
    public BaseRow nextRecord(BaseRow ignore) throws IOException {
        if (this.reuse == null) {
            this.reuse = new BoxedWrapperRow(1);
        }
        this.reuse.setLong(0, this.current);
        ++this.current;
        return this.reuse;
    }
}

