/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.expressions.Cast;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ResolvedFieldReference;
import org.apache.flink.table.sources.DefinedFieldMapping;
import org.apache.flink.table.sources.DefinedProctimeAttribute;
import org.apache.flink.table.sources.DefinedRowtimeAttributes;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.tsextractors.TimestampExtractor;
import org.apache.flink.table.types.ByteType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.TimestampType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class TableSourceUtil$ {
    public static final TableSourceUtil$ MODULE$;

    static {
        new TableSourceUtil$();
    }

    public boolean hasRowtimeAttribute(TableSource tableSource) {
        return Predef$.MODULE$.refArrayOps((Object[])this.org$apache$flink$table$sources$TableSourceUtil$$getRowtimeAttributes(tableSource)).nonEmpty();
    }

    public boolean hasProctimeAttribute(TableSource tableSource) {
        return this.org$apache$flink$table$sources$TableSourceUtil$$getProctimeAttribute(tableSource).nonEmpty();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateTableSource(TableSource tableSource) {
        TableSource tableSource2;
        TableSchema schema2 = tableSource.getTableSchema();
        String[] tableFieldNames = schema2.getColumnNames();
        InternalType[] tableFieldTypes = schema2.getTypes();
        String[] rowtimeAttributes = this.org$apache$flink$table$sources$TableSourceUtil$$getRowtimeAttributes(tableSource);
        Option<String> proctimeAttribute = this.org$apache$flink$table$sources$TableSourceUtil$$getProctimeAttribute(tableSource);
        IntRef mappedFieldCnt = IntRef.create((int)0);
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])tableFieldTypes).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])tableFieldNames), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(tableSource, rowtimeAttributes, proctimeAttribute, mappedFieldCnt){
            public static final long serialVersionUID = 0L;
            private final TableSource tableSource$3;
            private final String[] rowtimeAttributes$1;
            private final Option proctimeAttribute$1;
            private final IntRef mappedFieldCnt$1;

            /*
             * WARNING - void declaration
             */
            public final void apply(Tuple2<InternalType, String> x0$1) {
                Tuple2<InternalType, String> tuple2;
                block8: {
                    Tuple3<String, Object, InternalType> tuple3;
                    block9: {
                        void var20_22;
                        void var21_23;
                        InternalType internalType;
                        String name;
                        block10: {
                            block6: {
                                InternalType tpe;
                                Tuple2 tuple22;
                                block7: {
                                    block5: {
                                        String string;
                                        tuple2 = x0$1;
                                        if (tuple2 == null) break block5;
                                        InternalType internalType2 = (InternalType)tuple2._1();
                                        String name2 = (String)tuple2._2();
                                        TimestampType timestampType = DataTypes.TIMESTAMP;
                                        InternalType internalType3 = internalType2;
                                        if (timestampType != null ? !((Object)timestampType).equals(internalType3) : internalType3 != null) break block5;
                                        if (name2 == null || !this.proctimeAttribute$1.contains((Object)(string = name2))) break block5;
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block6;
                                    }
                                    if (tuple2 == null) break block7;
                                    InternalType internalType4 = (InternalType)tuple2._1();
                                    String name3 = (String)tuple2._2();
                                    TimestampType timestampType = DataTypes.TIMESTAMP;
                                    InternalType internalType5 = internalType4;
                                    if ((timestampType != null ? !((Object)timestampType).equals(internalType5) : internalType5 != null) || name3 == null) break block7;
                                    String string = name3;
                                    if (!Predef$.MODULE$.refArrayOps((Object[])this.rowtimeAttributes$1).contains((Object)string)) break block7;
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block6;
                                }
                                if (tuple2 == null) break block8;
                                InternalType t = (InternalType)tuple2._1();
                                name = (String)tuple2._2();
                                if (t == null) break block8;
                                internalType = t;
                                if (TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$getProctimeAttribute(this.tableSource$3).contains((Object)name)) {
                                    throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing time field '", "' has invalid type ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, internalType}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing time attributes must be of type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataTypes.TIMESTAMP}))).toString());
                                }
                                if (Predef$.MODULE$.refArrayOps((Object[])TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$getRowtimeAttributes(this.tableSource$3)).contains((Object)name)) {
                                    throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rowtime field '", "' has invalid type ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, internalType}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rowtime attributes must be of type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataTypes.TIMESTAMP}))).toString());
                                }
                                tuple3 = TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$resolveInputField(name, this.tableSource$3);
                                if (tuple3 == null) break block9;
                                String physicalName = (String)tuple3._1();
                                InternalType tpe2 = (InternalType)tuple3._3();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)physicalName, (Object)tpe2);
                                String physicalName2 = (String)tuple23._1();
                                InternalType internalType6 = tpe = (InternalType)tuple23._2();
                                InternalType internalType7 = internalType;
                                if (internalType6 != null ? !internalType6.equals(internalType7) : internalType7 != null) break block10;
                                ++this.mappedFieldCnt$1.elem;
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Type ", " of table field '", "' does not "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{internalType, name}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"match with type ", " of the field '", "' of the TableSource return type."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var21_23, var20_22}))).toString());
                    }
                    throw new MatchError(tuple3);
                }
                throw new MatchError(tuple2);
            }
            {
                this.tableSource$3 = tableSource$3;
                this.rowtimeAttributes$1 = rowtimeAttributes$1;
                this.proctimeAttribute$1 = proctimeAttribute$1;
                this.mappedFieldCnt$1 = mappedFieldCnt$1;
            }
        });
        if (!(tableSource.getReturnType().toInternalType() instanceof RowType) && mappedFieldCnt.elem > 1) {
            throw new ValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"More than one table field matched to atomic input type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableSource.getReturnType()})));
        }
        TableSource tableSource3 = tableSource;
        if (tableSource3 instanceof DefinedRowtimeAttributes) {
            BoxedUnit boxedUnit;
            TableSource tableSource4 = tableSource3;
            List<RowtimeAttributeDescriptor> descriptors = ((DefinedRowtimeAttributes)((Object)tableSource4)).getRowtimeAttributeDescriptors();
            if (descriptors.size() > 1) {
                throw new ValidationException(new StringBuilder().append((Object)"Currently, only a single rowtime attribute is supported. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please remove all but one RowtimeAttributeDescriptor."})).s((Seq)Nil$.MODULE$)).toString());
            }
            if (descriptors.size() == 1) {
                RowtimeAttributeDescriptor descriptor = descriptors.get(0);
                String rowtimeAttribute = descriptor.getAttributeName();
                int rowtimeIdx = Predef$.MODULE$.refArrayOps((Object[])schema2.getColumnNames()).indexOf((Object)rowtimeAttribute);
                if (rowtimeIdx < 0) {
                    throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found a RowtimeAttributeDescriptor for field "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' but field '", "' does not exist in table."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowtimeAttribute, rowtimeAttribute}))).toString());
                }
                InternalType internalType = schema2.getFieldType(rowtimeIdx).get();
                TimestampType timestampType = DataTypes.TIMESTAMP;
                if (internalType != null ? !internalType.equals(timestampType) : timestampType != null) void var12_12;
                throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found a RowtimeAttributeDescriptor for field "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' but field '", "' is not of type TIMESTAMP."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var12_12, var12_12}))).toString());
                String[] extractorInputFields = descriptor.getTimestampExtractor().getArgumentFields();
                InternalType[] physicalTypes = (InternalType[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$flink$table$sources$TableSourceUtil$$resolveInputFields(extractorInputFields, tableSource)).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final InternalType apply(Tuple3<String, Object, InternalType> x$2) {
                        return (InternalType)x$2._3();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalType.class)));
                descriptor.getTimestampExtractor().validateArgumentFields(physicalTypes);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        TableSource tableSource5 = tableSource;
        if (tableSource5 instanceof DefinedProctimeAttribute && ((DefinedProctimeAttribute)((Object)(tableSource2 = tableSource5))).getProctimeAttribute() != null) {
            String proctimeAttribute2 = ((DefinedProctimeAttribute)((Object)tableSource2)).getProctimeAttribute();
            int proctimeIdx = Predef$.MODULE$.refArrayOps((Object[])schema2.getColumnNames()).indexOf((Object)proctimeAttribute2);
            if (proctimeIdx < 0) {
                throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found a ProctimeAttribute for field "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' but field '", "' does not exist in table."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{proctimeAttribute2, proctimeAttribute2}))).toString());
            }
            InternalType internalType = schema2.getFieldType(proctimeIdx).get();
            TimestampType timestampType = DataTypes.TIMESTAMP;
            if (internalType != null ? !internalType.equals(timestampType) : timestampType != null) throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found a ProctimeAttribute for field "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' but field '", "' is not of type TIMESTAMP."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{proctimeAttribute2, proctimeAttribute2}))).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (!proctimeAttribute.isDefined() || !Predef$.MODULE$.refArrayOps((Object[])rowtimeAttributes).contains(proctimeAttribute.get())) return;
        throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Field '", "' must not be "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{proctimeAttribute.get()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"processing time and rowtime attribute at the same time."})).s((Seq)Nil$.MODULE$)).toString());
    }

    public int[] computeIndexMapping(TableSource tableSource, boolean isStreamTable, Option<int[]> selectedFields) {
        InternalType[] internalTypeArray;
        String[] tableFieldNames;
        String[] stringArray;
        InternalType inputType = tableSource.getReturnType().toInternalType();
        TableSchema tableSchema2 = tableSource.getTableSchema();
        if (selectedFields.isDefined()) {
            String[] names = tableSchema2.getColumnNames();
            stringArray = (String[])Predef$.MODULE$.intArrayOps((int[])selectedFields.get()).map((Function1)new Serializable(names){
                public static final long serialVersionUID = 0L;
                private final String[] names$1;

                public final String apply(int x$3) {
                    return this.names$1[x$3];
                }
                {
                    this.names$1 = names$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        } else {
            stringArray = tableFieldNames = tableSchema2.getColumnNames();
        }
        if (selectedFields.isDefined()) {
            InternalType[] types = tableSchema2.getTypes();
            internalTypeArray = (InternalType[])Predef$.MODULE$.intArrayOps((int[])selectedFields.get()).map((Function1)new Serializable(types){
                public static final long serialVersionUID = 0L;
                private final InternalType[] types$1;

                public final InternalType apply(int x$4) {
                    return this.types$1[x$4];
                }
                {
                    this.types$1 = types$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalType.class)));
        } else {
            internalTypeArray = tableSchema2.getTypes();
        }
        InternalType[] tableFieldTypes = internalTypeArray;
        String[] rowtimeAttributes = this.org$apache$flink$table$sources$TableSourceUtil$$getRowtimeAttributes(tableSource);
        Option<String> proctimeAttributes = this.org$apache$flink$table$sources$TableSourceUtil$$getProctimeAttribute(tableSource);
        int[] mapping = (int[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])tableFieldTypes).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])tableFieldNames), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(tableSource, isStreamTable, rowtimeAttributes, proctimeAttributes){
            public static final long serialVersionUID = 0L;
            private final TableSource tableSource$1;
            private final boolean isStreamTable$1;
            private final String[] rowtimeAttributes$2;
            private final Option proctimeAttributes$1;

            /*
             * WARNING - void declaration
             */
            public final int apply(Tuple2<InternalType, String> x0$2) {
                Tuple2<InternalType, String> tuple2;
                block8: {
                    Tuple3<String, Object, InternalType> tuple3;
                    block9: {
                        void var21_21;
                        void var23_23;
                        InternalType internalType;
                        String name;
                        block10: {
                            int n;
                            block6: {
                                InternalType tpe;
                                Tuple3 tuple32;
                                block7: {
                                    block5: {
                                        String string;
                                        tuple2 = x0$2;
                                        if (tuple2 == null) break block5;
                                        InternalType internalType2 = (InternalType)tuple2._1();
                                        String name2 = (String)tuple2._2();
                                        TimestampType timestampType = DataTypes.TIMESTAMP;
                                        InternalType internalType3 = internalType2;
                                        if (timestampType != null ? !((Object)timestampType).equals(internalType3) : internalType3 != null) break block5;
                                        if (name2 == null || !this.proctimeAttributes$1.contains((Object)(string = name2))) break block5;
                                        n = this.isStreamTable$1 ? -2 : -4;
                                        break block6;
                                    }
                                    if (tuple2 == null) break block7;
                                    InternalType internalType4 = (InternalType)tuple2._1();
                                    String name3 = (String)tuple2._2();
                                    TimestampType timestampType = DataTypes.TIMESTAMP;
                                    InternalType internalType5 = internalType4;
                                    if ((timestampType != null ? !((Object)timestampType).equals(internalType5) : internalType5 != null) || name3 == null) break block7;
                                    String string = name3;
                                    if (!Predef$.MODULE$.refArrayOps((Object[])this.rowtimeAttributes$2).contains((Object)string)) break block7;
                                    n = this.isStreamTable$1 ? -1 : -3;
                                    break block6;
                                }
                                if (tuple2 == null) break block8;
                                InternalType t = (InternalType)tuple2._1();
                                name = (String)tuple2._2();
                                if (t == null) break block8;
                                internalType = t;
                                if (TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$getProctimeAttribute(this.tableSource$1).contains((Object)name)) {
                                    throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing time field '", "' has invalid type ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, internalType}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing time attributes must be of type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataTypes.TIMESTAMP}))).toString());
                                }
                                if (Predef$.MODULE$.refArrayOps((Object[])TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$getRowtimeAttributes(this.tableSource$1)).contains((Object)name)) {
                                    throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rowtime field '", "' has invalid type ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, internalType}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rowtime attributes must be of type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataTypes.TIMESTAMP}))).toString());
                                }
                                tuple3 = TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$resolveInputField(name, this.tableSource$1);
                                if (tuple3 == null) break block9;
                                String physicalName = (String)tuple3._1();
                                int idx = BoxesRunTime.unboxToInt((Object)tuple3._2());
                                InternalType tpe2 = (InternalType)tuple3._3();
                                Tuple3 tuple33 = tuple32 = new Tuple3((Object)physicalName, (Object)BoxesRunTime.boxToInteger((int)idx), (Object)tpe2);
                                String physicalName2 = (String)tuple33._1();
                                int idx2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
                                InternalType internalType6 = tpe = (InternalType)tuple33._3();
                                InternalType internalType7 = internalType;
                                if (internalType6 != null ? !internalType6.equals(internalType7) : internalType7 != null) break block10;
                                n = idx2;
                            }
                            return n;
                        }
                        throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Type ", " of table field '", "' does not "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{internalType, name}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"match with type ", " of the field '", "' of the TableSource return type."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var23_23, var21_21}))).toString());
                    }
                    throw new MatchError(tuple3);
                }
                throw new MatchError(tuple2);
            }
            {
                this.tableSource$1 = tableSource$1;
                this.isStreamTable$1 = isStreamTable$1;
                this.rowtimeAttributes$2 = rowtimeAttributes$2;
                this.proctimeAttributes$1 = proctimeAttributes$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        if (!(inputType instanceof RowType) && Predef$.MODULE$.intArrayOps(mapping).count((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$6) {
                return this.apply$mcZI$sp(x$6);
            }

            public boolean apply$mcZI$sp(int x$6) {
                return x$6 >= 0;
            }
        }) > 1) {
            throw new ValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"More than one table field matched to atomic input type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputType})));
        }
        return mapping;
    }

    public RelDataType getRelDataType(TableSource tableSource, Option<int[]> selectedFields, boolean streaming, FlinkTypeFactory typeFactory) {
        Tuple3 tuple3;
        String[] fieldNames = tableSource.getTableSchema().getFieldNames();
        ObjectRef fieldTypes2 = ObjectRef.create((Object)tableSource.getTableSchema().getFieldTypes());
        ObjectRef fieldNullables = ObjectRef.create((Object)tableSource.getTableSchema().getFieldNullables());
        if (streaming) {
            String[] rowtimeAttributes = this.org$apache$flink$table$sources$TableSourceUtil$$getRowtimeAttributes(tableSource);
            Option<String> proctimeAttributes = this.org$apache$flink$table$sources$TableSourceUtil$$getProctimeAttribute(tableSource);
            Predef$.MODULE$.refArrayOps((Object[])rowtimeAttributes).foreach((Function1)new Serializable(fieldNames, fieldTypes2){
                public static final long serialVersionUID = 0L;
                private final String[] fieldNames$1;
                private final ObjectRef fieldTypes$1;

                public final void apply(String rowtimeField) {
                    int idx = Predef$.MODULE$.refArrayOps((Object[])this.fieldNames$1).indexOf((Object)rowtimeField);
                    this.fieldTypes$1.elem = (InternalType[])Predef$.MODULE$.refArrayOps((Object[])((InternalType[])this.fieldTypes$1.elem)).patch(idx, (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimestampType[]{DataTypes.ROWTIME_INDICATOR})), 1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalType.class)));
                }
                {
                    this.fieldNames$1 = fieldNames$1;
                    this.fieldTypes$1 = fieldTypes$1;
                }
            });
            proctimeAttributes.foreach((Function1)new Serializable(fieldNames, fieldTypes2){
                public static final long serialVersionUID = 0L;
                private final String[] fieldNames$1;
                private final ObjectRef fieldTypes$1;

                public final void apply(String proctimeField) {
                    int idx = Predef$.MODULE$.refArrayOps((Object[])this.fieldNames$1).indexOf((Object)proctimeField);
                    this.fieldTypes$1.elem = (InternalType[])Predef$.MODULE$.refArrayOps((Object[])((InternalType[])this.fieldTypes$1.elem)).patch(idx, (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimestampType[]{DataTypes.PROCTIME_INDICATOR})), 1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalType.class)));
                }
                {
                    this.fieldNames$1 = fieldNames$1;
                    this.fieldTypes$1 = fieldTypes$1;
                }
            });
        }
        Tuple3 tuple32 = tuple3 = selectedFields.isDefined() ? new Tuple3(Predef$.MODULE$.intArrayOps((int[])selectedFields.get()).map((Function1)new Serializable(fieldNames){
            public static final long serialVersionUID = 0L;
            private final String[] fieldNames$1;

            public final String apply(int x$7) {
                return this.fieldNames$1[x$7];
            }
            {
                this.fieldNames$1 = fieldNames$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), Predef$.MODULE$.intArrayOps((int[])selectedFields.get()).map((Function1)new Serializable(fieldTypes2){
            public static final long serialVersionUID = 0L;
            private final ObjectRef fieldTypes$1;

            public final InternalType apply(int x$8) {
                return ((InternalType[])this.fieldTypes$1.elem)[x$8];
            }
            {
                this.fieldTypes$1 = fieldTypes$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalType.class))), Predef$.MODULE$.intArrayOps((int[])selectedFields.get()).map((Function1)new Serializable(fieldNullables){
            public static final long serialVersionUID = 0L;
            private final ObjectRef fieldNullables$1;

            public final boolean apply(int x$9) {
                return this.apply$mcZI$sp(x$9);
            }

            public boolean apply$mcZI$sp(int x$9) {
                return ((boolean[])this.fieldNullables$1.elem)[x$9];
            }
            {
                this.fieldNullables$1 = fieldNullables$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()))) : new Tuple3((Object)fieldNames, (Object)((InternalType[])fieldTypes2.elem), (Object)((boolean[])fieldNullables.elem));
        if (tuple3 != null) {
            Tuple3 tuple33;
            String[] selectedFieldNames = (String[])tuple3._1();
            InternalType[] selectedFieldTypes = (InternalType[])tuple3._2();
            boolean[] selectedFieldNullables = (boolean[])tuple3._3();
            Tuple3 tuple34 = tuple33 = new Tuple3((Object)selectedFieldNames, (Object)selectedFieldTypes, (Object)selectedFieldNullables);
            String[] selectedFieldNames2 = (String[])tuple34._1();
            InternalType[] selectedFieldTypes2 = (InternalType[])tuple34._2();
            boolean[] selectedFieldNullables2 = (boolean[])tuple34._3();
            return typeFactory.buildRelDataType((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])selectedFieldNames2), (Seq<InternalType>)Predef$.MODULE$.wrapRefArray((Object[])selectedFieldTypes2), (Seq<Object>)Predef$.MODULE$.wrapBooleanArray(selectedFieldNullables2));
        }
        throw new MatchError((Object)tuple3);
    }

    public Option<RowtimeAttributeDescriptor> getRowtimeAttributeDescriptor(TableSource tableSource, Option<int[]> selectedFields) {
        None$ none$;
        TableSource tableSource2 = tableSource;
        if (tableSource2 instanceof DefinedRowtimeAttributes) {
            Object object;
            TableSource tableSource3 = tableSource2;
            List<RowtimeAttributeDescriptor> descriptors = ((DefinedRowtimeAttributes)((Object)tableSource3)).getRowtimeAttributeDescriptors();
            if (descriptors.size() == 0) {
                object = None$.MODULE$;
            } else {
                if (descriptors.size() > 1) {
                    throw new ValidationException("Table with has more than a single rowtime attribute..");
                }
                if (selectedFields.isEmpty()) {
                    object = new Some((Object)descriptors.get(0));
                } else {
                    RowtimeAttributeDescriptor descriptor = descriptors.get(0);
                    int fieldIdx = Predef$.MODULE$.refArrayOps((Object[])tableSource.getTableSchema().getColumnNames()).indexOf((Object)descriptor.getAttributeName());
                    object = Predef$.MODULE$.intArrayOps((int[])selectedFields.get()).contains((Object)BoxesRunTime.boxToInteger((int)fieldIdx)) ? new Some((Object)descriptor) : None$.MODULE$;
                }
            }
            none$ = object;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<RexNode> getRowtimeExtractionExpression(TableSource tableSource, Option<int[]> selectedFields, RelOptCluster cluster, RelBuilder relBuilder, InternalType resultType2) {
        FlinkTypeFactory typeFactory = (FlinkTypeFactory)cluster.getTypeFactory();
        Option<RowtimeAttributeDescriptor> rowtimeDesc = this.getRowtimeAttributeDescriptor(tableSource, selectedFields);
        return rowtimeDesc.map((Function1)new Serializable(tableSource, cluster, relBuilder, resultType2, typeFactory){
            public static final long serialVersionUID = 0L;
            private final TableSource tableSource$2;
            private final RelOptCluster cluster$1;
            private final RelBuilder relBuilder$1;
            private final InternalType resultType$1;
            private final FlinkTypeFactory typeFactory$1;

            public final RexNode apply(RowtimeAttributeDescriptor r) {
                ResolvedFieldReference[] resolvedFieldReferenceArray;
                TimestampExtractor tsExtractor = r.getTimestampExtractor();
                if (Predef$.MODULE$.refArrayOps((Object[])tsExtractor.getArgumentFields()).nonEmpty()) {
                    Tuple3<String, Object, InternalType>[] resolvedFields = TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$resolveInputFields(tsExtractor.getArgumentFields(), this.tableSource$2);
                    this.relBuilder$1.push(TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$createSchemaRelNode$1(resolvedFields, this.cluster$1, this.typeFactory$1));
                    resolvedFieldReferenceArray = (ResolvedFieldReference[])Predef$.MODULE$.refArrayOps((Object[])resolvedFields).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ResolvedFieldReference apply(Tuple3<String, Object, InternalType> f) {
                            return new ResolvedFieldReference((String)f._1(), (InternalType)f._3());
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ResolvedFieldReference.class)));
                } else {
                    resolvedFieldReferenceArray = new ResolvedFieldReference[]{};
                }
                ResolvedFieldReference[] fieldAccesses = resolvedFieldReferenceArray;
                Expression expression2 = tsExtractor.getExpression(fieldAccesses);
                RexNode rexExpression = new Cast(expression2, this.resultType$1).toRexNode(this.relBuilder$1);
                this.relBuilder$1.clear();
                return rexExpression;
            }
            {
                this.tableSource$2 = tableSource$2;
                this.cluster$1 = cluster$1;
                this.relBuilder$1 = relBuilder$1;
                this.resultType$1 = resultType$1;
                this.typeFactory$1 = typeFactory$1;
            }
        });
    }

    public int[] getPhysicalIndexes(TableSource tableSource, int[] logicalFieldIndexes) {
        int[] fieldMapping = this.computeIndexMapping(tableSource, true, (Option<int[]>)None$.MODULE$);
        return (int[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(logicalFieldIndexes).map((Function1)new Serializable(fieldMapping){
            public static final long serialVersionUID = 0L;
            private final int[] fieldMapping$1;

            public final int apply(int x$13) {
                return this.apply$mcII$sp(x$13);
            }

            public int apply$mcII$sp(int x$13) {
                return this.fieldMapping$1[x$13];
            }
            {
                this.fieldMapping$1 = fieldMapping$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).flatMap((Function1)new Serializable(tableSource){
            public static final long serialVersionUID = 0L;
            private final TableSource tableSource$5;

            public final SeqLike<Object, Object> apply(int x0$3) {
                SeqLike seqLike;
                int n = x0$3;
                switch (n) {
                    default: {
                        seqLike = (SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{n}));
                        break;
                    }
                    case -1: {
                        Option<RowtimeAttributeDescriptor> rowtimeAttributeDescriptor = TableSourceUtil$.MODULE$.getRowtimeAttributeDescriptor(this.tableSource$5, (Option<int[]>)None$.MODULE$);
                        if (rowtimeAttributeDescriptor.isDefined()) {
                            String[] accessedFields = ((RowtimeAttributeDescriptor)rowtimeAttributeDescriptor.get()).getTimestampExtractor().getArgumentFields();
                            seqLike = Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$resolveInputFields(accessedFields, this.tableSource$5)).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(Tuple3<String, Object, InternalType> x$14) {
                                    return BoxesRunTime.unboxToInt((Object)x$14._2());
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
                            break;
                        }
                        throw new TableException("Computed field mapping includes a rowtime marker but the TableSource does not provide a RowtimeAttributeDescriptor. This is a bug and should be reported.");
                    }
                    case -2: {
                        seqLike = (SeqLike)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                }
                return seqLike;
            }
            {
                this.tableSource$5 = tableSource$5;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
    }

    public String[] org$apache$flink$table$sources$TableSourceUtil$$getRowtimeAttributes(TableSource tableSource) {
        String[] stringArray;
        TableSource tableSource2 = tableSource;
        if (tableSource2 instanceof DefinedRowtimeAttributes) {
            TableSource tableSource3 = tableSource2;
            stringArray = (String[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DefinedRowtimeAttributes)((Object)tableSource3)).getRowtimeAttributeDescriptors()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(RowtimeAttributeDescriptor x$15) {
                    return x$15.getAttributeName();
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        } else {
            stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        }
        return stringArray;
    }

    public Option<String> org$apache$flink$table$sources$TableSourceUtil$$getProctimeAttribute(TableSource tableSource) {
        TableSource tableSource2;
        TableSource tableSource3 = tableSource;
        Object object = tableSource3 instanceof DefinedProctimeAttribute && ((DefinedProctimeAttribute)((Object)(tableSource2 = tableSource3))).getProctimeAttribute() != null ? new Some((Object)((DefinedProctimeAttribute)((Object)tableSource2)).getProctimeAttribute()) : None$.MODULE$;
        return object;
    }

    public Tuple3<String, Object, InternalType> org$apache$flink$table$sources$TableSourceUtil$$resolveInputField(String fieldName, TableSource tableSource) {
        Tuple3 tuple3;
        TableSource tableSource2;
        DataType returnType2 = tableSource.getReturnType();
        TableSource tableSource3 = tableSource;
        if (tableSource3 instanceof DefinedFieldMapping && ((DefinedFieldMapping)((Object)(tableSource2 = tableSource3))).getFieldMapping() != null) {
            String resolvedFieldName = ((DefinedFieldMapping)((Object)tableSource2)).getFieldMapping().get(fieldName);
            if (resolvedFieldName == null) {
                throw new ValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Field '", "' could not be resolved by the field mapping."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldName})));
            }
            tuple3 = this.lookupField$1(resolvedFieldName, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table field '", "' was resolved to TableSource return type field "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "', but field '", "' was not found in the return "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resolvedFieldName, resolvedFieldName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"type ", " of the TableSource. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{returnType2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please verify the field mapping of the TableSource."})).s((Seq)Nil$.MODULE$)).toString(), returnType2);
        } else {
            tuple3 = this.lookupField$1(fieldName, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table field '", "' was not found in the return type ", " of the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldName, returnType2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TableSource."})).s((Seq)Nil$.MODULE$)).toString(), returnType2);
        }
        return tuple3;
    }

    public Tuple3<String, Object, InternalType>[] org$apache$flink$table$sources$TableSourceUtil$$resolveInputFields(String[] fieldNames, TableSource tableSource) {
        return (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])fieldNames).map((Function1)new Serializable(tableSource){
            public static final long serialVersionUID = 0L;
            private final TableSource tableSource$4;

            public final Tuple3<String, Object, InternalType> apply(String x$16) {
                return TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$resolveInputField(x$16, this.tableSource$4);
            }
            {
                this.tableSource$4 = tableSource$4;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
    }

    public final RelNode org$apache$flink$table$sources$TableSourceUtil$$createSchemaRelNode$1(Tuple3[] fields2, RelOptCluster cluster$1, FlinkTypeFactory typeFactory$1) {
        int maxIdx = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])fields2).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple3<String, Object, InternalType> x$11) {
                return BoxesRunTime.unboxToInt((Object)x$11._2());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).max((Ordering)Ordering.Int$.MODULE$));
        Map idxMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])fields2).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<String, InternalType>> apply(Tuple3<String, Object, InternalType> f) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f._2()), (Object)new Tuple2(f._1(), f._3()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))));
        Tuple2 tuple2 = ((GenericTraversableTemplate)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), maxIdx).map((Function1)new Serializable(idxMap){
            public static final long serialVersionUID = 0L;
            private final Map idxMap$1;

            public final Tuple2<String, InternalType> apply(int i) {
                return (Tuple2)this.idxMap$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)i), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, ByteType> apply() {
                        return new Tuple2((Object)"", (Object)DataTypes.BYTE);
                    }
                });
            }
            {
                this.idxMap$1 = idxMap$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            IndexedSeq physicalFields = (IndexedSeq)tuple2._1();
            IndexedSeq physicalTypes = (IndexedSeq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)physicalFields, (Object)physicalTypes);
            IndexedSeq physicalFields2 = (IndexedSeq)tuple23._1();
            IndexedSeq physicalTypes2 = (IndexedSeq)tuple23._2();
            RelDataType physicalSchema = typeFactory$1.buildRelDataType((Seq<String>)physicalFields2, (Seq<InternalType>)physicalTypes2);
            return LogicalValues.create(cluster$1, physicalSchema, ImmutableList.<ImmutableList<RexLiteral>>of());
        }
        throw new MatchError((Object)tuple2);
    }

    private final Tuple3 lookupField$1(String fieldName, String failMsg, DataType returnType$1) {
        InternalType internalType;
        block6: {
            Tuple3 tuple3;
            block5: {
                block4: {
                    internalType = returnType$1.toInternalType();
                    if (!(internalType instanceof RowType)) break block4;
                    RowType rowType = (RowType)internalType;
                    int idx = rowType.getFieldIndex(fieldName);
                    if (idx < 0) {
                        throw new ValidationException(failMsg);
                    }
                    tuple3 = new Tuple3((Object)fieldName, (Object)BoxesRunTime.boxToInteger((int)idx), (Object)rowType.getInternalTypeAt(idx).toInternalType());
                    break block5;
                }
                if (internalType == null) break block6;
                InternalType internalType2 = internalType;
                tuple3 = new Tuple3((Object)fieldName, (Object)BoxesRunTime.boxToInteger((int)0), (Object)internalType2);
            }
            return tuple3;
        }
        throw new MatchError((Object)internalType);
    }

    private TableSourceUtil$() {
        MODULE$ = this;
    }
}

