/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.csv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.TypeGetterSetters;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.plan.schema.IndexKey;
import org.apache.flink.table.sources.csv.BaseRowCsvInputFormat;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.typeutils.AbstractRowSerializer;

public class CsvLookupFunction
extends TableFunction<BaseRow> {
    private final String path;
    private final InternalType[] fieldTypes;
    private final RowType rowType;
    private final TimeZone timezone;
    private final List<Integer> sourceKeys = new ArrayList<Integer>();
    private final List<Integer> targetKeys = new ArrayList<Integer>();
    private final List<InternalType> keyTypes = new ArrayList<InternalType>();
    private final int[] selectedFields;
    private final boolean emptyColumnAsNull;
    private final boolean nestedFileEnumerate;
    private final boolean uniqueIndex;
    private final Map<Object, List<BaseRow>> one2manyDataMap = new HashMap<Object, List<BaseRow>>();
    private final Map<Object, BaseRow> one2oneDataMap = new HashMap<Object, BaseRow>();
    private String fieldDelim = ",";
    private String lineDelim = "\n";
    private String charsetName = "UTF-8";
    private Character quoteCharacter = null;
    private Boolean ignoreFirstLine = false;
    private String ignoreComments = null;
    private Boolean lenient = false;

    public CsvLookupFunction(String path, RowType rowType, IndexKey checkedIndex, boolean emptyColumnAsNull, TimeZone timezone, boolean nestedFileEnumerate) {
        int i;
        this.path = path;
        this.rowType = rowType;
        this.fieldTypes = rowType.getFieldInternalTypes();
        this.uniqueIndex = checkedIndex.isUnique();
        List<Integer> indexCols = checkedIndex.getDefinedColumns();
        for (i = 0; i < indexCols.size(); ++i) {
            this.sourceKeys.add(i);
            int targetIdx = indexCols.get(i);
            assert (targetIdx != -1);
            this.targetKeys.add(targetIdx);
            this.keyTypes.add(this.fieldTypes[targetIdx]);
        }
        this.selectedFields = new int[this.fieldTypes.length];
        for (i = 0; i < this.selectedFields.length; ++i) {
            this.selectedFields[i] = i;
        }
        this.emptyColumnAsNull = emptyColumnAsNull;
        this.timezone = timezone == null ? TimeZone.getTimeZone("UTC") : timezone;
        this.nestedFileEnumerate = nestedFileEnumerate;
    }

    public void setFieldDelim(String fieldDelim) {
        this.fieldDelim = fieldDelim;
    }

    public void setLineDelim(String lineDelim) {
        this.lineDelim = lineDelim;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public void setQuoteCharacter(Character quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
    }

    public void setIgnoreFirstLine(Boolean ignoreFirstLine) {
        this.ignoreFirstLine = ignoreFirstLine;
    }

    public void setIgnoreComments(String ignoreComments) {
        this.ignoreComments = ignoreComments;
    }

    public void setLenient(Boolean lenient) {
        this.lenient = lenient;
    }

    @Override
    public void open(FunctionContext context) throws Exception {
        FileInputSplit[] inputSplits;
        super.open(context);
        AbstractRowSerializer rowSerializer = (AbstractRowSerializer)DataTypes.createInternalSerializer(this.rowType);
        BaseRowCsvInputFormat inputFormat = new BaseRowCsvInputFormat(new Path(this.path), this.fieldTypes, this.lineDelim, this.fieldDelim, this.selectedFields, this.emptyColumnAsNull);
        inputFormat.setTimezone(this.timezone);
        inputFormat.setSkipFirstLineAsHeader(this.ignoreFirstLine);
        inputFormat.setLenient(this.lenient);
        if (this.charsetName != null) {
            inputFormat.setCharset(this.charsetName);
        }
        if (this.quoteCharacter != null) {
            inputFormat.enableQuotedStringParsing(this.quoteCharacter.charValue());
        }
        if (this.ignoreComments != null) {
            inputFormat.setCommentPrefix(this.ignoreComments);
        }
        inputFormat.setNestedFileEnumeration(this.nestedFileEnumerate);
        for (FileInputSplit split : inputSplits = inputFormat.createInputSplits(1)) {
            BaseRow r;
            inputFormat.open(split);
            GenericRow row2 = new GenericRow(this.rowType.getArity());
            while ((r = (BaseRow)inputFormat.nextRecord(row2)) != null) {
                Object key = this.getTargetKey(r);
                if (this.uniqueIndex) {
                    this.one2oneDataMap.put(key, rowSerializer.copy(r));
                    continue;
                }
                if (this.one2manyDataMap.containsKey(key)) {
                    this.one2manyDataMap.get(key).add(rowSerializer.copy(r));
                    continue;
                }
                ArrayList<BaseRow> rows = new ArrayList<BaseRow>();
                rows.add(rowSerializer.copy(r));
                this.one2manyDataMap.put(key, rows);
            }
            inputFormat.close();
        }
    }

    public void eval(Object ... values) {
        Object srcKey = this.getSourceKey(GenericRow.of(values));
        if (this.uniqueIndex) {
            if (this.one2oneDataMap.containsKey(srcKey)) {
                this.collect(this.one2oneDataMap.get(srcKey));
            }
        } else if (this.one2manyDataMap.containsKey(srcKey)) {
            for (BaseRow row1 : this.one2manyDataMap.get(srcKey)) {
                this.collect(row1);
            }
        }
    }

    private Object getSourceKey(BaseRow source) {
        return this.getKey(source, this.sourceKeys);
    }

    private Object getTargetKey(BaseRow target) {
        return this.getKey(target, this.targetKeys);
    }

    private Object getKey(BaseRow input, List<Integer> keys) {
        if (keys.size() == 1) {
            int keyIdx = keys.get(0);
            if (!input.isNullAt(keyIdx)) {
                return TypeGetterSetters.get(input, keyIdx, this.keyTypes.get(0));
            }
            return null;
        }
        GenericRow key = new GenericRow(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            int keyIdx = keys.get(i);
            Object field = null;
            if (!input.isNullAt(keyIdx)) {
                field = TypeGetterSetters.get(input, keyIdx, this.keyTypes.get(i));
            }
            if (field == null) {
                return null;
            }
            key.update(i, field);
        }
        return key;
    }

    @Override
    public void close() throws Exception {
        super.close();
    }
}

