/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.csv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.descriptors.CsvValidator;
import org.apache.flink.table.descriptors.CsvValidator$;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FileSystemValidator;
import org.apache.flink.table.descriptors.FileSystemValidator$;
import org.apache.flink.table.descriptors.SchemaValidator;
import org.apache.flink.table.descriptors.SchemaValidator$;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.sources.csv.CsvTableSource;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.util.JavaScalaConversionUtil$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001%3Q!\u0001\u0002\u0002\u0002=\u0011\u0011dQ:w)\u0006\u0014G.Z*pkJ\u001cWMR1di>\u0014\u0018PQ1tK*\u00111\u0001B\u0001\u0004GN4(BA\u0003\u0007\u0003\u001d\u0019x.\u001e:dKNT!a\u0002\u0005\u0002\u000bQ\f'\r\\3\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!a\u0001\"!\u0005\f\u000e\u0003IQ!a\u0005\u000b\u0002\t1\fgn\u001a\u0006\u0002+\u0005!!.\u0019<b\u0013\t9\"C\u0001\u0004PE*,7\r\u001e\t\u00033qi\u0011A\u0007\u0006\u00037\u0019\t\u0011BZ1di>\u0014\u0018.Z:\n\u0005uQ\"\u0001\u0004+bE2,g)Y2u_JL\b\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\bF\u0001\"!\t\u0011\u0003!D\u0001\u0003\u0011\u0015!\u0003\u0001\"\u0011&\u0003=\u0011X-];je\u0016$7i\u001c8uKb$H#\u0001\u0014\u0011\t\u001dRC\u0006L\u0007\u0002Q)\u0011\u0011\u0006F\u0001\u0005kRLG.\u0003\u0002,Q\t\u0019Q*\u00199\u0011\u00055\u001adB\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz\u0013A\u0002)sK\u0012,g-\u0003\u00025k\t11\u000b\u001e:j]\u001eT!AM\u0018\t\u000b]\u0002A\u0011\t\u001d\u0002'M,\b\u000f]8si\u0016$\u0007K]8qKJ$\u0018.Z:\u0015\u0003e\u00022a\n\u001e-\u0013\tY\u0004F\u0001\u0003MSN$\b\"B\u001f\u0001\t#q\u0014!E2sK\u0006$X\rV1cY\u0016\u001cv.\u001e:dKR\u0019qHQ$\u0011\u0005\t\u0002\u0015BA!\u0003\u00059\u00195O\u001e+bE2,7k\\;sG\u0016DQa\u0011\u001fA\u0002\u0011\u000b1\"[:TiJ,\u0017-\\5oOB\u0011a&R\u0005\u0003\r>\u0012qAQ8pY\u0016\fg\u000eC\u0003Iy\u0001\u0007a%\u0001\u0006qe>\u0004XM\u001d;jKN\u0004")
public abstract class CsvTableSourceFactoryBase
implements TableFactory {
    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, String> requiredContext() {
        void var1_1;
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("connector.type", FileSystemValidator$.MODULE$.CONNECTOR_TYPE_VALUE());
        context.put("format.type", CsvValidator$.MODULE$.FORMAT_TYPE_VALUE());
        context.put("connector.property-version", "1");
        context.put("format.property-version", "1");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> supportedProperties() {
        void var1_1;
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(FileSystemValidator$.MODULE$.CONNECTOR_PATH());
        properties.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".#.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CsvValidator$.MODULE$.FORMAT_FIELDS(), "type"})));
        properties.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".#.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CsvValidator$.MODULE$.FORMAT_FIELDS(), "name"})));
        properties.add(CsvValidator$.MODULE$.FORMAT_FIELD_DELIMITER());
        properties.add(CsvValidator$.MODULE$.FORMAT_LINE_DELIMITER());
        properties.add(CsvValidator$.MODULE$.FORMAT_QUOTE_CHARACTER());
        properties.add(CsvValidator$.MODULE$.FORMAT_COMMENT_PREFIX());
        properties.add(CsvValidator$.MODULE$.FORMAT_IGNORE_FIRST_LINE());
        properties.add(CsvValidator$.MODULE$.FORMAT_IGNORE_PARSE_ERRORS());
        properties.add(FileSystemValidator$.MODULE$.CONNECTOR_PATH());
        properties.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".#.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SchemaValidator$.MODULE$.SCHEMA(), "type"})));
        properties.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".#.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SchemaValidator$.MODULE$.SCHEMA(), "name"})));
        return var1_1;
    }

    public CsvTableSource createTableSource(boolean isStreaming, Map<String, String> properties) {
        DescriptorProperties params = new DescriptorProperties();
        params.putProperties(properties);
        new FileSystemValidator().validate(params);
        new CsvValidator().validate(params);
        new SchemaValidator(isStreaming, false, false).validate(params);
        CsvTableSource.Builder csvTableSourceBuilder = new CsvTableSource.Builder();
        TableSchema formatSchema = params.getTableSchema(CsvValidator$.MODULE$.FORMAT_FIELDS());
        TableSchema tableSchema2 = params.getTableSchema(SchemaValidator$.MODULE$.SCHEMA());
        if (formatSchema.equals(tableSchema2)) {
            JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalString(FileSystemValidator$.MODULE$.CONNECTOR_PATH())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(String path) {
                    return this.csvTableSourceBuilder$1.path(path);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalString(CsvValidator$.MODULE$.FORMAT_FIELD_DELIMITER())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(String delim) {
                    return this.csvTableSourceBuilder$1.fieldDelimiter(delim);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalString(CsvValidator$.MODULE$.FORMAT_LINE_DELIMITER())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(String delim) {
                    return this.csvTableSourceBuilder$1.lineDelimiter(delim);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])formatSchema.getFieldNames()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])formatSchema.getFieldTypes()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(Tuple2<String, InternalType> x0$1) {
                    Tuple2<String, InternalType> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        InternalType tpe = (InternalType)tuple2._2();
                        CsvTableSource.Builder builder = this.csvTableSourceBuilder$1.field(name, tpe);
                        return builder;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalCharacter(CsvValidator$.MODULE$.FORMAT_QUOTE_CHARACTER())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(Character quote) {
                    return this.csvTableSourceBuilder$1.quoteCharacter(quote);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalString(CsvValidator$.MODULE$.FORMAT_COMMENT_PREFIX())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(String prefix) {
                    return this.csvTableSourceBuilder$1.commentPrefix(prefix);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalBoolean(CsvValidator$.MODULE$.FORMAT_IGNORE_FIRST_LINE())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final Object apply(Boolean flag) {
                    return Predef$.MODULE$.Boolean2boolean(flag) ? this.csvTableSourceBuilder$1.ignoreFirstLine() : BoxedUnit.UNIT;
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalBoolean(CsvValidator$.MODULE$.FORMAT_IGNORE_PARSE_ERRORS())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final Object apply(Boolean flag) {
                    return Predef$.MODULE$.Boolean2boolean(flag) ? this.csvTableSourceBuilder$1.ignoreParseErrors() : BoxedUnit.UNIT;
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            return csvTableSourceBuilder.build();
        }
        throw new TableException("Encodings that differ from the schema are not supported yet for CsvTableSources.");
    }
}

