/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.orc;

import java.util.Arrays;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.vector.ColumnVector;
import org.apache.flink.table.dataformat.vector.TypeGetVector;
import org.apache.flink.table.dataformat.vector.VectorizedColumnBatch;
import org.apache.flink.table.types.BooleanType;
import org.apache.flink.table.types.ByteArrayType;
import org.apache.flink.table.types.ByteType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DateType;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.DoubleType;
import org.apache.flink.table.types.FloatType;
import org.apache.flink.table.types.IntType;
import org.apache.flink.table.types.LongType;
import org.apache.flink.table.types.ShortType;
import org.apache.flink.table.types.StringType;
import org.apache.flink.table.types.TimestampType;
import org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;
import org.apache.orc.storage.ql.exec.vector.LongColumnVector;
import org.apache.orc.storage.ql.exec.vector.TimestampColumnVector;
import org.apache.orc.storage.serde2.io.HiveDecimalWritable;

public class OrcColumnVector
extends TypeGetVector {
    private DataType fieldType;
    private org.apache.orc.storage.ql.exec.vector.ColumnVector baseData;
    private LongColumnVector longData;
    private DoubleColumnVector doubleData;
    private BytesColumnVector bytesData;
    private DecimalColumnVector decimalData;
    private TimestampColumnVector timestampData;

    public OrcColumnVector(DataType fieldType, org.apache.orc.storage.ql.exec.vector.ColumnVector vector) {
        super(vector.isNull.length);
        this.fieldType = fieldType;
        this.baseData = vector;
        if (vector instanceof LongColumnVector) {
            this.longData = (LongColumnVector)vector;
        } else if (vector instanceof DoubleColumnVector) {
            this.doubleData = (DoubleColumnVector)vector;
        } else if (vector instanceof BytesColumnVector) {
            this.bytesData = (BytesColumnVector)vector;
        } else if (vector instanceof DecimalColumnVector) {
            this.decimalData = (DecimalColumnVector)vector;
        } else if (vector instanceof TimestampColumnVector) {
            this.timestampData = (TimestampColumnVector)vector;
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public Object get(int index) {
        if (this.baseData.isNull[index]) {
            return null;
        }
        if (this.baseData.isRepeating) {
            index = 0;
        }
        if (this.fieldType instanceof BooleanType) {
            return this.longData.vector[index] == 1L;
        }
        if (this.fieldType instanceof ByteType) {
            return (byte)this.longData.vector[index];
        }
        if (this.fieldType instanceof ShortType) {
            return (short)this.longData.vector[index];
        }
        if (this.fieldType instanceof IntType) {
            return (int)this.longData.vector[index];
        }
        if (this.fieldType instanceof LongType) {
            return this.longData.vector[index];
        }
        if (this.fieldType instanceof FloatType) {
            return Float.valueOf((float)this.doubleData.vector[index]);
        }
        if (this.fieldType instanceof DoubleType) {
            return this.doubleData.vector[index];
        }
        if (this.fieldType instanceof StringType || this.fieldType instanceof ByteArrayType) {
            byte[][] data = this.bytesData.vector;
            int[] start = this.bytesData.start;
            int[] length = this.bytesData.length;
            return Arrays.copyOfRange(data[index], start[index], start[index] + length[index]);
        }
        if (this.fieldType instanceof DecimalType) {
            HiveDecimalWritable[] data = this.decimalData.vector;
            int precision = ((DecimalType)this.fieldType).precision();
            int scala = ((DecimalType)this.fieldType).scale();
            Decimal decimal = Decimal.fromBigDecimal(data[index].getHiveDecimal().bigDecimalValue(), precision, scala);
            if (Decimal.is32BitDecimal(precision)) {
                return (int)decimal.toUnscaledLong();
            }
            if (Decimal.is64BitDecimal(precision)) {
                return decimal.toUnscaledLong();
            }
            return decimal.toUnscaledBytes();
        }
        if (this.fieldType instanceof DateType) {
            return (int)this.longData.vector[index];
        }
        if (this.fieldType instanceof TimestampType) {
            return this.timestampData.time[index] + (long)(this.timestampData.nanos[index] / 1000000);
        }
        throw new UnsupportedOperationException("Unsupported Data Type: " + this.fieldType);
    }

    @Override
    public boolean getBoolean(int rowId) {
        if (this.baseData.isRepeating) {
            rowId = 0;
        }
        return this.longData.vector[rowId] == 1L;
    }

    @Override
    public byte getByte(int rowId) {
        if (this.baseData.isRepeating) {
            rowId = 0;
        }
        return (byte)this.longData.vector[rowId];
    }

    @Override
    public short getShort(int rowId) {
        if (this.baseData.isRepeating) {
            rowId = 0;
        }
        return (short)this.longData.vector[rowId];
    }

    @Override
    public int getInt(int rowId) {
        if (this.baseData.isRepeating) {
            rowId = 0;
        }
        return (int)this.longData.vector[rowId];
    }

    @Override
    public long getLong(int rowId) {
        if (this.baseData.isRepeating) {
            rowId = 0;
        }
        if (this.fieldType instanceof TimestampType) {
            return this.timestampData.time[rowId] + (long)(this.timestampData.nanos[rowId] / 1000000);
        }
        return this.longData.vector[rowId];
    }

    @Override
    public float getFloat(int rowId) {
        if (this.baseData.isRepeating) {
            rowId = 0;
        }
        return (float)this.doubleData.vector[rowId];
    }

    @Override
    public double getDouble(int rowId) {
        if (this.baseData.isRepeating) {
            rowId = 0;
        }
        return this.doubleData.vector[rowId];
    }

    @Override
    public VectorizedColumnBatch.ByteArray getByteArray(int rowId) {
        if (this.baseData.isRepeating) {
            rowId = 0;
        }
        byte[][] data = this.bytesData.vector;
        int[] start = this.bytesData.start;
        int[] length = this.bytesData.length;
        return new VectorizedColumnBatch.ByteArray(data[rowId], start[rowId], length[rowId]);
    }

    @Override
    public Decimal getDecimal(int rowId, int precision, int scala) {
        if (this.baseData.isRepeating) {
            rowId = 0;
        }
        HiveDecimalWritable[] data = this.decimalData.vector;
        return Decimal.fromBigDecimal(data[rowId].getHiveDecimal().bigDecimalValue(), precision, scala);
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        throw new UnsupportedOperationException();
    }

    public void setNullInfo(org.apache.orc.storage.ql.exec.vector.ColumnVector vector) {
        System.arraycopy(vector.isNull, 0, this.isNull, 0, vector.isNull.length);
        this.noNulls = vector.noNulls;
    }
}

