/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.orc;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.runtime.functions.BuildInScalarFunctions;
import org.apache.flink.table.types.BooleanType;
import org.apache.flink.table.types.ByteType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DateType;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.DoubleType;
import org.apache.flink.table.types.FloatType;
import org.apache.flink.table.types.IntType;
import org.apache.flink.table.types.LongType;
import org.apache.flink.table.types.ShortType;
import org.apache.flink.table.types.StringType;
import org.apache.flink.table.types.TimestampType;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapred.OrcTimestamp;
import org.apache.orc.storage.common.type.HiveDecimal;
import org.apache.orc.storage.serde2.io.DateWritable;
import org.apache.orc.storage.serde2.io.HiveDecimalWritable;

public class OrcDeserializer {
    private final DataType[] fieldTypes;
    private final String[] fieldNames;
    private final int[] columnIds;
    private final Converter[] fieldConverters;
    private static final Map<Class<? extends DataType>, Converter> CONVERTER_MAP = new HashMap<Class<? extends DataType>, Converter>(){
        private static final long serialVersionUID = 2137301835386882070L;
        {
            this.put(BooleanType.class, new BooleanConverter());
            this.put(ByteType.class, new ByteConverter());
            this.put(ShortType.class, new ShortConverter());
            this.put(IntType.class, new IntConverter());
            this.put(LongType.class, new LongConverter());
            this.put(FloatType.class, new FloatConverter());
            this.put(DoubleType.class, new DoubleConverter());
            this.put(StringType.class, new StringConverter());
            this.put(DateType.class, new SqlDateConverter());
            this.put(TimestampType.class, new SqlTimestampConverter());
            this.put(DecimalType.class, new DecimalConverter());
        }
    };

    public OrcDeserializer(DataType[] fieldTypes2, String[] fieldNames, int[] columnIds) {
        Preconditions.checkArgument(fieldTypes2 != null && fieldTypes2.length > 0);
        Preconditions.checkArgument(fieldNames != null && fieldNames.length == fieldTypes2.length);
        this.fieldTypes = fieldTypes2;
        this.fieldNames = fieldNames;
        this.columnIds = columnIds;
        this.fieldConverters = new Converter[fieldTypes2.length];
        for (int i = 0; i < fieldTypes2.length; ++i) {
            this.fieldConverters[i] = CONVERTER_MAP.get(fieldTypes2[i].getClass());
            this.fieldConverters[i].setFieldType(fieldTypes2[i]);
        }
    }

    public Row deserialize(OrcStruct orcStruct, Row reuse) {
        int i;
        for (i = 0; i < reuse.getArity(); ++i) {
            reuse.setField(i, null);
        }
        for (i = 0; i < this.columnIds.length; ++i) {
            if (this.columnIds[i] == -1) continue;
            WritableComparable value = orcStruct.getFieldValue(this.columnIds[i]);
            if (value == null) {
                reuse.setField(i, null);
                continue;
            }
            reuse.setField(i, this.fieldConverters[i].convert(value));
        }
        return reuse;
    }

    private static class SqlTimestampConverter
    extends Converter {
        private SqlTimestampConverter() {
        }

        @Override
        protected Object convert(WritableComparable value) {
            Preconditions.checkArgument(value instanceof OrcTimestamp);
            return BuildInScalarFunctions.internalToTimestamp(((OrcTimestamp)value).getTime());
        }
    }

    private static class SqlDateConverter
    extends Converter {
        private SqlDateConverter() {
        }

        @Override
        protected Object convert(WritableComparable value) {
            Preconditions.checkArgument(value instanceof DateWritable);
            return BuildInScalarFunctions.internalToDate(((DateWritable)value).getDays());
        }
    }

    private static class DecimalConverter
    extends Converter {
        private DecimalConverter() {
        }

        @Override
        protected Object convert(WritableComparable value) {
            Preconditions.checkArgument(value instanceof HiveDecimalWritable);
            HiveDecimal decimal = ((HiveDecimalWritable)value).getHiveDecimal();
            int precision = ((DecimalType)this.fieldType).precision();
            int scale = ((DecimalType)this.fieldType).scale();
            return Decimal.fromBigDecimal(decimal.bigDecimalValue(), precision, scale).toBigDecimal();
        }
    }

    private static class DoubleConverter
    extends Converter {
        private DoubleConverter() {
        }

        @Override
        protected Object convert(WritableComparable value) {
            Preconditions.checkArgument(value instanceof DoubleWritable);
            return ((DoubleWritable)value).get();
        }
    }

    private static class FloatConverter
    extends Converter {
        private FloatConverter() {
        }

        @Override
        protected Object convert(WritableComparable value) {
            Preconditions.checkArgument(value instanceof FloatWritable);
            return Float.valueOf(((FloatWritable)value).get());
        }
    }

    private static class LongConverter
    extends Converter {
        private LongConverter() {
        }

        @Override
        protected Object convert(WritableComparable value) {
            Preconditions.checkArgument(value instanceof LongWritable);
            return ((LongWritable)value).get();
        }
    }

    private static class IntConverter
    extends Converter {
        private IntConverter() {
        }

        @Override
        protected Object convert(WritableComparable value) {
            Preconditions.checkArgument(value instanceof IntWritable);
            return ((IntWritable)value).get();
        }
    }

    private static class ShortConverter
    extends Converter {
        private ShortConverter() {
        }

        @Override
        protected Object convert(WritableComparable value) {
            Preconditions.checkArgument(value instanceof ShortWritable);
            return ((ShortWritable)value).get();
        }
    }

    private static class ByteConverter
    extends Converter {
        private ByteConverter() {
        }

        @Override
        protected Object convert(WritableComparable value) {
            Preconditions.checkArgument(value instanceof ByteWritable);
            return ((ByteWritable)value).get();
        }
    }

    private static class BooleanConverter
    extends Converter {
        private BooleanConverter() {
        }

        @Override
        protected Object convert(WritableComparable value) {
            Preconditions.checkArgument(value instanceof BooleanWritable);
            return ((BooleanWritable)value).get();
        }
    }

    private static class StringConverter
    extends Converter {
        private StringConverter() {
        }

        @Override
        protected Object convert(WritableComparable value) {
            Preconditions.checkArgument(value instanceof Text);
            return ((Text)value).toString();
        }
    }

    private static abstract class Converter {
        protected DataType fieldType;

        private Converter() {
        }

        protected abstract Object convert(WritableComparable var1);

        protected void setFieldType(DataType fieldType) {
            this.fieldType = fieldType;
        }
    }
}

