/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.orc;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.SafetyNetWrapperFileSystem;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.table.sources.orc.OrcUtils;
import org.apache.flink.table.sources.parquet.RecordReaderIterator;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.mapreduce.OrcMapreduceRecordReader;
import org.apache.orc.storage.ql.io.sarg.SearchArgument;
import org.apache.orc.storage.ql.io.sarg.SearchArgumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OrcInputFormat<T, R>
extends FileInputFormat<T> {
    private static final long serialVersionUID = -603475013213133955L;
    private static final Logger LOG = LoggerFactory.getLogger(OrcInputFormat.class);
    protected final InternalType[] fieldTypes;
    protected final String[] fieldNames;
    private byte[] filterBytes;
    private boolean isCaseSensitive = true;
    protected String[] schemaFieldNames;
    protected int[] columnIds;
    protected transient RecordReaderIterator<R> readerIterator;

    protected OrcInputFormat(Path filePath, InternalType[] fieldTypes2, String[] fieldNames) {
        super(filePath);
        Preconditions.checkArgument(fieldTypes2 != null && fieldTypes2.length > 0);
        Preconditions.checkArgument(fieldNames != null && fieldNames.length == fieldTypes2.length);
        this.fieldTypes = fieldTypes2;
        this.fieldNames = fieldNames;
    }

    public void setFilterPredicate(SearchArgument sarg) throws Exception {
        if (sarg != null) {
            Output out = new Output(100000);
            new Kryo().writeObject(out, (Object)sarg);
            this.filterBytes = out.toBytes();
        } else {
            this.filterBytes = null;
        }
    }

    public void setSchemaFields(String[] schemaFieldNames) {
        this.schemaFieldNames = schemaFieldNames;
    }

    private SearchArgument getFilterPredicate() {
        if (this.filterBytes != null) {
            try {
                return (SearchArgument)new Kryo().readObject(new Input(this.filterBytes), SearchArgumentImpl.class);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        return null;
    }

    @Override
    public void open(FileInputSplit fileSplit) throws IOException {
        Configuration hadoopConf = new Configuration();
        FileSystem fs = fileSplit.getPath().getFileSystem();
        if (fs instanceof SafetyNetWrapperFileSystem) {
            fs = ((SafetyNetWrapperFileSystem)fs).getWrappedDelegate();
        }
        if (fs instanceof HadoopFileSystem) {
            hadoopConf.addResource(((HadoopFileSystem)fs).getConfig());
        }
        if (!(fs instanceof LocalFileSystem) && !(fs instanceof HadoopFileSystem)) {
            throw new RuntimeException("FileSystem: " + fs.getClass().getCanonicalName() + " is not supported.");
        }
        SearchArgument filter = this.getFilterPredicate();
        if (null != filter) {
            org.apache.orc.mapreduce.OrcInputFormat.setSearchArgument((Configuration)hadoopConf, (SearchArgument)filter, (String[])this.fieldNames);
        }
        org.apache.hadoop.fs.Path filePath = new org.apache.hadoop.fs.Path(fileSplit.getPath().toUri());
        Reader reader = OrcFile.createReader((org.apache.hadoop.fs.Path)filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)hadoopConf).maxLength(OrcConf.MAX_FILE_LENGTH.getLong(hadoopConf)));
        this.columnIds = OrcUtils.requestedColumnIds(this.isCaseSensitive, this.fieldNames, this.schemaFieldNames, reader);
        if (this.columnIds != null) {
            String includeColumns = Arrays.stream(this.columnIds).filter(column -> column != -1).mapToObj(String::valueOf).collect(Collectors.joining(","));
            hadoopConf.set(OrcConf.INCLUDE_COLUMNS.getAttribute(), includeColumns);
        } else {
            hadoopConf.set(OrcConf.INCLUDE_COLUMNS.getAttribute(), "");
        }
        TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
        TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(hadoopConf, attemptId);
        RecordReader recordReader = this.createReader(fileSplit, (TaskAttemptContext)taskAttemptContext);
        FileSplit split = new FileSplit(new org.apache.hadoop.fs.Path(fileSplit.getPath().toUri()), fileSplit.getStart(), fileSplit.getLength(), fileSplit.getHostnames());
        try {
            recordReader.initialize((InputSplit)split, (TaskAttemptContext)taskAttemptContext);
        }
        catch (InterruptedException e2) {
            throw new RuntimeException(e2);
        }
        this.readerIterator = new RecordReaderIterator(recordReader);
    }

    @Override
    public void close() throws IOException {
        if (null != this.readerIterator) {
            this.readerIterator.close();
        }
    }

    @Override
    public boolean reachedEnd() throws IOException {
        return !this.readerIterator.hasNext();
    }

    @Override
    public T nextRecord(T reuse) throws IOException {
        R next = this.readerIterator.next();
        return this.convert(next);
    }

    protected abstract T convert(R var1);

    protected RecordReader createReader(FileInputSplit fileSplit, TaskAttemptContext taskAttemptContext) throws IOException {
        Configuration hadoopConf = taskAttemptContext.getConfiguration();
        org.apache.hadoop.fs.Path filePath = new org.apache.hadoop.fs.Path(fileSplit.getPath().toUri());
        Reader file = OrcFile.createReader((org.apache.hadoop.fs.Path)filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)hadoopConf).maxLength(OrcConf.MAX_FILE_LENGTH.getLong(hadoopConf)));
        return new OrcMapreduceRecordReader(file, org.apache.orc.mapred.OrcInputFormat.buildOptions((Configuration)hadoopConf, (Reader)file, (long)fileSplit.getStart(), (long)fileSplit.getLength()));
    }
}

