/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.orc;

import java.io.IOException;
import org.apache.flink.table.dataformat.ColumnarRow;
import org.apache.flink.table.sources.orc.OrcVectorizedReader;
import org.apache.flink.table.types.InternalType;

public class OrcVectorizedColumnRowReader
extends OrcVectorizedReader {
    private int rowIdx = -1;
    private int batchSize = 0;
    private ColumnarRow columnarRow = new ColumnarRow();

    public OrcVectorizedColumnRowReader(InternalType[] fieldTypes2, String[] fieldNames, String[] schemaFieldNames) {
        this(fieldTypes2, fieldNames, schemaFieldNames, false);
    }

    public OrcVectorizedColumnRowReader(InternalType[] fieldTypes2, String[] fieldNames, String[] schemaFieldNames, boolean copyToFlink) {
        super(fieldTypes2, fieldNames, schemaFieldNames, copyToFlink, true);
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        ++this.rowIdx;
        if (this.rowIdx >= this.batchSize) {
            if (!this.nextBatch()) {
                return false;
            }
            this.batchSize = this.columnarBatch.getNumRows();
            this.rowIdx = 0;
            this.columnarRow.setVectorizedColumnBatch(this.columnarBatch);
        }
        return true;
    }

    @Override
    public Object getCurrentValue() throws IOException, InterruptedException {
        this.columnarRow.setRowId(this.rowIdx);
        return this.columnarRow;
    }
}

