/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.shaded.calcite.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.runtime.functions.BuildInScalarFunctions;
import org.apache.flink.table.sources.parquet.ParquetInputFormat;
import org.apache.flink.table.sources.parquet.ParquetTableStatsCollector$;
import org.apache.flink.table.sources.parquet.ParquetTableStatsCollector$$anonfun$org$apache$flink$table$sources$parquet$ParquetTableStatsCollector$;
import org.apache.flink.table.types.BooleanType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.DateType;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.DoubleType;
import org.apache.flink.table.types.FloatType;
import org.apache.flink.table.types.IntType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.LongType;
import org.apache.flink.table.types.StringType;
import org.apache.flink.table.types.TimeType;
import org.apache.flink.table.types.TimestampType;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.BooleanStatistics;
import org.apache.parquet.column.statistics.DoubleStatistics;
import org.apache.parquet.column.statistics.FloatStatistics;
import org.apache.parquet.column.statistics.IntStatistics;
import org.apache.parquet.column.statistics.LongStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.example.data.simple.NanoTime;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.compat.RowGroupFilter;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.EmptyMethodCache;
import scala.runtime.MethodCache;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class ParquetTableStatsCollector$
implements Logging {
    public static final ParquetTableStatsCollector$ MODULE$;
    private final int defaultTimeout;
    private final TimeUnit timeoutTimeUnit;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;
    private static Class[] reflParams$Cache1;
    private static volatile SoftReference reflPoly$Cache1;

    static {
        reflParams$Cache1 = new Class[]{Path.class, List.class};
        reflPoly$Cache1 = new SoftReference<EmptyMethodCache>(new EmptyMethodCache());
        new ParquetTableStatsCollector$();
    }

    public static Method reflMethod$Method1(Class x$1) {
        Method method1;
        MethodCache methodCache1 = (MethodCache)reflPoly$Cache1.get();
        if (methodCache1 == null) {
            methodCache1 = new EmptyMethodCache();
            reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1);
        }
        if ((method1 = methodCache1.find(x$1)) != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("listFileStatus", reflParams$Cache1));
        reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1.add(x$1, method1));
        return method1;
    }

    private Logger LOG$lzycompute() {
        ParquetTableStatsCollector$ parquetTableStatsCollector$ = this;
        synchronized (parquetTableStatsCollector$) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    public int defaultTimeout() {
        return this.defaultTimeout;
    }

    public TimeUnit timeoutTimeUnit() {
        return this.timeoutTimeUnit;
    }

    public TableStats collectTableStats(Path filePath, boolean nestedFileEnumeration, String[] fieldNames, InternalType[] fieldTypes2, Option<FilterPredicate> filter, Option<Configuration> hadoopConf, Option<Object> maxThreads) {
        long startTime = System.currentTimeMillis();
        List<FileStatus> fileStatus = this.listFileStatus(filePath, nestedFileEnumeration, fieldNames, fieldTypes2);
        if (fileStatus.isEmpty()) {
            return new TableStats(Predef$.MODULE$.long2Long(0L));
        }
        Configuration config = (Configuration)hadoopConf.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Configuration apply() {
                return new Configuration();
            }
        });
        Tuple2<Long, java.util.Map<String, Statistics<?>>> tuple2 = this.collectStatistics(fileStatus, fieldNames, config, filter, maxThreads);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Long totalRowCount = (Long)tuple2._1();
            java.util.Map finalStatsMap = (java.util.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)totalRowCount, (Object)finalStatsMap);
            Long totalRowCount2 = (Long)tuple23._1();
            java.util.Map finalStatsMap2 = (java.util.Map)tuple23._2();
            scala.collection.immutable.Map finalColumnStats = ((TraversableOnce)JavaConversions$.MODULE$.mapAsScalaMap(finalStatsMap2).map((Function1)new Serializable(fieldNames, fieldTypes2){
                public static final long serialVersionUID = 0L;
                private final String[] fieldNames$1;
                private final InternalType[] fieldTypes$1;

                public final Tuple2<String, ColumnStats> apply(Tuple2<String, Statistics<?>> x0$1) {
                    Tuple2<String, Statistics<?>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        Statistics stats = (Statistics)tuple2._2();
                        int index = Predef$.MODULE$.refArrayOps((Object[])this.fieldNames$1).indexOf((Object)name);
                        InternalType typeInfo = this.fieldTypes$1[index];
                        ColumnStats columnStats = new ColumnStats(null, stats.isEmpty() ? null : Predef$.MODULE$.long2Long(stats.getNumNulls()), null, null, ParquetTableStatsCollector$.MODULE$.org$apache$flink$table$sources$parquet$ParquetTableStatsCollector$$getMaxMinValueByTypeInfo(typeInfo, stats, true), ParquetTableStatsCollector$.MODULE$.org$apache$flink$table$sources$parquet$ParquetTableStatsCollector$$getMaxMinValueByTypeInfo(typeInfo, stats, false));
                        Tuple2 tuple22 = new Tuple2((Object)name, (Object)columnStats);
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.fieldNames$1 = fieldNames$1;
                    this.fieldTypes$1 = fieldTypes$1;
                }
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            long endTime = System.currentTimeMillis();
            if (this.LOG().isDebugEnabled()) {
                this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"collect TableStats from path: ", ", cost: ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath, BoxesRunTime.boxToLong((long)(endTime - startTime))})));
            }
            return new TableStats(totalRowCount2, JavaConversions$.MODULE$.mapAsJavaMap((Map)finalColumnStats));
        }
        throw new MatchError(tuple2);
    }

    public Option<FilterPredicate> collectTableStats$default$5() {
        return None$.MODULE$;
    }

    public Option<Configuration> collectTableStats$default$6() {
        return None$.MODULE$;
    }

    public Option<Object> collectTableStats$default$7() {
        return None$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<Long, java.util.Map<String, Statistics<?>>> collectStatistics(List<FileStatus> fileStatus, String[] fieldNames, Configuration hadoopConf, Option<FilterPredicate> filter, Option<Object> maxThreads) {
        numOfCpuCores = Hardware.getNumberCPUCores();
        defaultThreads = package$.MODULE$.min(package$.MODULE$.max(numOfCpuCores / 2, 1), fileStatus.size());
        var8_8 = false;
        var9_9 = null;
        var10_10 = maxThreads;
        if (!(var10_10 instanceof Some)) ** GOTO lbl-1000
        var8_8 = true;
        var9_9 = (Some)var10_10;
        t = BoxesRunTime.unboxToInt((Object)var9_9.x());
        if (t > 0) {
            threads = package$.MODULE$.min(package$.MODULE$.min(numOfCpuCores, t), fileStatus.size());
            if (this.LOG().isDebugEnabled()) {
                this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max threads: ", ", uses threads: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t), BoxesRunTime.boxToInteger((int)threads)})));
            }
            var13_13 = threads;
        } else if (var8_8) {
            t = BoxesRunTime.unboxToInt((Object)var9_9.x());
            this.LOG().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal max threads: ", ", uses default value: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)t), BoxesRunTime.boxToInteger((int)defaultThreads)})));
            var13_13 = defaultThreads;
        } else {
            if (this.LOG().isDebugEnabled()) {
                this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Uses default threads: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultThreads)})));
            }
            var13_13 = defaultThreads;
        }
        numOfThreads = var13_13;
        threadFactory = new ThreadFactoryBuilder().setNameFormat("Collect Parquet statistics Thread %d").build();
        executor = Executors.newFixedThreadPool(numOfThreads, threadFactory);
        totalRowCount = ObjectRef.create((Object)Predef$.MODULE$.long2Long(0L));
        finalStatsMap = new HashMap<K, V>();
        try {
            results = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(fileStatus).map((Function1)new Serializable(fieldNames, hadoopConf, filter, executor){
                public static final long serialVersionUID = 0L;
                public final String[] fieldNames$3;
                public final Configuration hadoopConf$1;
                public final Option filter$1;
                private final ExecutorService executor$1;

                public final Future<Tuple2<Long, java.util.Map<String, Statistics<?>>>> apply(FileStatus file) {
                    return this.executor$1.submit(new Callable<Tuple2<Long, java.util.Map<String, Statistics<?>>>>(this, file){
                        private final /* synthetic */ anonfun.4 $outer;
                        private final FileStatus file$1;

                        public Tuple2<Long, java.util.Map<String, Statistics<?>>> call() {
                            return ParquetTableStatsCollector$.MODULE$.org$apache$flink$table$sources$parquet$ParquetTableStatsCollector$$getStatisticsOfFile(this.file$1, this.$outer.fieldNames$3, this.$outer.hadoopConf$1, (Option<FilterPredicate>)this.$outer.filter$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.file$1 = file$1;
                        }
                    });
                }
                {
                    this.fieldNames$3 = fieldNames$3;
                    this.hadoopConf$1 = hadoopConf$1;
                    this.filter$1 = filter$1;
                    this.executor$1 = executor$1;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            results.foreach((Function1)new Serializable(totalRowCount, finalStatsMap){
                public static final long serialVersionUID = 0L;
                private final ObjectRef totalRowCount$1;
                public final HashMap finalStatsMap$1;

                public final void apply(Future<Tuple2<Long, java.util.Map<String, Statistics<?>>>> f) {
                    Tuple2<Long, java.util.Map<String, Statistics<?>>> tuple2 = f.get(ParquetTableStatsCollector$.MODULE$.defaultTimeout(), ParquetTableStatsCollector$.MODULE$.timeoutTimeUnit());
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        Long rowCount = (Long)tuple2._1();
                        java.util.Map fileStatsMap = (java.util.Map)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)rowCount, (Object)fileStatsMap);
                        Long rowCount2 = (Long)tuple23._1();
                        java.util.Map fileStatsMap2 = (java.util.Map)tuple23._2();
                        this.totalRowCount$1.elem = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long((Long)this.totalRowCount$1.elem) + Predef$.MODULE$.Long2long(rowCount2));
                        JavaConversions$.MODULE$.mapAsScalaMap(fileStatsMap2).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.collectStatistics.1 $outer;

                            public final void apply(Tuple2<String, Statistics<?>> x0$2) {
                                Tuple2<String, Statistics<?>> tuple2 = x0$2;
                                if (tuple2 != null) {
                                    String fieldName = (String)tuple2._1();
                                    Statistics colStats = (Statistics)tuple2._2();
                                    ParquetTableStatsCollector$.MODULE$.org$apache$flink$table$sources$parquet$ParquetTableStatsCollector$$updateStatistics(colStats, fieldName, this.$outer.finalStatsMap$1);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.totalRowCount$1 = totalRowCount$1;
                    this.finalStatsMap$1 = finalStatsMap$1;
                }
            });
            executor.shutdownNow();
        }
        catch (Throwable var21_21) {
            var17_17.shutdownNow();
            throw var21_21;
        }
        return new Tuple2((Object)((Long)totalRowCount.elem), finalStatsMap);
    }

    public Object org$apache$flink$table$sources$parquet$ParquetTableStatsCollector$$getMaxMinValueByTypeInfo(InternalType typeInfo, Statistics<?> stat, boolean isMax) {
        Comparable<Boolean> comparable;
        InternalType internalType = typeInfo;
        BooleanType booleanType = DataTypes.BOOLEAN;
        InternalType internalType2 = internalType;
        if (!(booleanType != null ? !((Object)booleanType).equals(internalType2) : internalType2 != null)) {
            Boolean bl;
            Statistics<?> statistics = stat;
            if (statistics instanceof BooleanStatistics) {
                BooleanStatistics booleanStatistics = (BooleanStatistics)statistics;
                bl = isMax ? BoxesRunTime.boxToBoolean((boolean)booleanStatistics.getMax()) : BoxesRunTime.boxToBoolean((boolean)booleanStatistics.getMin());
            } else {
                bl = null;
            }
            comparable = bl;
        } else {
            FloatType floatType = DataTypes.FLOAT;
            InternalType internalType3 = internalType;
            if (!(floatType != null ? !((Object)floatType).equals(internalType3) : internalType3 != null)) {
                Float f;
                Statistics<?> statistics = stat;
                if (statistics instanceof FloatStatistics) {
                    FloatStatistics floatStatistics = (FloatStatistics)statistics;
                    f = isMax ? BoxesRunTime.boxToFloat((float)floatStatistics.getMax()) : BoxesRunTime.boxToFloat((float)floatStatistics.getMin());
                } else {
                    f = null;
                }
                comparable = f;
            } else {
                IntType intType = DataTypes.INT;
                InternalType internalType4 = internalType;
                if (!(intType != null ? !((Object)intType).equals(internalType4) : internalType4 != null)) {
                    Integer n;
                    Statistics<?> statistics = stat;
                    if (statistics instanceof IntStatistics) {
                        IntStatistics intStatistics = (IntStatistics)statistics;
                        n = isMax ? BoxesRunTime.boxToInteger((int)intStatistics.getMax()) : BoxesRunTime.boxToInteger((int)intStatistics.getMin());
                    } else {
                        n = null;
                    }
                    comparable = n;
                } else {
                    LongType longType = DataTypes.LONG;
                    InternalType internalType5 = internalType;
                    if (!(longType != null ? !((Object)longType).equals(internalType5) : internalType5 != null)) {
                        Long l;
                        Statistics<?> statistics = stat;
                        if (statistics instanceof LongStatistics) {
                            LongStatistics longStatistics = (LongStatistics)statistics;
                            l = isMax ? BoxesRunTime.boxToLong((long)longStatistics.getMax()) : BoxesRunTime.boxToLong((long)longStatistics.getMin());
                        } else {
                            l = null;
                        }
                        comparable = l;
                    } else {
                        DoubleType doubleType = DataTypes.DOUBLE;
                        InternalType internalType6 = internalType;
                        if (!(doubleType != null ? !((Object)doubleType).equals(internalType6) : internalType6 != null)) {
                            Double d;
                            Statistics<?> statistics = stat;
                            if (statistics instanceof DoubleStatistics) {
                                DoubleStatistics doubleStatistics = (DoubleStatistics)statistics;
                                d = isMax ? BoxesRunTime.boxToDouble((double)doubleStatistics.getMax()) : BoxesRunTime.boxToDouble((double)doubleStatistics.getMin());
                            } else {
                                d = null;
                            }
                            comparable = d;
                        } else if (internalType instanceof DecimalType) {
                            BigDecimal bigDecimal;
                            Statistics<?> statistics = stat;
                            if (statistics instanceof FloatStatistics) {
                                FloatStatistics floatStatistics = (FloatStatistics)statistics;
                                bigDecimal = BigDecimal.valueOf(isMax ? floatStatistics.getMax() : floatStatistics.getMin());
                            } else if (statistics instanceof IntStatistics) {
                                IntStatistics intStatistics = (IntStatistics)statistics;
                                bigDecimal = BigDecimal.valueOf(isMax ? intStatistics.getMax() : intStatistics.getMin());
                            } else if (statistics instanceof LongStatistics) {
                                LongStatistics longStatistics = (LongStatistics)statistics;
                                bigDecimal = BigDecimal.valueOf(isMax ? longStatistics.getMax() : longStatistics.getMin());
                            } else if (statistics instanceof DoubleStatistics) {
                                DoubleStatistics doubleStatistics = (DoubleStatistics)statistics;
                                bigDecimal = BigDecimal.valueOf(isMax ? doubleStatistics.getMax() : doubleStatistics.getMin());
                            } else {
                                bigDecimal = null;
                            }
                            comparable = bigDecimal;
                        } else {
                            StringType stringType = DataTypes.STRING;
                            InternalType internalType7 = internalType;
                            if (!(stringType != null ? !((Object)stringType).equals(internalType7) : internalType7 != null)) {
                                String string;
                                Statistics<?> statistics = stat;
                                if (statistics instanceof BinaryStatistics) {
                                    BinaryStatistics binaryStatistics = (BinaryStatistics)statistics;
                                    Binary v = isMax ? binaryStatistics.genericGetMax() : binaryStatistics.genericGetMin();
                                    string = v == null ? null : v.toStringUsingUTF8();
                                } else {
                                    string = null;
                                }
                                comparable = string;
                            } else {
                                DateType dateType = DataTypes.DATE;
                                InternalType internalType8 = internalType;
                                if (!(dateType != null ? !((Object)dateType).equals(internalType8) : internalType8 != null)) {
                                    Date date;
                                    Statistics<?> statistics = stat;
                                    if (statistics instanceof IntStatistics) {
                                        IntStatistics intStatistics = (IntStatistics)statistics;
                                        int v = isMax ? intStatistics.getMax() : intStatistics.getMin();
                                        date = BuildInScalarFunctions.internalToDate(v);
                                    } else {
                                        date = null;
                                    }
                                    comparable = date;
                                } else {
                                    TimeType timeType = DataTypes.TIME;
                                    InternalType internalType9 = internalType;
                                    if (!(timeType != null ? !((Object)timeType).equals(internalType9) : internalType9 != null)) {
                                        Time time;
                                        Statistics<?> statistics = stat;
                                        if (statistics instanceof IntStatistics) {
                                            IntStatistics intStatistics = (IntStatistics)statistics;
                                            int v = isMax ? intStatistics.getMax() : intStatistics.getMin();
                                            time = BuildInScalarFunctions.internalToTime(v);
                                        } else {
                                            time = null;
                                        }
                                        comparable = time;
                                    } else {
                                        TimestampType timestampType = DataTypes.TIMESTAMP;
                                        InternalType internalType10 = internalType;
                                        if (!(timestampType != null ? !((Object)timestampType).equals(internalType10) : internalType10 != null)) {
                                            Timestamp timestamp;
                                            Statistics<?> statistics = stat;
                                            if (statistics instanceof LongStatistics) {
                                                LongStatistics longStatistics = (LongStatistics)statistics;
                                                timestamp = new Timestamp(isMax ? longStatistics.getMax() : longStatistics.getMin());
                                            } else if (statistics instanceof BinaryStatistics) {
                                                Timestamp timestamp2;
                                                Binary v;
                                                BinaryStatistics binaryStatistics = (BinaryStatistics)statistics;
                                                Binary binary = v = isMax ? binaryStatistics.genericGetMax() : binaryStatistics.genericGetMin();
                                                if (v == null) {
                                                    timestamp2 = null;
                                                } else {
                                                    NanoTime nt = NanoTime.fromBinary((Binary)v);
                                                    long ts = DateTimeUtils.julianDayToTimestamp(nt.getJulianDay(), nt.getTimeOfDayNanos());
                                                    timestamp2 = new Timestamp(ts);
                                                }
                                                timestamp = timestamp2;
                                            } else {
                                                timestamp = null;
                                            }
                                            comparable = timestamp;
                                        } else {
                                            comparable = null;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return comparable;
    }

    public Tuple2<Long, java.util.Map<String, Statistics<?>>> org$apache$flink$table$sources$parquet$ParquetTableStatsCollector$$getStatisticsOfFile(FileStatus fileStatus, String[] fieldNames, Configuration hadoopConf, Option<FilterPredicate> filter) {
        List list;
        ParquetMetadata metadata = ParquetFileReader.readFooter((Configuration)hadoopConf, (org.apache.hadoop.fs.Path)new org.apache.hadoop.fs.Path(fileStatus.getPath().toUri()), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        MessageType schema2 = metadata.getFileMetaData().getSchema();
        scala.collection.immutable.Map nameToIndexMap = ((TraversableOnce)((IterableLike)JavaConversions$.MODULE$.asScalaBuffer(schema2.asGroupType().getFields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Type x$3) {
                return x$3.getName();
            }
        }, Buffer$.MODULE$.canBuildFrom())).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ObjectRef rowCount = ObjectRef.create((Object)Predef$.MODULE$.long2Long(0L));
        HashMap statsMap = new HashMap();
        List originBlocks = metadata.getBlocks();
        Option<FilterPredicate> option = filter;
        if (option instanceof Some) {
            Some some = (Some)option;
            FilterPredicate f = (FilterPredicate)some.x();
            list = RowGroupFilter.filterRowGroups((FilterCompat.Filter)FilterCompat.get((FilterPredicate)f), (List)originBlocks, (MessageType)schema2);
        } else {
            list = originBlocks;
        }
        List filteredBlocks = list;
        JavaConversions$.MODULE$.asScalaBuffer(filteredBlocks).foreach((Function1)new Serializable(fieldNames, nameToIndexMap, rowCount, statsMap){
            public static final long serialVersionUID = 0L;
            private final String[] fieldNames$4;
            public final scala.collection.immutable.Map nameToIndexMap$1;
            private final ObjectRef rowCount$1;
            public final HashMap statsMap$1;

            public final void apply(BlockMetaData b) {
                this.rowCount$1.elem = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long((Long)this.rowCount$1.elem) + b.getRowCount());
                Predef$.MODULE$.refArrayOps((Object[])this.fieldNames$4).foreach((Function1)new Serializable(this, b){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$org$apache$flink$table$sources$parquet$ParquetTableStatsCollector$$getStatisticsOfFile$1 $outer;
                    private final BlockMetaData b$1;

                    public final void apply(String n) {
                        int i = BoxesRunTime.unboxToInt((Object)this.$outer.nameToIndexMap$1.getOrElse((Object)n, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return -1;
                            }
                        }));
                        if (i >= 0) {
                            ParquetTableStatsCollector$.MODULE$.org$apache$flink$table$sources$parquet$ParquetTableStatsCollector$$updateStatistics(((ColumnChunkMetaData)this.b$1.getColumns().get(i)).getStatistics(), n, this.$outer.statsMap$1);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.b$1 = b$1;
                    }
                });
            }
            {
                this.fieldNames$4 = fieldNames$4;
                this.nameToIndexMap$1 = nameToIndexMap$1;
                this.rowCount$1 = rowCount$1;
                this.statsMap$1 = statsMap$1;
            }
        });
        return new Tuple2((Object)((Long)rowCount.elem), statsMap);
    }

    public void org$apache$flink$table$sources$parquet$ParquetTableStatsCollector$$updateStatistics(Statistics<?> newStats, String fieldName, java.util.Map<String, Statistics<?>> statsMap) {
        Statistics<?> statistics;
        block9: {
            block3: {
                Statistics<?> oldStats;
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        oldStats = statsMap.get(fieldName);
                                        if (oldStats != null) break block2;
                                        statsMap.put(fieldName, newStats);
                                        break block3;
                                    }
                                    statistics = newStats;
                                    if (!(statistics instanceof BooleanStatistics)) break block4;
                                    BooleanStatistics booleanStatistics = (BooleanStatistics)statistics;
                                    ((BooleanStatistics)oldStats).mergeStatistics((Statistics)booleanStatistics);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(statistics instanceof FloatStatistics)) break block5;
                                FloatStatistics floatStatistics = (FloatStatistics)statistics;
                                ((FloatStatistics)oldStats).mergeStatistics((Statistics)floatStatistics);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!(statistics instanceof IntStatistics)) break block6;
                            IntStatistics intStatistics = (IntStatistics)statistics;
                            ((IntStatistics)oldStats).mergeStatistics((Statistics)intStatistics);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(statistics instanceof LongStatistics)) break block7;
                        LongStatistics longStatistics = (LongStatistics)statistics;
                        ((LongStatistics)oldStats).mergeStatistics((Statistics)longStatistics);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(statistics instanceof DoubleStatistics)) break block8;
                    DoubleStatistics doubleStatistics = (DoubleStatistics)statistics;
                    ((DoubleStatistics)oldStats).mergeStatistics((Statistics)doubleStatistics);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(statistics instanceof BinaryStatistics)) break block9;
                BinaryStatistics binaryStatistics = (BinaryStatistics)statistics;
                ((BinaryStatistics)oldStats).mergeStatistics((Statistics)binaryStatistics);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(statistics);
    }

    private List<FileStatus> listFileStatus(Path filePath, boolean nestedFileEnumeration, String[] fieldNames, InternalType[] fieldTypes2) {
        ParquetInputFormat<Object, Object> inputFormat = new ParquetInputFormat<Object, Object>(filePath, nestedFileEnumeration, fieldNames, fieldTypes2){
            public final boolean nestedFileEnumeration$1;

            public Object convert(Object r) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void listFileStatus(Path path, List<FileStatus> files) throws IOException {
                FileSystem fs = path.getFileSystem();
                Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path)).foreach((Function1)new Serializable(this, files){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;
                    private final List files$1;

                    public final Object apply(FileStatus s) {
                        Object object;
                        if (s.isDir()) {
                            if (this.$outer.acceptFile(s) && this.$outer.nestedFileEnumeration$1) {
                                this.$outer.listFileStatus(s.getPath(), this.files$1);
                                object = BoxedUnit.UNIT;
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                        } else {
                            object = this.$outer.acceptFile(s) ? BoxesRunTime.boxToBoolean((boolean)this.files$1.add(s)) : BoxedUnit.UNIT;
                        }
                        return object;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.files$1 = files$1;
                    }
                });
            }
            {
                this.nestedFileEnumeration$1 = nestedFileEnumeration$1;
                super(filePath$1, fieldTypes$2, fieldNames$2);
            }
        };
        ArrayList<FileStatus> files = new ArrayList<FileStatus>();
        ParquetInputFormat<Object, Object> qual1 = inputFormat;
        try {
            ParquetTableStatsCollector$.reflMethod$Method1(qual1.getClass()).invoke((Object)qual1, filePath, files);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        return files;
    }

    private ParquetTableStatsCollector$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.defaultTimeout = 60000;
        this.timeoutTimeUnit = TimeUnit.MILLISECONDS;
    }
}

