/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import java.io.IOException;
import org.apache.flink.table.dataformat.ColumnarRow;
import org.apache.flink.table.sources.parquet.ParquetVectorizedReader;
import org.apache.flink.table.types.InternalType;

public class ParquetVectorizedColumnRowReader
extends ParquetVectorizedReader {
    protected int rowIdx = -1;
    protected int batchSize = 0;
    protected long limit;
    protected long currentConsumeRowCount;
    protected ColumnarRow columnarRow = new ColumnarRow();

    public ParquetVectorizedColumnRowReader(InternalType[] fieldTypes2, String[] fieldNames, long limit) {
        super(fieldTypes2, fieldNames);
        this.limit = limit;
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.currentConsumeRowCount >= this.limit) {
            return false;
        }
        ++this.currentConsumeRowCount;
        ++this.rowIdx;
        if (this.rowIdx >= this.batchSize) {
            if (!this.nextBatch()) {
                return false;
            }
            this.batchSize = this.columnarBatch.getNumRows();
            this.rowIdx = 0;
            this.columnarRow.setVectorizedColumnBatch(this.columnarBatch);
        }
        return true;
    }

    @Override
    public Object getCurrentValue() throws IOException, InterruptedException {
        this.columnarRow.setRowId(this.rowIdx);
        return this.columnarRow;
    }
}

