/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import java.util.Arrays;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.dataformat.vector.VectorizedColumnBatch;

public class VectorizedColumnBatchTypeInfo
extends TypeInformation<VectorizedColumnBatch> {
    private static final long serialVersionUID = -666939301459922848L;
    private final TypeInformation<?>[] types;
    private final int totalFields;
    private final String[] filedNames;

    public VectorizedColumnBatchTypeInfo(String[] filedNames, TypeInformation<?> ... types) {
        this.types = types;
        this.filedNames = filedNames;
        int fieldCounter = 0;
        for (TypeInformation<?> type : types) {
            fieldCounter += type.getTotalFields();
        }
        this.totalFields = fieldCounter;
    }

    public TypeInformation<?>[] getTypes() {
        return this.types;
    }

    public String[] getFiledNames() {
        return this.filedNames;
    }

    @Override
    public boolean isSortKeyType() {
        return false;
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return this.types.length;
    }

    @Override
    public int getTotalFields() {
        return this.totalFields;
    }

    @Override
    public Class<VectorizedColumnBatch> getTypeClass() {
        return VectorizedColumnBatch.class;
    }

    @Override
    public boolean isKeyType() {
        return false;
    }

    @Override
    public TypeSerializer<VectorizedColumnBatch> createSerializer(ExecutionConfig executionConfig) {
        throw new UnsupportedOperationException("Unsupported now!");
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof VectorizedColumnBatchTypeInfo;
    }

    @Override
    public String toString() {
        return "VectorizedColumnBatchTypeInfo{types=" + Arrays.toString(this.types) + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VectorizedColumnBatchTypeInfo)) {
            return false;
        }
        VectorizedColumnBatchTypeInfo that = (VectorizedColumnBatchTypeInfo)o;
        return Arrays.equals(this.types, that.types);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.types);
    }
}

