/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.dataformat.ColumnarRow;
import org.apache.flink.table.sources.parquet.ParquetInputFormat;
import org.apache.flink.table.sources.parquet.ParquetVectorizedColumnRowReader;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.TypeConverters;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.parquet.filter2.predicate.FilterPredicate;

public class VectorizedColumnRowInputParquetFormat
extends ParquetInputFormat<ColumnarRow, ColumnarRow>
implements ResultTypeQueryable<ColumnarRow> {
    private static final long serialVersionUID = -2569974518641072883L;
    protected final long limit;

    public VectorizedColumnRowInputParquetFormat(Path filePath, InternalType[] fieldTypes2, String[] fieldNames, long limit) {
        super(filePath, fieldTypes2, fieldNames);
        this.limit = limit;
    }

    @Override
    protected RecordReader createReader(FilterPredicate filter) {
        return new ParquetVectorizedColumnRowReader(this.fieldTypes, this.fieldNames, this.limit);
    }

    @Override
    public TypeInformation<ColumnarRow> getProducedType() {
        return new BaseRowTypeInfo(TypeConverters.createExternalTypeInfoFromDataTypes(this.fieldTypes));
    }

    @Override
    protected ColumnarRow convert(ColumnarRow current) {
        return current;
    }
}

