/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.sources.parquet.ParquetInputFormat;
import org.apache.flink.table.sources.parquet.ParquetVectorizedGenericRowReader;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.TypeConverters;
import org.apache.flink.table.typeutils.BaseRowSerializer;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.parquet.filter2.predicate.FilterPredicate;

public class VectorizedGenericRowInputParquetFormat
extends ParquetInputFormat<GenericRow, GenericRow>
implements ResultTypeQueryable<GenericRow> {
    private static final long serialVersionUID = -2569974518641072883L;
    private BaseRowSerializer<BaseRow> serializer;
    private transient GenericRow reuse;

    public VectorizedGenericRowInputParquetFormat(Path filePath, InternalType[] fieldTypes2, String[] fieldNames) {
        super(filePath, fieldTypes2, fieldNames);
        this.serializer = new BaseRowSerializer(fieldTypes2);
    }

    @Override
    protected RecordReader createReader(FilterPredicate filter) {
        return new ParquetVectorizedGenericRowReader(this.fieldTypes, this.fieldNames);
    }

    @Override
    public TypeInformation<GenericRow> getProducedType() {
        return new BaseRowTypeInfo(TypeConverters.createExternalTypeInfoFromDataTypes(this.fieldTypes));
    }

    @Override
    protected GenericRow convert(GenericRow current) {
        if (this.reuse == null) {
            return (GenericRow)this.serializer.copy(current);
        }
        for (int i = 0; i < current.getArity(); ++i) {
            this.reuse.update(i, current.getField(i));
        }
        return this.reuse;
    }
}

