/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.core.memory.MemoryUtils;
import org.apache.flink.table.dataformat.vector.BooleanColumnVector;
import org.apache.flink.table.dataformat.vector.ByteColumnVector;
import org.apache.flink.table.dataformat.vector.BytesColumnVector;
import org.apache.flink.table.dataformat.vector.DoubleColumnVector;
import org.apache.flink.table.dataformat.vector.FloatColumnVector;
import org.apache.flink.table.dataformat.vector.IntegerColumnVector;
import org.apache.flink.table.dataformat.vector.LongColumnVector;
import org.apache.flink.table.sources.parquet.VectorizedValuesReader;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.io.api.Binary;
import sun.misc.Unsafe;

public class VectorizedPlainValuesReader
extends ValuesReader
implements VectorizedValuesReader {
    private static final Unsafe UNSAFE = MemoryUtils.UNSAFE;
    private static final int BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    private static final ByteOrder NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();
    private static final boolean BIG_ENDIAN_PLATFORM = NATIVE_BYTE_ORDER.equals(ByteOrder.BIG_ENDIAN);
    private static final int DOUBLE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(double[].class);
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    private byte[] buffer;
    private int offset;
    private int bitOffset;
    private ByteBuffer byteBuffer;

    public void initFromPage(int valueCount, byte[] bytes, int offset) throws IOException {
        this.buffer = bytes;
        this.offset = offset + BYTE_ARRAY_OFFSET;
        if (BIG_ENDIAN_PLATFORM) {
            this.byteBuffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    public void skip() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void readIntegers(int total, IntegerColumnVector c, int rowId) {
        int i = 0;
        while (i < total) {
            c.vector[i + rowId] = UNSAFE.getInt(this.buffer, this.offset);
            if (BIG_ENDIAN_PLATFORM) {
                c.vector[i + rowId] = Integer.reverseBytes(c.vector[i + rowId]);
            }
            ++i;
            this.offset += 4;
        }
    }

    @Override
    public void readLongs(int total, LongColumnVector c, int rowId) {
        int i = 0;
        while (i < total) {
            c.vector[i + rowId] = UNSAFE.getLong(this.buffer, this.offset);
            if (BIG_ENDIAN_PLATFORM) {
                c.vector[i + rowId] = Long.reverseBytes(c.vector[i + rowId]);
            }
            ++i;
            this.offset += 8;
        }
    }

    @Override
    public final long readLong() {
        long v = UNSAFE.getLong(this.buffer, this.offset);
        if (BIG_ENDIAN_PLATFORM) {
            v = Long.reverseBytes(v);
        }
        this.offset += 8;
        return v;
    }

    @Override
    public void readFloats(int total, FloatColumnVector c, int rowId) {
        if (!BIG_ENDIAN_PLATFORM) {
            this.copyMemory(this.buffer, this.offset, c.vector, DOUBLE_ARRAY_OFFSET + rowId * 4, total * 4);
        } else {
            ByteBuffer bb = ByteBuffer.wrap(this.buffer).order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < total; ++i) {
                c.vector[i + rowId] = bb.getFloat(this.offset - BYTE_ARRAY_OFFSET + 4 * i);
            }
        }
        this.offset += 4 * total;
    }

    @Override
    public final float readFloat() {
        float v = !BIG_ENDIAN_PLATFORM ? UNSAFE.getFloat(this.buffer, this.offset) : this.byteBuffer.getFloat(this.offset - BYTE_ARRAY_OFFSET);
        this.offset += 4;
        return v;
    }

    @Override
    public void readDoubles(int total, DoubleColumnVector c, int rowId) {
        if (!BIG_ENDIAN_PLATFORM) {
            this.copyMemory(this.buffer, this.offset, c.vector, DOUBLE_ARRAY_OFFSET + rowId * 8, total * 8);
        } else {
            ByteBuffer bb = ByteBuffer.wrap(this.buffer).order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < total; ++i) {
                c.vector[i + rowId] = bb.getDouble(this.offset - BYTE_ARRAY_OFFSET + 8 * i);
            }
        }
        this.offset += 8 * total;
    }

    @Override
    public byte readByte() {
        return (byte)this.readInteger();
    }

    @Override
    public final int readInteger() {
        int v = UNSAFE.getInt(this.buffer, this.offset);
        if (BIG_ENDIAN_PLATFORM) {
            v = Integer.reverseBytes(v);
        }
        this.offset += 4;
        return v;
    }

    @Override
    public final double readDouble() {
        double v = !BIG_ENDIAN_PLATFORM ? UNSAFE.getDouble(this.buffer, this.offset) : this.byteBuffer.getDouble(this.offset - BYTE_ARRAY_OFFSET);
        this.offset += 8;
        return v;
    }

    @Override
    public void readBooleans(int total, BooleanColumnVector c, int rowId) {
        for (int i = 0; i < total; ++i) {
            c.vector[rowId + i] = this.readBoolean();
        }
    }

    @Override
    public final boolean readBoolean() {
        byte b = UNSAFE.getByte(this.buffer, this.offset);
        boolean v = (b & 1 << this.bitOffset) != 0;
        ++this.bitOffset;
        if (this.bitOffset == 8) {
            this.bitOffset = 0;
            ++this.offset;
        }
        return v;
    }

    @Override
    public final void readBinaries(int total, BytesColumnVector v, int rowId) {
        for (int i = 0; i < total; ++i) {
            int len = this.readInteger();
            v.setVal(rowId + i, this.buffer, this.offset - BYTE_ARRAY_OFFSET, len);
            this.offset += len;
        }
    }

    @Override
    public final Binary readBinary(int len) {
        Binary result = Binary.fromConstantByteArray((byte[])this.buffer, (int)(this.offset - BYTE_ARRAY_OFFSET), (int)len);
        this.offset += len;
        return result;
    }

    @Override
    public final void readBytes(int total, ByteColumnVector c, int rowId) {
        for (int i = 0; i < total; ++i) {
            c.vector[rowId + i] = UNSAFE.getByte(this.buffer, this.offset);
            this.offset += 4;
        }
    }

    private void copyMemory(Object src, long srcOffset, Object dst, long dstOffset, long length) {
        while (length > 0L) {
            long size = Math.min(length, 0x100000L);
            UNSAFE.copyMemory(src, srcOffset, dst, dstOffset, size);
            length -= size;
            srcOffset += size;
            dstOffset += size;
        }
    }
}

