/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet.update;

import java.io.IOException;
import java.util.BitSet;
import org.apache.flink.table.api.VirtualColumn;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.sources.parquet.ParquetVectorizedColumnRowReader;
import org.apache.flink.table.sources.parquet.update.ActualColumnarRow;
import org.apache.flink.table.sources.parquet.update.VirtualColumnarRow;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.InternalType;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.hadoop.ParquetInputSplit;

public class UpdateParquetVectorizedColumnRowReader
extends ParquetVectorizedColumnRowReader {
    private BitSet deleteBitSet = null;
    private int rowIdIndex = -1;
    private boolean isDeleteSource;

    public UpdateParquetVectorizedColumnRowReader(InternalType[] fieldTypes2, String[] fieldNames, long limit, boolean isDeleteSource) {
        super(fieldTypes2, fieldNames, limit);
        for (int i = 0; i < fieldNames.length; ++i) {
            if (!fieldNames[i].equals(VirtualColumn.ROWID.getName())) continue;
            this.rowIdIndex = i;
        }
        this.isDeleteSource = isDeleteSource;
        this.columnarRow = isDeleteSource ? new VirtualColumnarRow() : new ActualColumnarRow();
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        super.initialize(inputSplit, taskAttemptContext);
        ParquetInputSplit parquetInputSplit = (ParquetInputSplit)inputSplit;
        this.loadDeleteFiles(parquetInputSplit.getPath(), taskAttemptContext);
        if (this.isDeleteSource) {
            ((VirtualColumnarRow)this.columnarRow).setFileName(parquetInputSplit.getPath().toString());
        }
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.currentConsumeRowCount >= this.limit) {
            return false;
        }
        ++this.currentConsumeRowCount;
        do {
            ++this.rowIdx;
            if (this.rowIdx >= this.batchSize) {
                if (!this.nextBatch()) {
                    return false;
                }
                this.batchSize = this.columnarBatch.getNumRows();
                this.rowIdx = 0;
                this.columnarRow.setVectorizedColumnBatch(this.columnarBatch);
            }
            this.columnarRow.setRowId(this.rowIdx);
        } while (this.deleteBitSet != null && this.deleteBitSet.get(this.columnarRow.getInt(this.rowIdIndex)));
        return true;
    }

    private void loadDeleteFiles(Path file, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.deleteBitSet = new BitSet();
        Path deleteDirPath = file.suffix("_delete");
        FileSystem fs = file.getFileSystem(taskAttemptContext.getConfiguration());
        if (!fs.isDirectory(deleteDirPath)) {
            return;
        }
        FileStatus[] deleteDirStatuses = fs.listStatus(deleteDirPath);
        if (deleteDirStatuses == null) {
            return;
        }
        this.deleteBitSet = new BitSet();
        for (FileStatus deleteDirStatus : deleteDirStatuses) {
            FileStatus[] deleteFileStatuses = fs.listStatus(deleteDirStatus.getPath());
            if (deleteFileStatuses == null) {
                return;
            }
            for (FileStatus deleteFileStatus : deleteFileStatuses) {
                Path deletePath = deleteFileStatus.getPath();
                ParquetVectorizedColumnRowReader reader = new ParquetVectorizedColumnRowReader(new InternalType[]{DataTypes.INT}, new String[]{VirtualColumn.ROWID.getName()}, Long.MAX_VALUE);
                ParquetInputSplit split = new ParquetInputSplit(new Path(deletePath.toUri()), 0L, deleteFileStatus.getLen(), deleteFileStatus.getLen(), null, null);
                reader.initialize((InputSplit)split, taskAttemptContext);
                while (reader.nextKeyValue()) {
                    int id = ((BaseRow)reader.getCurrentValue()).getInt(0);
                    this.deleteBitSet.set(id);
                }
                reader.close();
            }
        }
    }
}

