/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet.update;

import java.util.ArrayList;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.VirtualColumn;
import org.apache.flink.table.sources.parquet.VectorizedColumnRowInputParquetFormat;
import org.apache.flink.table.sources.parquet.update.UpdateParquetVectorizedColumnRowReader;
import org.apache.flink.table.types.InternalType;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.parquet.filter2.predicate.FilterPredicate;

public class UpdateVectorizedColumnRowInputParquetFormat
extends VectorizedColumnRowInputParquetFormat {
    public UpdateVectorizedColumnRowInputParquetFormat(Path filePath, InternalType[] fieldTypes2, String[] fieldNames, long limit) {
        super(filePath, fieldTypes2, fieldNames, limit);
    }

    @Override
    protected RecordReader createReader(FilterPredicate filter) {
        ArrayList<String> filterNames = new ArrayList<String>();
        ArrayList<InternalType> filterTypes = new ArrayList<InternalType>();
        boolean isDeleteSource = false;
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (!this.fieldNames[i].equals(VirtualColumn.FILENAME.getName())) {
                filterNames.add(this.fieldNames[i]);
                filterTypes.add(this.fieldTypes[i]);
                continue;
            }
            isDeleteSource = true;
        }
        if (!isDeleteSource) {
            filterNames.add(VirtualColumn.ROWID.getName());
            filterTypes.add(VirtualColumn.ROWID.getInternalType());
        }
        return new UpdateParquetVectorizedColumnRowReader(filterTypes.toArray(new InternalType[0]), filterNames.toArray(new String[0]), this.limit, isDeleteSource);
    }

    @Override
    public boolean acceptFile(FileStatus fileStatus) {
        return super.acceptFile(fileStatus) && !fileStatus.getPath().getName().endsWith("_delete");
    }
}

