/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.temptable;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Inet4Address;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockShuffleService;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockShuffleServiceOptions;
import org.apache.flink.service.ServiceInstance;
import org.apache.flink.service.UserDefinedService;
import org.apache.flink.table.temptable.DefaultExternalResultPartitionResolver;
import org.apache.flink.table.temptable.TableServiceImpl;
import org.apache.flink.table.temptable.TableServiceOptions;
import org.apache.flink.table.temptable.rpc.TableServiceServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkTableService
extends UserDefinedService {
    private static final Logger logger = LoggerFactory.getLogger(FlinkTableService.class);
    private TableServiceServer server;
    private String serviceIP;
    private int servicePort = -1;
    private TableServiceImpl manager;
    private String tableServiceId;
    private ExternalBlockShuffleService shuffleService;
    private String registryIP;
    private int registryPort;

    @Override
    public void open(Configuration config) throws Exception {
        this.tableServiceId = config.getString(TableServiceOptions.TABLE_SERVICE_ID);
        this.registryIP = config.getString(TableServiceOptions.TABLE_SERVICE_REGISTRY_ADDRESS);
        this.registryPort = config.getInteger(TableServiceOptions.TABLE_SERVICE_REGISTRY_PORT);
        config.setString(ExternalBlockShuffleServiceOptions.LOCAL_RESULT_PARTITION_RESOLVER_CLASS, DefaultExternalResultPartitionResolver.class.getCanonicalName());
        String rootPath = config.getString(TableServiceOptions.TABLE_SERVICE_STORAGE_ROOT_PATH, System.getProperty("user.dir"));
        String storagePath = rootPath + File.separator + "tableservice_" + this.tableServiceId + File.separator;
        config.setString(ExternalBlockShuffleServiceOptions.LOCAL_DIRS, storagePath);
        logger.info("start table service with id:" + this.tableServiceId);
        this.manager = new TableServiceImpl(this.getServiceContext());
        this.manager.open(config);
        this.setUpServer();
        this.addInstance();
        this.shuffleService = new ExternalBlockShuffleService(config);
    }

    @Override
    public void close() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        if (this.shuffleService != null) {
            this.shuffleService.stop();
        }
        this.manager.close();
    }

    private void setUpServer() {
        logger.info("begin set up table service.");
        try {
            this.serviceIP = Inet4Address.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2);
        }
        this.server = new TableServiceServer();
        this.server.setTableService(this.manager);
        try {
            this.servicePort = this.server.bind();
        }
        catch (Exception e3) {
            logger.error("start server fail.", (Throwable)e3);
            throw new RuntimeException(e3);
        }
        logger.info("end set up table service.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstance() {
        int instanceId = this.getServiceContext().getIndexOfCurrentInstance();
        ServiceInstance serviceInstance = new ServiceInstance(instanceId, this.serviceIP, this.servicePort);
        Socket socket = null;
        ObjectOutputStream outputStream = null;
        try {
            socket = new Socket(this.registryIP, this.registryPort);
            outputStream = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            outputStream.writeObject(serviceInstance);
            outputStream.flush();
        }
        catch (IOException e2) {
            logger.error("add instance fails", (Throwable)e2);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e3) {
                    logger.error(e3.getMessage(), (Throwable)e3);
                    throw new RuntimeException(e3);
                }
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e4) {
                    logger.error(e4.getMessage(), (Throwable)e4);
                    throw new RuntimeException(e4);
                }
            }
        }
        logger.info("add Instance success");
    }

    @Override
    public void start() {
        try {
            this.shuffleService.start();
        }
        catch (IOException e2) {
            logger.error("error occurs while start shuffle service: " + e2);
            throw new RuntimeException("ShuffleService start fails");
        }
        logger.info("TableService begin serving");
        try {
            this.server.start();
        }
        catch (Exception e3) {
            logger.error("error occurs while serving: " + e3);
        }
        logger.error("TableService end serving");
        throw new RuntimeException("TableService stops.");
    }
}

