/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.temptable;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.service.ServiceDescriptor;
import org.apache.flink.service.ServiceInstance;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.plan.CacheAwareRelNodePlanBuilder;
import org.apache.flink.table.plan.logical.LogicalNode;
import org.apache.flink.table.plan.logical.SinkNode;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.temptable.FlinkTableServiceManager$;
import org.apache.flink.table.temptable.TableServiceOptions;
import org.apache.flink.table.temptable.rpc.TableServiceClient;
import org.apache.flink.table.temptable.rpc.TableServiceRegistry;
import org.apache.flink.table.temptable.util.TableServiceUtil;
import org.apache.flink.table.util.TableProperties;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.MutableList;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001B\u0001\u0003\u00015\u0011\u0001D\u00127j].$\u0016M\u00197f'\u0016\u0014h/[2f\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0005uK6\u0004H/\u00192mK*\u0011QAB\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u000f!\tQA\u001a7j].T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\"AQ\u0003\u0001B\u0001B\u0003%a#\u0001\u0003u\u000b:4\bCA\f\u001b\u001b\u0005A\"BA\r\u0005\u0003\r\t\u0007/[\u0005\u00037a\u0011\u0001\u0003V1cY\u0016,eN^5s_:lWM\u001c;\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\ty\u0012\u0005\u0005\u0002!\u00015\t!\u0001C\u0003\u00169\u0001\u0007a\u0003C\u0004$\u0001\t\u0007I\u0011\u0002\u0013\u0002!Q|')Z\"bG\",G\rV1cY\u0016\u001cX#A\u0013\u0011\t\u0019ZS&N\u0007\u0002O)\u0011\u0001&K\u0001\u0005kRLGNC\u0001+\u0003\u0011Q\u0017M^1\n\u00051:#aD%eK:$\u0018\u000e^=ICNDW*\u00199\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003e\u0011\tA\u0001\u001d7b]&\u0011Ag\f\u0002\f\u0019><\u0017nY1m\u001d>$W\r\u0005\u00027s9\u0011qbN\u0005\u0003qA\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\u0019\u0019FO]5oO*\u0011\u0001\b\u0005\u0005\u0007{\u0001\u0001\u000b\u0011B\u0013\u0002#Q|')Z\"bG\",G\rV1cY\u0016\u001c\b\u0005\u0003\u0005@\u0001\t\u0007I\u0011\u0001\u0004%\u00031\u0019\u0017m\u00195fIR\u000b'\r\\3t\u0011\u0019\t\u0005\u0001)A\u0005K\u0005i1-Y2iK\u0012$\u0016M\u00197fg\u0002B\u0001b\u0011\u0001A\u0002\u0013\u0005a\u0001R\u0001\u0014i\u0006\u0014G.Z*feZL7-Z*uCJ$X\rZ\u000b\u0002\u000bB\u0011qBR\u0005\u0003\u000fB\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005J\u0001\u0001\u0007I\u0011\u0001\u0004K\u0003]!\u0018M\u00197f'\u0016\u0014h/[2f'R\f'\u000f^3e?\u0012*\u0017\u000f\u0006\u0002L\u001dB\u0011q\u0002T\u0005\u0003\u001bB\u0011A!\u00168ji\"9q\nSA\u0001\u0002\u0004)\u0015a\u0001=%c!1\u0011\u000b\u0001Q!\n\u0015\u000bA\u0003^1cY\u0016\u001cVM\u001d<jG\u0016\u001cF/\u0019:uK\u0012\u0004\u0003BC*\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0007)\u0006a1/\u001e2nSR\u0014Vm];miV\tQ\u000b\u0005\u0002W56\tqK\u0003\u0002Y3\u000611m\\7n_:T!!\u0007\u0004\n\u0005m;&a\u0005&pEN+(-\\5tg&|gNU3tk2$\bBC/\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0007=\u0006\u00012/\u001e2nSR\u0014Vm];mi~#S-\u001d\u000b\u0003\u0017~Cqa\u0014/\u0002\u0002\u0003\u0007Q\u000b\u0003\u0004b\u0001\u0001\u0006K!V\u0001\u000egV\u0014W.\u001b;SKN,H\u000e\u001e\u0011\t\u0013\r\u0004\u0001\u0019!a\u0001\n\u0013!\u0017a\u0004;bE2,7+\u001a:wS\u000e,WI\u001c<\u0016\u0003\u0015\u0004\"A\u001a7\u000e\u0003\u001dT!\u0001[5\u0002\u0017\u0015tg/\u001b:p]6,g\u000e\u001e\u0006\u00033)T!a\u001b\u0004\u0002\u0013M$(/Z1nS:<\u0017BA7h\u0005i\u0019FO]3b[\u0016CXmY;uS>tWI\u001c<je>tW.\u001a8u\u0011%y\u0007\u00011AA\u0002\u0013%\u0001/A\nuC\ndWmU3sm&\u001cW-\u00128w?\u0012*\u0017\u000f\u0006\u0002Lc\"9qJ\\A\u0001\u0002\u0004)\u0007BB:\u0001A\u0003&Q-\u0001\tuC\ndWmU3sm&\u001cW-\u00128wA!AQ\u000f\u0001EC\u0002\u0013%a/\u0001\buC\ndWmU3sm&\u001cW-\u00133\u0016\u0003UB\u0001\u0002\u001f\u0001\t\u0002\u0003\u0006K!N\u0001\u0010i\u0006\u0014G.Z*feZL7-Z%eA!I!\u0010\u0001a\u0001\u0002\u0004%Ia_\u0001\u0015i\u0006\u0014G.Z*feZL7-\u001a*fO&\u001cHO]=\u0016\u0003q\u00042!`A\u0001\u001b\u0005q(BA@\u0003\u0003\r\u0011\boY\u0005\u0004\u0003\u0007q(\u0001\u0006+bE2,7+\u001a:wS\u000e,'+Z4jgR\u0014\u0018\u0010C\u0006\u0002\b\u0001\u0001\r\u00111A\u0005\n\u0005%\u0011\u0001\u0007;bE2,7+\u001a:wS\u000e,'+Z4jgR\u0014\u0018p\u0018\u0013fcR\u00191*a\u0003\t\u0011=\u000b)!!AA\u0002qDq!a\u0004\u0001A\u0003&A0A\u000buC\ndWmU3sm&\u001cWMU3hSN$(/\u001f\u0011\t\u0013\u0005M\u0001A1A\u0005\n\u0005U\u0011A\u0003;ie\u0016\fG\rU8pYV\u0011\u0011q\u0003\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011QD\u0014\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\"\u0005m!aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003/\t1\u0002\u001e5sK\u0006$\u0007k\\8mA!I\u0011\u0011\u0006\u0001C\u0002\u0013%\u00111F\u0001\u000fKb,7-\u001e;f\u0007>tG/\u001a=u+\t\ti\u0003\u0005\u0003\u00020\u0005MRBAA\u0019\u0015\r\ti\u0002E\u0005\u0005\u0003k\t\tD\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\"A\u0011\u0011\b\u0001!\u0002\u0013\ti#A\bfq\u0016\u001cW\u000f^3D_:$X\r\u001f;!\u0011-\ti\u0004\u0001a\u0001\u0002\u0004%I!a\u0010\u0002%Q\f'\r\\3TKJ4\u0018nY3DY&,g\u000e^\u000b\u0003\u0003\u0003\u00022!`A\"\u0013\r\t)E \u0002\u0013)\u0006\u0014G.Z*feZL7-Z\"mS\u0016tG\u000fC\u0006\u0002J\u0001\u0001\r\u00111A\u0005\n\u0005-\u0013A\u0006;bE2,7+\u001a:wS\u000e,7\t\\5f]R|F%Z9\u0015\u0007-\u000bi\u0005C\u0005P\u0003\u000f\n\t\u00111\u0001\u0002B!A\u0011\u0011\u000b\u0001!B\u0013\t\t%A\nuC\ndWmU3sm&\u001cWm\u00117jK:$\b\u0005C\u0004\u0002V\u0001!\t!a\u0016\u0002-\u001d,G\u000fV1cY\u0016\u001cVM\u001d<jG\u00164\u0015m\u0019;pef$\"!!\u0017\u0011\u000b=\tY&a\u0018\n\u0007\u0005u\u0003C\u0001\u0004PaRLwN\u001c\t\u0005\u0003C\n9'\u0004\u0002\u0002d)\u0019\u0011Q\r\u0003\u0002\u0013\u0019\f7\r^8sS\u0016\u001c\u0018\u0002BA5\u0003G\u0012A\u0002V1cY\u00164\u0015m\u0019;pefDq!!\u001c\u0001\t\u0003\ty'\u0001\u0011hKR$\u0016M\u00197f'\u0016\u0014h/[2f\r\u0006\u001cGo\u001c:z!J|\u0007/\u001a:uS\u0016\u001cHCAA9!\u0015y\u00111LA:!\u0011\t)(!\u001f\u000e\u0005\u0005]$B\u0001\u0015\u0005\u0013\u0011\tY(a\u001e\u0003\u001fQ\u000b'\r\\3Qe>\u0004XM\u001d;jKNDq!a \u0001\t\u0003\t\t)A\rhKR$\u0016M\u00197f'\u0016\u0014h/[2f\t\u0016\u001c8M]5qi>\u0014HCAAB!\u0015y\u00111LAC!\u0011\t9)!$\u000e\u0005\u0005%%bAAF\r\u000591/\u001a:wS\u000e,\u0017\u0002BAH\u0003\u0013\u0013\u0011cU3sm&\u001cW\rR3tGJL\u0007\u000f^8s\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+\u000bqcZ3u)\u0006\u0014G.Z*feZL7-Z%ogR\fgnY3\u0015\u0005\u0005]\u0005c\u0002\u0014\u0002\u001a\u0006u\u0015\u0011V\u0005\u0004\u00037;#aA'baB!\u0011qTAS\u001b\t\t\tKC\u0002\u0002$&\nA\u0001\\1oO&!\u0011qUAQ\u0005\u001dIe\u000e^3hKJ\u0004B!a\"\u0002,&!\u0011QVAE\u0005=\u0019VM\u001d<jG\u0016Len\u001d;b]\u000e,\u0007BCAY\u0001\t\u0007I\u0011\u0001\u0004\u00024\u0006\u00012-Y2iKBc\u0017M\u001c\"vS2$WM]\u000b\u0003\u0003k\u0003B!a.\u0002:6\t\u0011'C\u0002\u0002<F\u0012AdQ1dQ\u0016\fu/\u0019:f%\u0016dgj\u001c3f!2\fgNQ;jY\u0012,'\u000f\u0003\u0005\u0002@\u0002\u0001\u000b\u0011BA[\u0003E\u0019\u0017m\u00195f!2\fgNQ;jY\u0012,'\u000f\t\u0005\b\u0003\u0007\u0004A\u0011BAc\u0003)\u0019\u0017m\u00195f)\u0006\u0014G.\u001a\u000b\u0006\u0017\u0006\u001d\u0017q\u001a\u0005\b\u000b\u0005\u0005\u0007\u0019AAe!\r9\u00121Z\u0005\u0004\u0003\u001bD\"!\u0002+bE2,\u0007bBAi\u0003\u0003\u0004\r!N\u0001\ni\u0006\u0014G.Z+V\u0013\u0012Cq!a1\u0001\t\u0003\t)\u000eF\u0002L\u0003/Dq!BAj\u0001\u0004\tI\rC\u0004\u0002\\\u0002!\t!!8\u0002\u001f%tg/\u00197jI\u0006$XmQ1dQ\u0016$2aSAp\u0011\u001d)\u0011\u0011\u001ca\u0001\u0003\u0013Dq!a9\u0001\t\u0013\t)/A\u0006eK2,G/\u001a+bE2,GcA&\u0002h\"9\u0011\u0011[Aq\u0001\u0004)\u0004\u0002CAv\u0001\u0011\u0005!!!<\u0002)Ut'/Z4jgR,'\u000fU1si&$\u0018n\u001c8t)\rY\u0015q\u001e\u0005\b\u000b\u0005%\b\u0019AAe\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003k\fQ#\u001b8wC2LG-\u0019;f\u0007\u0006\u001c\u0007.\u001a3UC\ndW\rF\u0001L\u0011!\tI\u0010\u0001C\u0001\r\u0005U\u0018aE7be.\fE\u000e\u001c+bE2,7oQ1dQ\u0016$\u0007\u0002CA\u007f\u0001\u0011\u0005a!a@\u0002-\u001d,G\u000fV8CK\u000e\u000b7\r[3e)\u0006\u0014G.\u001a(b[\u0016$BA!\u0001\u0003\u0004A!q\"a\u00176\u0011\u001d\u0011)!a?A\u00025\n1\u0002\\8hS\u000e\fG\u000e\u00157b]\"A!\u0011\u0002\u0001\u0005\u0002\u0019\u0011Y!\u0001\nhKR\u001c\u0015m\u00195fIR\u000b'\r\\3OC6,G\u0003\u0002B\u0001\u0005\u001bAqA!\u0002\u0003\b\u0001\u0007Q\u0006C\u0004\u0003\u0012\u0001!\t!!>\u0002)M$\u0018M\u001d;UC\ndWmU3sm&\u001cWMS8c\u0011\u001d\u0011)\u0002\u0001C\u0001\u0005/\t\u0011cZ3u)\u0006\u0014G.Z*feZL7-Z%e)\u0005)\u0004\u0002\u0003B\u000e\u0001\u0011\u0005aA!\b\u0002=M$\u0018M\u001d;UC\ndWmU3sm&\u001cWMS8c\u0013:$XM\u001d8bY2LHcA&\u0003 !A!\u0011\u0005B\r\u0001\u0004\t))\u0001\u0006eKN\u001c'/\u001b9u_JDCA!\u0007\u0003&A!!q\u0005B\u0017\u001b\t\u0011ICC\u0002\u0003,\u0019\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yC!\u000b\u0003#YK7/\u001b2mK\u001a{'\u000fV3ti&tw\rC\u0004\u00034\u0001!\t!!>\u0002\u000b\rdwn]3\t\u000f\t]\u0002\u0001\"\u0003\u0002v\u0006Q\u0011N\\5u\u00072LWM\u001c;")
public class FlinkTableServiceManager {
    public final TableEnvironment org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv;
    private final IdentityHashMap<LogicalNode, String> toBeCachedTables;
    private final IdentityHashMap<LogicalNode, String> cachedTables;
    private boolean tableServiceStarted;
    private JobSubmissionResult submitResult;
    private StreamExecutionEnvironment tableServiceEnv;
    private String tableServiceId;
    private TableServiceRegistry tableServiceRegistry;
    private final ExecutorService threadPool;
    private final ExecutionContext executeContext;
    private TableServiceClient org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient;
    private final CacheAwareRelNodePlanBuilder cachePlanBuilder;
    private volatile boolean bitmap$0;

    private String tableServiceId$lzycompute() {
        FlinkTableServiceManager flinkTableServiceManager = this;
        synchronized (flinkTableServiceManager) {
            if (!this.bitmap$0) {
                this.tableServiceId = UUID.randomUUID().toString();
                this.bitmap$0 = true;
            }
            return this.tableServiceId;
        }
    }

    private IdentityHashMap<LogicalNode, String> toBeCachedTables() {
        return this.toBeCachedTables;
    }

    public IdentityHashMap<LogicalNode, String> cachedTables() {
        return this.cachedTables;
    }

    public boolean tableServiceStarted() {
        return this.tableServiceStarted;
    }

    public void tableServiceStarted_$eq(boolean x$1) {
        this.tableServiceStarted = x$1;
    }

    public JobSubmissionResult submitResult() {
        return this.submitResult;
    }

    public void submitResult_$eq(JobSubmissionResult x$1) {
        this.submitResult = x$1;
    }

    private StreamExecutionEnvironment tableServiceEnv() {
        return this.tableServiceEnv;
    }

    private void tableServiceEnv_$eq(StreamExecutionEnvironment x$1) {
        this.tableServiceEnv = x$1;
    }

    private String tableServiceId() {
        return this.bitmap$0 ? this.tableServiceId : this.tableServiceId$lzycompute();
    }

    private TableServiceRegistry tableServiceRegistry() {
        return this.tableServiceRegistry;
    }

    private void tableServiceRegistry_$eq(TableServiceRegistry x$1) {
        this.tableServiceRegistry = x$1;
    }

    private ExecutorService threadPool() {
        return this.threadPool;
    }

    private ExecutionContext executeContext() {
        return this.executeContext;
    }

    public TableServiceClient org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient() {
        return this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient;
    }

    private void org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient_$eq(TableServiceClient x$1) {
        this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient = x$1;
    }

    public Option<TableFactory> getTableServiceFactory() {
        return Option$.MODULE$.apply((Object)this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv.getConfig().getTableServiceFactoryDescriptor().getTableFactory());
    }

    public Option<TableProperties> getTableServiceFactoryProperties() {
        return Option$.MODULE$.apply((Object)this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv.getConfig().getTableServiceFactoryDescriptor().getTableProperties());
    }

    public Option<ServiceDescriptor> getTableServiceDescriptor() {
        return Option$.MODULE$.apply((Object)this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv.getConfig().getTableServiceDescriptor());
    }

    public Map<Integer, ServiceInstance> getTableServiceInstance() {
        return this.tableServiceRegistry().getRegistedServices();
    }

    public CacheAwareRelNodePlanBuilder cachePlanBuilder() {
        return this.cachePlanBuilder;
    }

    public void org$apache$flink$table$temptable$FlinkTableServiceManager$$cacheTable(Table table, String tableUUID) {
        this.toBeCachedTables().put(table.logicalPlan(), tableUUID);
        TableSink<?> cacheSink = this.cachePlanBuilder().createCacheTableSink(tableUUID, table.logicalPlan());
        this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv.writeToSink(table, cacheSink, tableUUID);
        TableSource cacheSource = this.cachePlanBuilder().createCacheTableSource(tableUUID, table.logicalPlan());
        if (this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv.getTable(tableUUID).isEmpty()) {
            this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv.registerTableSource(tableUUID, cacheSource);
        }
    }

    public void cacheTable(Table table) {
        String name = UUID.randomUUID().toString();
        this.org$apache$flink$table$temptable$FlinkTableServiceManager$$cacheTable(table, name);
    }

    public void invalidateCache(Table table) {
        if (this.toBeCachedTables().containsKey(table.logicalPlan())) {
            String uuid2 = this.toBeCachedTables().get(table.logicalPlan());
            this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv.sinkNodes_$eq((MutableList<SinkNode>)((MutableList)this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv.sinkNodes().filter((Function1)new Serializable(this, uuid2){
                public static final long serialVersionUID = 0L;
                private final String uuid$1;

                public final boolean apply(SinkNode x$1) {
                    String string = x$1.sinkName();
                    String string2 = this.uuid$1;
                    return string != null ? !string.equals(string2) : string2 != null;
                }
                {
                    this.uuid$1 = uuid$1;
                }
            })));
            this.toBeCachedTables().remove(table.logicalPlan());
        } else if (this.cachedTables().containsKey(table.logicalPlan())) {
            String uuid3 = this.cachedTables().get(table.logicalPlan());
            this.cachedTables().remove(table.logicalPlan());
            this.deleteTable(uuid3);
        }
    }

    private void deleteTable(String tableUUID) {
        if (this.tableServiceRegistry() != null) {
            this.initClient();
            List<Integer> partitions = this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient().getPartitions(tableUUID);
            this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient().unregisterPartitions(tableUUID);
            Future$.MODULE$.apply((Function0)new Serializable(this, tableUUID, partitions){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FlinkTableServiceManager $outer;
                public final String tableUUID$1;
                private final List partitions$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.partitions$1).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$deleteTable$1 $outer;

                        public final void apply(Integer partition2) {
                            this.$outer.org$apache$flink$table$temptable$FlinkTableServiceManager$$anonfun$$$outer().org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient().deletePartition(this.$outer.tableUUID$1, Predef$.MODULE$.Integer2int(partition2));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ FlinkTableServiceManager org$apache$flink$table$temptable$FlinkTableServiceManager$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.tableUUID$1 = tableUUID$1;
                    this.partitions$1 = partitions$1;
                }
            }, this.executeContext());
        }
    }

    public void unregisterPartitions(Table table) {
        if (this.cachedTables().containsKey(table.logicalPlan())) {
            String uuid2 = this.cachedTables().get(table.logicalPlan());
            this.initClient();
            this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient().unregisterPartitions(uuid2);
        }
    }

    public void invalidateCachedTable() {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.cachedTables()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkTableServiceManager $outer;

            public final void apply(Tuple2<LogicalNode, String> x0$1) {
                Tuple2<LogicalNode, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    LogicalNode plan = (LogicalNode)tuple2._1();
                    String name = (String)tuple2._2();
                    this.$outer.org$apache$flink$table$temptable$FlinkTableServiceManager$$cacheTable(new Table(this.$outer.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv, plan), name);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.cachedTables().clear();
    }

    public void markAllTablesCached() {
        this.cachedTables().putAll(this.toBeCachedTables());
        this.toBeCachedTables().clear();
    }

    public Option<String> getToBeCachedTableName(LogicalNode logicalPlan) {
        return Option$.MODULE$.apply((Object)this.toBeCachedTables().get(logicalPlan));
    }

    public Option<String> getCachedTableName(LogicalNode logicalPlan) {
        return Option$.MODULE$.apply((Object)this.cachedTables().get(logicalPlan));
    }

    public void startTableServiceJob() {
        if (!this.toBeCachedTables().isEmpty()) {
            ServiceDescriptor descriptor = (ServiceDescriptor)this.getTableServiceDescriptor().get();
            this.startTableServiceJobInternally(descriptor);
        }
    }

    public String getTableServiceId() {
        return this.tableServiceId();
    }

    @VisibleForTesting
    public void startTableServiceJobInternally(ServiceDescriptor descriptor) {
        if (!this.tableServiceStarted()) {
            this.tableServiceRegistry_$eq(new TableServiceRegistry(descriptor.getServiceParallelism()));
            this.tableServiceRegistry().open(descriptor.getConfiguration());
            TableServiceUtil.checkRegistryServiceReady(this.tableServiceRegistry(), descriptor.getConfiguration().getInteger(TableServiceOptions.TABLE_REGISTRY_READY_RETRY_TIMES), descriptor.getConfiguration().getLong(TableServiceOptions.TABLE_REGISTRY_READY_RETRY_BACKOFF_MS));
            descriptor.getConfiguration().setString(TableServiceOptions.TABLE_SERVICE_REGISTRY_ADDRESS, this.tableServiceRegistry().getIp());
            descriptor.getConfiguration().setInteger(TableServiceOptions.TABLE_SERVICE_REGISTRY_PORT, this.tableServiceRegistry().getPort());
            StreamExecutionEnvironment executionEnv = StreamExecutionEnvironment.getExecutionEnvironment();
            executionEnv.setRestartStrategy(RestartStrategies.fixedDelayRestart(Integer.MAX_VALUE, 500L));
            descriptor.getConfiguration().setString(TableServiceOptions.TABLE_SERVICE_ID, this.tableServiceId());
            TableServiceUtil.createTableServiceJob(executionEnv, descriptor);
            this.submitResult_$eq(executionEnv.submit("FlinkTableServiceJob"));
            this.tableServiceStarted_$eq(true);
            this.tableServiceEnv_$eq(executionEnv);
            TableServiceUtil.checkTableServiceReady(this.tableServiceRegistry(), descriptor.getConfiguration().getInteger(TableServiceOptions.TABLE_SERVICE_READY_RETRY_TIMES), descriptor.getConfiguration().getLong(TableServiceOptions.TABLE_SERVICE_READY_RETRY_BACKOFF_MS));
        }
    }

    public void close() {
        if (this.tableServiceStarted()) {
            this.tableServiceEnv().stopJob(this.submitResult().getJobID());
            this.tableServiceStarted_$eq(false);
        }
        if (this.tableServiceRegistry() != null) {
            this.tableServiceRegistry().close();
            this.tableServiceRegistry_$eq(null);
        }
        TableServiceUtil.shutdownAndAwaitTermination(this.threadPool(), 10L);
        if (this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient() != null) {
            this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient().close();
            this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient_$eq(null);
        }
    }

    private void initClient() {
        if (this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient() == null) {
            this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient_$eq(new TableServiceClient());
            Configuration config = new Configuration();
            TableServiceUtil.injectTableServiceInstances(this.tableServiceRegistry().getRegistedServices(), config);
            this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tableServiceClient().open(config);
        }
    }

    public FlinkTableServiceManager(TableEnvironment tEnv) {
        this.org$apache$flink$table$temptable$FlinkTableServiceManager$$tEnv = tEnv;
        this.toBeCachedTables = new IdentityHashMap();
        this.cachedTables = new IdentityHashMap();
        this.tableServiceStarted = false;
        this.threadPool = Executors.newFixedThreadPool(1);
        this.executeContext = ExecutionContext$.MODULE$.fromExecutor((Executor)this.threadPool());
        this.cachePlanBuilder = new CacheAwareRelNodePlanBuilder(tEnv);
    }
}

