/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.temptable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.runtime.deployment.ResultPartitionLocation;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;

public class TableMetaManager {
    @GuardedBy(value="this")
    private Map<String, List<ResultPartitionID>> tableToResultPartitions = new HashMap<String, List<ResultPartitionID>>();
    @GuardedBy(value="this")
    private Map<ResultPartitionID, ResultPartitionLocation> resultPartitionMetaMap = new HashMap<ResultPartitionID, ResultPartitionLocation>();

    public synchronized void addResultPartition(String tableName, ResultPartitionID resultPartitionID) {
        List resultPartitionIDList = this.tableToResultPartitions.computeIfAbsent(tableName, key -> new ArrayList());
        resultPartitionIDList.add(resultPartitionID);
    }

    public synchronized void removeTablePartitions(String tableName) {
        this.tableToResultPartitions.remove(tableName);
    }

    public synchronized List<ResultPartitionID> getResultPartitions(String tableName) {
        return this.tableToResultPartitions.getOrDefault(tableName, Collections.emptyList());
    }

    public synchronized void addResultPartitionMeta(ResultPartitionID resultPartitionID, ResultPartitionLocation resultPartitionLocation) {
        this.resultPartitionMetaMap.put(resultPartitionID, resultPartitionLocation);
    }

    public synchronized ResultPartitionLocation getResultPartitionMeta(ResultPartitionID resultPartitionID) {
        return this.resultPartitionMetaMap.get(resultPartitionID);
    }
}

