/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.temptable.rpc;

import java.net.InetSocketAddress;
import org.apache.flink.shaded.netty4.io.netty.bootstrap.ServerBootstrap;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFuture;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInitializer;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelOption;
import org.apache.flink.shaded.netty4.io.netty.channel.EventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.socket.SocketChannel;
import org.apache.flink.shaded.netty4.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.flink.table.temptable.TableService;
import org.apache.flink.table.temptable.rpc.TableServiceServerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableServiceServer {
    private static final Logger LOG = LoggerFactory.getLogger(TableServiceServer.class);
    private TableService tableService;
    private ChannelFuture channelFuture;
    private EventLoopGroup masterGroup;
    private EventLoopGroup slaveGroup;
    private ServerBootstrap serverBootstrap;

    public TableService getTableService() {
        return this.tableService;
    }

    public void setTableService(TableService tableService) {
        this.tableService = tableService;
    }

    public int bind() {
        if (this.masterGroup == null) {
            this.masterGroup = new NioEventLoopGroup();
            this.slaveGroup = new NioEventLoopGroup();
        }
        try {
            this.serverBootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group(this.masterGroup, this.slaveGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel socketChannel) throws Exception {
                    socketChannel.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(65536, 0, 4, -4, 4)});
                    TableServiceServerHandler handler = new TableServiceServerHandler();
                    handler.setTableService(TableServiceServer.this.tableService);
                    socketChannel.pipeline().addLast(new ChannelHandler[]{handler});
                }
            });
            this.channelFuture = this.serverBootstrap.bind(0).sync();
            return ((InetSocketAddress)this.channelFuture.channel().localAddress()).getPort();
        }
        catch (Exception e2) {
            LOG.error(e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2);
        }
    }

    public void stop() {
        if (this.channelFuture != null) {
            try {
                this.channelFuture.channel().close().sync();
            }
            catch (InterruptedException e2) {
                LOG.error(e2.getMessage(), (Throwable)e2);
            }
            finally {
                if (this.masterGroup != null) {
                    this.masterGroup.shutdownGracefully();
                }
                if (this.slaveGroup != null) {
                    this.slaveGroup.shutdownGracefully();
                }
            }
        }
    }

    public void start() {
        try {
            this.channelFuture.channel().closeFuture().sync();
        }
        catch (Exception e2) {
            LOG.error(e2.getMessage(), (Throwable)e2);
        }
    }
}

