/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.util.Preconditions;

public class ArrayType
extends InternalType {
    private static final long serialVersionUID = 1L;
    private boolean isPrimitive;
    private DataType elementType;

    public ArrayType(DataType elementType) {
        this(elementType, false);
    }

    public ArrayType(DataType elementType, boolean isPrimitive) {
        this.elementType = Preconditions.checkNotNull(elementType);
        this.isPrimitive = isPrimitive;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public DataType getElementType() {
        return this.elementType;
    }

    public InternalType getElementInternalType() {
        return this.elementType.toInternalType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayType arrayType = (ArrayType)o;
        return this.isPrimitive == arrayType.isPrimitive && this.getElementInternalType().equals(arrayType.getElementInternalType());
    }

    public int hashCode() {
        int result = this.isPrimitive ? 1 : 0;
        result = 31 * result + this.getElementInternalType().hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s<%s>", this.getClass().getSimpleName(), this.elementType.toInternalType().toString());
    }
}

