/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.table.types.AtomicType;

public class GenericType<T>
extends AtomicType {
    private static final long serialVersionUID = 1L;
    private TypeInformation<T> typeInfo;
    private TypeSerializer<T> serializer;

    public GenericType(Class<T> typeClass) {
        this(new GenericTypeInfo<T>(typeClass));
    }

    public GenericType(TypeInformation<T> typeInfo) {
        this.typeInfo = typeInfo;
    }

    public TypeInformation<T> getTypeInfo() {
        return this.typeInfo;
    }

    public Class<T> getTypeClass() {
        return this.typeInfo.getTypeClass();
    }

    public TypeSerializer<T> getSerializer() {
        if (this.serializer == null) {
            this.serializer = this.typeInfo.createSerializer(new ExecutionConfig());
        }
        return this.serializer;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericType that = (GenericType)o;
        return this.typeInfo.equals(that.typeInfo);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.typeInfo.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "GenericType{" + this.typeInfo.toString() + "}";
    }
}

