/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.InternalType;

public class MapType
extends InternalType {
    private static final long serialVersionUID = 1L;
    private final DataType keyType;
    private final DataType valueType;

    public MapType(DataType keyType, DataType valueType) {
        if (keyType == null) {
            throw new IllegalArgumentException("keyType should not be null.");
        }
        if (valueType == null) {
            throw new IllegalArgumentException("valueType should not be null.");
        }
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public DataType getKeyType() {
        return this.keyType;
    }

    public DataType getValueType() {
        return this.valueType;
    }

    public InternalType getKeyInternalType() {
        return this.keyType.toInternalType();
    }

    public InternalType getValueInternalType() {
        return this.valueType.toInternalType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapType mapType = (MapType)o;
        return this.getKeyInternalType().equals(mapType.getKeyInternalType()) && this.getValueInternalType().equals(mapType.getValueInternalType());
    }

    public int hashCode() {
        int result = this.getKeyInternalType().hashCode();
        result = 31 * result + this.getValueInternalType().hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s<%s, %s>", this.getClass().getSimpleName(), this.keyType.toInternalType().toString(), this.valueType.toInternalType().toString());
    }
}

